/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.apk.Activity;
import com.miui.theme.tool.apk.ApkUtils;
import com.miui.theme.tool.gui.CheckListCheckBox;
import com.miui.theme.tool.resource.ResourceFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class IconSelectList
extends JList
implements MouseListener {
    private DefaultListModel mModel;
    private ListCellRenderer cell;
    private JCheckBox boxLastSelected;
    private ArrayList<Activity> mActivityList;
    private static final long serialVersionUID = 1L;

    public IconSelectList(ArrayList<Activity> aList) {
        this.mActivityList = aList;
        this.mModel = new DefaultListModel();
        int i = 0;
        while (i < aList.size()) {
            CheckListCheckBox box = new CheckListCheckBox(aList.get(i).getComponentName());
            this.mModel.add(i, box);
            ++i;
        }
        this.cell = new IconCellRender();
        this.setModel(this.mModel);
        this.setCellRenderer(this.cell);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JCheckBox selectBox = (JCheckBox)this.getSelectedValue();
        if (selectBox == null) {
            return;
        }
        if (this.boxLastSelected == null) {
            selectBox.setSelected(!selectBox.isSelected());
        } else {
            this.boxLastSelected.setSelected(false);
            selectBox.setSelected(!selectBox.isSelected());
        }
        if (selectBox.isSelected()) {
            this.boxLastSelected = selectBox;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public Object getSingleSelctedItem() {
        ListModel dm = this.getModel();
        int iMax = dm.getSize();
        int i = 0;
        while (i < iMax) {
            JCheckBox box = (JCheckBox)dm.getElementAt(i);
            if (box.isSelected()) {
                return this.mActivityList.get(i);
            }
            ++i;
        }
        return null;
    }

    public Activity findActivityByComponentName(String componentName) {
        for (Activity activity : this.mActivityList) {
            if (!activity.getComponentName().equals(componentName)) continue;
            return activity;
        }
        return null;
    }

    class IconCellRender
    implements ListCellRenderer {
        private JCheckBox box;

        IconCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel jp = new JPanel();
            jp.setLayout(new FlowLayout(0));
            this.box = new JCheckBox();
            if (ResourceFactory.containsKey(value.toString())) {
                this.box.setText(String.valueOf(ResourceFactory.getString(value.toString())) + " (" + value.toString() + ")");
            }
            if (isSelected) {
                this.box.setBackground(Color.GRAY);
            } else {
                this.box.setBackground(Color.WHITE);
            }
            JCheckBox selectBox = (JCheckBox)value;
            this.box.setSelected(selectBox.isSelected());
            Activity activity = IconSelectList.this.findActivityByComponentName(value.toString());
            File f = null;
            f = activity.isCache() ? new File(activity.getCacheIconPath()) : new ApkUtils().searchResource(String.valueOf(System.getProperty("user.dir")) + File.separator + activity.getPkgName(), activity.getIcon(), null);
            jp.add(this.box);
            if (f != null && f.exists()) {
                int width = 30;
                int height = 30;
                ImageIcon image = new ImageIcon(f.getAbsolutePath());
                image.setImage(image.getImage().getScaledInstance(width, height, 4));
                JLabel jl = new JLabel(image);
                jl.setMaximumSize(new Dimension(50, 50));
                jp.add(jl);
            }
            if (activity.isSameWithPackageIcon()) {
                jp.add(new JLabel(activity.getPkgName()));
            } else {
                jp.add(new JLabel(activity.getName()));
            }
            return jp;
        }
    }
}

