/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.WeakHashMap;

public class WebSwitchLayout
implements LayoutManager {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String GRIPPER = "GRIPPER";
    private Map<Component, String> constraints = new WeakHashMap<Component, String>();
    private float gripperLocation = 0.0f;

    public float getGripperLocation() {
        return this.gripperLocation;
    }

    public void setGripperLocation(float f) {
        this.gripperLocation = f;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null || !string.equals(LEFT) && !string.equals(RIGHT) && !string.equals(GRIPPER)) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be 'LEFT'/'RIGHT'/'GRIPPER' string");
        }
        this.constraints.put(component, string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public void layoutContainer(Container container) {
        boolean bl = container.getComponentOrientation().isLeftToRight();
        Insets insets = container.getInsets();
        int n = container.getWidth() - insets.left - insets.right;
        int n2 = n / 2;
        int n3 = container.getHeight() - insets.top - insets.bottom;
        int n4 = insets.left;
        int n5 = n4 + n / 2;
        int n6 = insets.top;
        for (Map.Entry<Component, String> entry : this.constraints.entrySet()) {
            String string = entry.getValue();
            if (string.equals(GRIPPER)) {
                int n7 = bl ? n4 + Math.round(this.gripperLocation * (float)n2) : n5 - Math.round(this.gripperLocation * (float)n2);
                entry.getKey().setBounds(n7, n6, n2, n3);
                continue;
            }
            if (bl && string.equals(LEFT) || !bl && string.equals(RIGHT)) {
                entry.getKey().setBounds(n4, n6, n2, n3);
                continue;
            }
            if ((!bl || !string.equals(RIGHT)) && (bl || !string.equals(LEFT))) continue;
            entry.getKey().setBounds(n5, n6, n2, n3);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        for (Map.Entry<Component, String> entry : this.constraints.entrySet()) {
            Dimension dimension = entry.getKey().getPreferredSize();
            n = Math.max(dimension.width, n);
            n2 = Math.max(dimension.height, n2);
        }
        Insets insets = container.getInsets();
        return new Dimension(insets.left + n * 2 + insets.right, insets.top + n2 + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }
}

