/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WebColorPicker
extends JComponent {
    public static final ImageIcon DEFAULT_ICON = new ImageIcon(WebColorPicker.class.getResource("icons/default.png"));
    public static final ImageIcon SWITCH_ICON = new ImageIcon(WebColorPicker.class.getResource("icons/switch.png"));
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private static final int RECT_LENGTH = 28;
    private Color border1color = new Color(192, 192, 192);
    private Color border2color = Color.WHITE;
    private Color color1 = Color.BLACK;
    private Color color2 = Color.WHITE;
    private PickerPart lastPickerPart = PickerPart.colorSwitch;

    public WebColorPicker() {
        SwingUtils.setOrientation(this);
        this.setPreferredSize(new Dimension(44, 44));
        this.initListeners();
    }

    public Color getColor() {
        return this.color1;
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color) {
        this.color1 = color;
        this.repaint();
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color) {
        this.color2 = color;
        this.repaint();
    }

    private void initListeners() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Color color;
                if (WebColorPicker.this.isSwitchUnderPoint(mouseEvent)) {
                    WebColorPicker.this.switchColors();
                } else if (WebColorPicker.this.isDefaultUnderPoint(mouseEvent)) {
                    WebColorPicker.this.setDefaultColors();
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && WebColorPicker.this.isColor1UnderPoint(mouseEvent)) {
                    Color color2 = JColorChooser.showDialog(null, "Primary color chooser", WebColorPicker.this.color1);
                    if (color2 != null) {
                        WebColorPicker.this.color1 = color2;
                        WebColorPicker.this.repaint();
                        WebColorPicker.this.fireActionPerformed();
                    }
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && WebColorPicker.this.isColor2UnderPoint(mouseEvent) && (color = JColorChooser.showDialog(null, "Secondary color chooser", WebColorPicker.this.color2)) != null) {
                    WebColorPicker.this.color2 = color;
                    WebColorPicker.this.repaint();
                    WebColorPicker.this.fireActionPerformed();
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.updateTT(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.updateTT(mouseEvent);
            }

            private void updateTT(MouseEvent mouseEvent) {
                if (WebColorPicker.this.isSwitchUnderPoint(mouseEvent)) {
                    WebColorPicker.this.updateToolTip(PickerPart.colorSwitch);
                } else if (WebColorPicker.this.isDefaultUnderPoint(mouseEvent)) {
                    WebColorPicker.this.updateToolTip(PickerPart.defaultColor);
                } else if (WebColorPicker.this.isColor1UnderPoint(mouseEvent)) {
                    WebColorPicker.this.updateToolTip(PickerPart.color1);
                } else if (WebColorPicker.this.isColor2UnderPoint(mouseEvent)) {
                    WebColorPicker.this.updateToolTip(PickerPart.color2);
                } else {
                    WebColorPicker.this.updateToolTip(null);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    private void updateToolTip(PickerPart pickerPart) {
        if (pickerPart != this.lastPickerPart) {
            this.setToolTip(pickerPart);
            this.lastPickerPart = pickerPart;
        }
    }

    public void setToolTip(PickerPart pickerPart) {
        if (pickerPart == null) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText("Switch primary and secondary colors");
        }
    }

    public void switchColors() {
        Color color = this.color2;
        this.color2 = this.color1;
        this.color1 = color;
        this.repaint();
        this.fireActionPerformed();
    }

    public void setDefaultColors() {
        this.color1 = Color.BLACK;
        this.color2 = Color.WHITE;
        this.repaint();
        this.fireActionPerformed();
    }

    private boolean isColor2UnderPoint(MouseEvent mouseEvent) {
        return (mouseEvent.getX() > 30 || mouseEvent.getY() > 30) && mouseEvent.getX() >= this.getWidth() - 1 - 28 && mouseEvent.getX() <= this.getWidth() - 5 && mouseEvent.getY() >= this.getHeight() - 1 - 28 && mouseEvent.getY() <= this.getHeight() - 5;
    }

    private boolean isColor1UnderPoint(MouseEvent mouseEvent) {
        return mouseEvent.getX() >= 4 && mouseEvent.getX() <= 28 && mouseEvent.getY() >= 4 && mouseEvent.getY() <= 28;
    }

    private boolean isDefaultUnderPoint(MouseEvent mouseEvent) {
        return mouseEvent.getX() >= 1 && mouseEvent.getX() <= 1 + DEFAULT_ICON.getIconWidth() && mouseEvent.getY() >= this.getHeight() - DEFAULT_ICON.getIconHeight() - 1 && mouseEvent.getY() <= this.getHeight() - 1;
    }

    private boolean isSwitchUnderPoint(MouseEvent mouseEvent) {
        return mouseEvent.getX() >= this.getWidth() - SWITCH_ICON.getIconWidth() - 1 && mouseEvent.getX() <= this.getWidth() - 1 && mouseEvent.getY() >= 1 && mouseEvent.getY() <= 1 + SWITCH_ICON.getIconHeight();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.isEnabled()) {
            graphics.setXORMode(Color.GRAY);
        }
        graphics.setColor(this.border1color);
        graphics.drawRect(this.getWidth() - 3 - 28, this.getHeight() - 3 - 28, 28, 28);
        graphics.setColor(this.border2color);
        graphics.drawRect(this.getWidth() - 2 - 28, this.getHeight() - 2 - 28, 26, 26);
        graphics.setColor(this.color2);
        graphics.fillRect(this.getWidth() - 1 - 28, this.getHeight() - 1 - 28, 25, 25);
        graphics.setColor(this.border1color);
        graphics.drawRect(2, 2, 28, 28);
        graphics.setColor(this.border2color);
        graphics.drawRect(3, 3, 26, 26);
        graphics.setColor(this.color1);
        graphics.fillRect(4, 4, 25, 25);
        if (!this.isEnabled()) {
            graphics.setPaintMode();
        }
        graphics.drawImage(SWITCH_ICON.getImage(), this.getWidth() - SWITCH_ICON.getIconWidth() - 1, 1, SWITCH_ICON.getImageObserver());
        graphics.drawImage(DEFAULT_ICON.getImage(), 1, this.getHeight() - DEFAULT_ICON.getIconHeight() - 1, DEFAULT_ICON.getImageObserver());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Color changed");
        for (ActionListener actionListener : CollectionUtils.copy(this.actionListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public static enum PickerPart {
        colorSwitch,
        defaultColor,
        color1,
        color2;

    }
}

