/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.laf.label.WebLabelUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;

public class WebVerticalLabelUI
extends WebLabelUI {
    private boolean clockwise;
    private Rectangle verticalViewR = new Rectangle();
    private Rectangle verticalIconR = new Rectangle();
    private Rectangle verticalTextR = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebVerticalLabelUI();
    }

    public WebVerticalLabelUI() {
        this.clockwise = false;
    }

    public WebVerticalLabelUI(boolean bl) {
        this.clockwise = bl;
    }

    public boolean isClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean bl) {
        this.clockwise = bl;
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        this.verticalViewR = this.transposeRectangle(rectangle, this.verticalViewR);
        this.verticalIconR = this.transposeRectangle(rectangle2, this.verticalIconR);
        this.verticalTextR = this.transposeRectangle(rectangle3, this.verticalTextR);
        string = super.layoutCL(jLabel, fontMetrics, string, icon, this.verticalViewR, this.verticalIconR, this.verticalTextR);
        this.copyRectangle(this.verticalViewR, rectangle);
        this.copyRectangle(this.verticalIconR, rectangle2);
        this.copyRectangle(this.verticalTextR, rectangle3);
        return string;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (jComponent.getComponentOrientation().isLeftToRight() ? this.clockwise : !this.clockwise) {
            graphics2D.rotate(1.5707963267948966, jComponent.getSize().width / 2, jComponent.getSize().width / 2);
        } else {
            graphics2D.rotate(-1.5707963267948966, jComponent.getSize().height / 2, jComponent.getSize().height / 2);
        }
        super.paint(graphics2D, jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.transposeDimension(super.getPreferredSize(jComponent));
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.transposeDimension(super.getMaximumSize(jComponent));
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.transposeDimension(super.getMinimumSize(jComponent));
    }

    private Dimension transposeDimension(Dimension dimension) {
        return new Dimension(dimension.height, dimension.width);
    }

    private Rectangle transposeRectangle(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 == null) {
            rectangle2 = new Rectangle();
        }
        rectangle2.x = rectangle.y;
        rectangle2.y = rectangle.x;
        rectangle2.width = rectangle.height;
        rectangle2.height = rectangle.width;
        return rectangle2;
    }

    private Rectangle copyRectangle(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2 == null) {
            rectangle2 = new Rectangle();
        }
        rectangle2.x = rectangle.x;
        rectangle2.y = rectangle.y;
        rectangle2.width = rectangle.width;
        rectangle2.height = rectangle.height;
        return rectangle2;
    }
}

