/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileViewType;
import com.alee.extended.list.WebFileList;
import com.alee.laf.GlobalConstants;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.FileUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.file.FileDescription;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class WebFileListCellRenderer
extends WebListCellRenderer {
    private static final int THUMBNAIL_SIZE = 50;
    private WebFileList fileList;
    private WebLabel iconLabel;
    private WebPanel descriptionPanel;
    private WebLabel nameLabel;
    private WebLabel sizeLabel;
    private WebLabel descriptionLabel;
    private static final Object thumbnailsQueueLock = new Object();
    private static List<FileElement> thumbnailsQueue = new ArrayList<FileElement>();
    private static Thread thumbnailsThread = null;

    public WebFileListCellRenderer(WebFileList webFileList) {
        this.fileList = webFileList;
        this.iconLabel = new WebLabel();
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setPreferredSize(new Dimension(54, 54));
        this.descriptionPanel = new WebPanel();
        this.descriptionPanel.setLayout(new VerticalFlowLayout(1, 0, 0, true, false));
        this.descriptionPanel.setOpaque(false);
        this.nameLabel = new WebLabel(10);
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(0));
        this.nameLabel.setForeground(Color.BLACK);
        this.nameLabel.setVerticalAlignment(0);
        this.descriptionLabel = new WebLabel(10);
        this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(0));
        this.descriptionLabel.setForeground(Color.GRAY);
        this.sizeLabel = new WebLabel(10);
        this.sizeLabel.setFont(this.sizeLabel.getFont().deriveFont(0));
        this.sizeLabel.setForeground(new Color(49, 77, 179));
        webFileList.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebFileListCellRenderer.this.updateEnabledState();
            }
        });
        this.updateFilesView();
    }

    public void updateFilesView() {
        if (this.fileList.getFileViewType().equals((Object)FileViewType.tiles)) {
            this.removeAll();
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 5, 7));
            TableLayout tableLayout = new TableLayout(new double[][]{{54.0, -1.0}, {-2.0}});
            tableLayout.setHGap(4);
            this.setLayout(tableLayout);
            this.add((Component)this.iconLabel, "0,0");
            this.add((Component)this.descriptionPanel, "1,0");
            this.setPreferredSize(new Dimension(220, 65));
            this.nameLabel.setHorizontalAlignment(10);
            this.nameLabel.setMargin(0);
        } else {
            this.removeAll();
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            TableLayout tableLayout = new TableLayout(new double[][]{{-1.0, 54.0, -1.0}, {54.0, -1.0}});
            tableLayout.setHGap(0);
            tableLayout.setVGap(4);
            this.setLayout(tableLayout);
            this.add((Component)this.iconLabel, "1,0");
            this.add((Component)this.descriptionPanel, "0,1,2,1");
            this.setPreferredSize(new Dimension(90, 90));
            this.nameLabel.setHorizontalAlignment(0);
            this.nameLabel.setMargin(0, 2, 0, 2);
        }
        this.updateFixedCellSize();
        this.updateEnabledState();
    }

    public void updateFixedCellSize() {
        if (this.fileList.getFileViewType().equals((Object)FileViewType.tiles)) {
            this.fileList.setFixedCellWidth(220);
            this.fileList.setFixedCellHeight(65);
        } else {
            this.fileList.setFixedCellWidth(90);
            this.fileList.setFixedCellHeight(90);
        }
    }

    private void updateEnabledState() {
        SwingUtils.setEnabledRecursively(this, this.fileList.isEnabled());
    }

    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    public JPanel getDescriptionPanel() {
        return this.descriptionPanel;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public JLabel getSizeLabel() {
        return this.sizeLabel;
    }

    public JLabel getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent(jList, "", n, bl, bl2);
        FileElement fileElement = (FileElement)object;
        File file = fileElement.getFile();
        String string = file.getAbsolutePath();
        String string2 = null;
        if (fileElement.isThumbnailQueued()) {
            if (fileElement.getEnabledThumbnail() != null) {
                this.iconLabel.setIcon(fileElement.getEnabledThumbnail());
                this.iconLabel.setDisabledIcon(fileElement.getDisabledThumbnail());
                string2 = fileElement.getEnabledThumbnail().getDescription();
            } else {
                this.iconLabel.setIcon(null);
                this.iconLabel.setDisabledIcon(null);
            }
        } else {
            this.queueThumbnailLoad(fileElement);
            this.iconLabel.setIcon(null);
            this.iconLabel.setDisabledIcon(null);
        }
        FileDescription fileDescription = FileUtils.getFileDescription(file, string2);
        this.descriptionPanel.removeAll();
        if (this.fileList.getEditedCell() != n) {
            this.nameLabel.setText(fileDescription.getName());
            this.descriptionPanel.add((Component)this.nameLabel);
            if (this.fileList.getFileViewType().equals((Object)FileViewType.tiles)) {
                this.descriptionLabel.setText(fileDescription.getDescription());
                this.descriptionPanel.add((Component)this.descriptionLabel);
                if (fileDescription.getSize() != null) {
                    this.sizeLabel.setText(fileDescription.getSize());
                    this.descriptionPanel.add((Component)this.sizeLabel);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueThumbnailLoad(FileElement fileElement) {
        Object object = thumbnailsQueueLock;
        synchronized (object) {
            fileElement.setThumbnailQueued(true);
            thumbnailsQueue.add(fileElement);
        }
        this.pushQueue();
    }

    private void pushQueue() {
        if (thumbnailsThread == null || !thumbnailsThread.isAlive()) {
            thumbnailsThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean bl;
                    Object object = thumbnailsQueueLock;
                    synchronized (object) {
                        bl = thumbnailsQueue.size() > 0;
                    }
                    while (bl) {
                        Object object2;
                        Object object3 = thumbnailsQueueLock;
                        synchronized (object3) {
                            object = (FileElement)thumbnailsQueue.remove(0);
                        }
                        object3 = ((FileElement)object).getFile().getAbsolutePath();
                        String string = FileUtils.getFileExtPart(((FileElement)object).getFile().getName(), false).toLowerCase();
                        if (WebFileListCellRenderer.this.fileList.isGenerateThumbnails() && GlobalConstants.IMAGE_FORMATS.contains(string)) {
                            object2 = ImageUtils.createThumbnailIcon((String)object3, 50);
                            if (object2 != null) {
                                ((FileElement)object).setEnabledThumbnail((ImageIcon)object2);
                                ((FileElement)object).setDisabledThumbnail(ImageUtils.createDisabledCopy((ImageIcon)object2));
                            } else {
                                ((FileElement)object).setEnabledThumbnail(FileUtils.getStandartFileIcon(((FileElement)object).getFile(), true, true));
                                ((FileElement)object).setDisabledThumbnail(FileUtils.getStandartFileIcon(((FileElement)object).getFile(), true, false));
                            }
                        } else {
                            ((FileElement)object).setEnabledThumbnail(FileUtils.getStandartFileIcon(((FileElement)object).getFile(), true, true));
                            ((FileElement)object).setDisabledThumbnail(FileUtils.getStandartFileIcon(((FileElement)object).getFile(), true, false));
                        }
                        WebFileListCellRenderer.this.fileList.repaint((FileElement)object);
                        object2 = thumbnailsQueueLock;
                        synchronized (object2) {
                            bl = thumbnailsQueue.size() > 0;
                        }
                    }
                }
            });
            thumbnailsThread.start();
        }
    }
}

