/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.DefaultPainter;
import com.alee.laf.StyleConstants;
import com.alee.utils.LafUtils;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class WebStylePainter<E extends JComponent>
extends DefaultPainter<E> {
    private boolean drawBackground = true;
    private int round = StyleConstants.smallRound;
    private boolean drawFocus = false;
    private int shadeWidth = StyleConstants.shadeWidth;
    private boolean fillBackground = true;
    private boolean webColored = true;

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean bl) {
        this.drawBackground = bl;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean bl) {
        this.drawFocus = bl;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
    }

    public boolean isFillBackground() {
        return this.fillBackground;
    }

    public void setFillBackground(boolean bl) {
        this.fillBackground = bl;
    }

    public boolean isWebColored() {
        return this.webColored;
    }

    public void setWebColored(boolean bl) {
        this.webColored = bl;
    }

    @Override
    public boolean isOpaque(E e) {
        return false;
    }

    @Override
    public Insets getMargin(E e) {
        return new Insets(this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1);
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, E e) {
        if (this.drawBackground) {
            LafUtils.drawWebStyle(graphics2D, e, this.drawFocus && ((Component)e).isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round, this.fillBackground, this.webColored);
        }
    }
}

