/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.progress;

import com.alee.extended.panel.WebOverlay;
import com.alee.laf.StyleConstants;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProducer;
import com.alee.utils.laf.WebShapeProducer;
import com.alee.utils.swing.EmptyMouseAdapter;
import com.alee.utils.swing.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

public class WebProgressOverlay
extends WebOverlay {
    private ShapeProducer clipShapeProducer = null;
    private int progressWidth = 15;
    private int speed = 1;
    private Color progressColor = Color.GRAY;
    private ProgressLayer progressLayer;

    public WebProgressOverlay() {
        this.initializeProgressLayer();
    }

    public WebProgressOverlay(Component component) {
        super(component);
        this.initializeProgressLayer();
    }

    protected void initializeProgressLayer() {
        this.progressLayer = new ProgressLayer();
        this.progressLayer.setVisible(false);
        this.addOverlay(this.progressLayer);
    }

    @Override
    public void setComponent(Component component) {
        super.setComponent(component);
        this.setClipShapeProducer(component != null ? new WebShapeProducer(component) : null);
    }

    public void setClipShapeProducer(ShapeProducer shapeProducer) {
        this.clipShapeProducer = shapeProducer;
    }

    public ShapeProducer getClipShapeProducer() {
        return this.clipShapeProducer;
    }

    public boolean isShowLoad() {
        return this.progressLayer.isShowLoad();
    }

    public void setShowLoad(boolean bl) {
        this.progressLayer.setShowLoad(bl);
    }

    public boolean isConsumeEvents() {
        return this.progressLayer.isConsumeEvents();
    }

    public void setConsumeEvents(boolean bl) {
        this.progressLayer.setConsumeEvents(bl);
    }

    public int getProgressWidth() {
        return this.progressWidth;
    }

    public void setProgressWidth(int n) {
        this.progressWidth = n;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public Color getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(Color color) {
        this.progressColor = color;
    }

    private class ProgressLayer
    extends JComponent {
        private boolean showLoad = false;
        private boolean consumeEvents = true;
        private Timer opacityAnimator = null;
        private Timer animator = null;
        private int opacity = 0;
        private int loadProgress = 0;

        public ProgressLayer() {
            SwingUtils.setOrientation(this);
            EmptyMouseAdapter.install(this);
        }

        @Override
        public boolean contains(int n, int n2) {
            return this.consumeEvents && super.contains(n, n2);
        }

        public boolean isConsumeEvents() {
            return this.consumeEvents;
        }

        public void setConsumeEvents(boolean bl) {
            this.consumeEvents = bl;
        }

        public boolean isShowLoad() {
            return this.showLoad;
        }

        public void setShowLoad(boolean bl) {
            this.showLoad = bl;
            if (bl) {
                this.setVisible(true);
                this.stopOpacityAnimator();
                this.opacityAnimator = new Timer("WebProgressOverlay.opacityAnimator", (long)StyleConstants.animationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ProgressLayer.this.opacity < 128) {
                            ProgressLayer.this.opacity += 8;
                        } else {
                            ProgressLayer.this.opacity = 128;
                            ProgressLayer.this.opacityAnimator.stop();
                        }
                    }
                });
                this.opacityAnimator.start();
                this.stopAnimator();
                this.animator = new Timer("WebProgressOverlay.animator", (long)StyleConstants.avgAnimationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ProgressLayer.this.loadProgress < WebProgressOverlay.this.getProgressWidth() * 2) {
                            ProgressLayer.this.loadProgress += WebProgressOverlay.this.speed;
                        } else {
                            ProgressLayer.this.loadProgress = 0;
                        }
                        if (ProgressLayer.this.isVisible()) {
                            ProgressLayer.this.repaint();
                        }
                    }
                });
                this.animator.start();
            } else {
                this.stopOpacityAnimator();
                this.opacityAnimator = new Timer("WebProgressOverlay.opacityAnimator", (long)StyleConstants.avgAnimationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ProgressLayer.this.opacity > 0) {
                            ProgressLayer.this.opacity -= 8;
                        } else {
                            ProgressLayer.this.opacity = 0;
                            ProgressLayer.this.opacityAnimator.stop();
                            ProgressLayer.this.stopAnimator();
                            ProgressLayer.this.setVisible(false);
                        }
                    }
                });
                this.opacityAnimator.start();
            }
        }

        private void stopAnimator() {
            if (this.animator != null && this.animator.isRunning()) {
                this.animator.stop();
                this.animator = null;
            }
        }

        private void stopOpacityAnimator() {
            if (this.opacityAnimator != null && this.opacityAnimator.isRunning()) {
                this.opacityAnimator.stop();
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.opacity > 0) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                int n3 = WebProgressOverlay.this.getProgressWidth();
                if (n > 0 && n2 > 0 && n3 > 0) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    LafUtils.setupAntialias(graphics2D);
                    Shape shape = this.getClipShape();
                    Shape shape2 = LafUtils.intersectClip(graphics2D, shape, shape != null);
                    graphics2D.setPaint(new Color(WebProgressOverlay.this.progressColor.getRed(), WebProgressOverlay.this.progressColor.getGreen(), WebProgressOverlay.this.progressColor.getBlue(), this.opacity));
                    for (int i = this.loadProgress % (n3 * 2); i < n + 2 * n2; i += n3 * 2) {
                        if (i <= 0) continue;
                        GeneralPath generalPath = new GeneralPath(0);
                        generalPath.moveTo(i < n ? (float)i : (float)n, i < n ? 0.0f : (float)Math.min(n2, i - n));
                        if (i - n3 < n && i > n) {
                            generalPath.lineTo(n, 0.0f);
                        }
                        generalPath.lineTo(i - n3 < n ? (float)Math.max(0, i - n3) : (float)n, i - n3 < n ? 0.0f : (float)(i - n3 - n));
                        generalPath.lineTo(i - n3 < n2 ? 0.0f : (float)(i - n3 - n2), i - n3 < n2 ? (float)Math.max(0, i - n3) : (float)n2);
                        if (i - n3 < n2 && i > n2) {
                            generalPath.lineTo(0.0f, n2);
                        }
                        generalPath.lineTo(i < n2 ? 0.0f : (float)Math.min(n, i - n2), i < n2 ? (float)i : (float)n2);
                        generalPath.closePath();
                        graphics2D.fill(generalPath);
                    }
                    LafUtils.restoreClip(graphics, shape2, shape != null);
                }
            }
        }

        private Shape getClipShape() {
            if (WebProgressOverlay.this.clipShapeProducer != null) {
                return WebProgressOverlay.this.clipShapeProducer.produce();
            }
            return null;
        }
    }
}

