/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.curtain;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionUtils;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.curtain.CurtainSlideDirection;
import com.alee.extended.transition.effects.curtain.CurtainType;
import com.alee.utils.LafUtils;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class CurtainTransitionEffect
extends DefaultTransitionEffect {
    private static final String CURTAIN_SIZE = "CURTAIN_SIZE";
    private static final String CURTAIN_MINIMUM_SPEED = "CURTAIN_MINIMUM_SPEED";
    private static final String CURTAIN_SPEED = "CURTAIN_SPEED";
    private static final String CURTAIN_FADE = "CURTAIN_FADE";
    private static final String CURTAIN_TYPE = "CURTAIN_TYPE";
    private static final String CURTAIN_SLIDE_DIRECTION = "CURTAIN_SLIDE_DIRECTION";
    private int size;
    private int minimumSpeed;
    private int speed;
    private boolean fade;
    private CurtainType type;
    private Direction direction;
    private CurtainSlideDirection slideDirection;
    private int[] progress;
    private Shape clip;

    public int getSize() {
        return this.get(CURTAIN_SIZE, 80);
    }

    public void setSize(int n) {
        this.put(CURTAIN_SIZE, n);
    }

    public int getMinimumSpeed() {
        return this.get(CURTAIN_MINIMUM_SPEED, 1);
    }

    public void setMinimumSpeed(int n) {
        this.put(CURTAIN_MINIMUM_SPEED, n);
    }

    public int getSpeed() {
        return this.get(CURTAIN_SPEED, 4);
    }

    public void setSpeed(int n) {
        this.put(CURTAIN_SPEED, n);
    }

    public boolean isFade() {
        return this.get(CURTAIN_FADE, true);
    }

    public void setFade(boolean bl) {
        this.put(CURTAIN_FADE, bl);
    }

    public CurtainType getType() {
        return this.get(CURTAIN_TYPE, CurtainType.random);
    }

    public void setType(CurtainType curtainType) {
        this.put(CURTAIN_TYPE, (Object)curtainType);
    }

    public CurtainSlideDirection getSlideDirection() {
        return this.get(CURTAIN_SLIDE_DIRECTION, CurtainSlideDirection.random);
    }

    public void setSlideDirection(CurtainSlideDirection curtainSlideDirection) {
        this.put(CURTAIN_SLIDE_DIRECTION, (Object)curtainSlideDirection);
    }

    @Override
    public void prepareAnimation(ImageTransition imageTransition) {
        this.size = this.getSize();
        this.minimumSpeed = this.getMinimumSpeed();
        this.speed = this.getSpeed();
        this.fade = this.isFade();
        this.type = TransitionUtils.getActualValue(this.getType());
        this.direction = TransitionUtils.getActualValue(this.getDirection());
        this.slideDirection = TransitionUtils.getActualValue(this.getSlideDirection());
        int n = this.direction.isVertical() ? imageTransition.getHeight() : imageTransition.getWidth();
        int n2 = (n % this.size == 0 ? n : n / this.size * this.size + this.size) / this.size;
        this.progress = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.progress[i] = 0;
        }
        if (this.direction.equals((Object)Direction.right) || this.direction.equals((Object)Direction.down)) {
            this.progress[0] = this.increaseProgress(imageTransition, 0);
        } else {
            this.progress[n2 - 1] = this.increaseProgress(imageTransition, 0);
        }
        if (this.type.equals((Object)CurtainType.fill)) {
            this.clip = this.getCurtainProgressShape(this.progress, imageTransition);
        }
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        int n = this.getMaxProgress(imageTransition);
        boolean bl = true;
        int n2 = this.progress.length;
        for (int i = 0; i < n2; ++i) {
            if (this.progress[i] >= n) continue;
            if (this.progress[i] > 0) {
                this.progress[i] = this.increaseProgress(imageTransition, this.progress[i]);
            } else if (this.canStartGrow(i, this.progress, n)) {
                this.progress[i] = this.increaseProgress(imageTransition, this.progress[i]);
            }
            if (!bl || this.progress[i] >= n) continue;
            bl = false;
        }
        if (this.type.equals((Object)CurtainType.fill)) {
            this.clip = this.getCurtainProgressShape(this.progress, imageTransition);
        }
        if (!bl) {
            imageTransition.repaint();
            return false;
        }
        this.clip = null;
        this.type = null;
        return true;
    }

    private int increaseProgress(ImageTransition imageTransition, int n) {
        int n2 = this.getMaxProgress(imageTransition);
        return Math.min(n + this.getCurrentSpeed(n, n2), n2);
    }

    private int getMaxProgress(ImageTransition imageTransition) {
        if (this.type.equals((Object)CurtainType.slide)) {
            return this.direction.isHorizontal() ? imageTransition.getHeight() : imageTransition.getWidth();
        }
        return this.size;
    }

    private int getCurrentSpeed(int n, int n2) {
        if (this.type.equals((Object)CurtainType.slide)) {
            return Math.max(this.minimumSpeed, Math.round((float)this.speed * (float)Math.sqrt((float)(n2 - n) / (float)n2)));
        }
        return this.speed;
    }

    private boolean canStartGrow(int n, int[] nArray, int n2) {
        if (this.direction.equals((Object)Direction.right) || this.direction.equals((Object)Direction.down)) {
            return n > 0 && nArray[n - 1] > n2 / 4 || n > 1 && nArray[n - 2] > n2 * 2 / 4 || n > 2 && nArray[n - 3] > n2 * 3 / 4;
        }
        return n < nArray.length - 1 && nArray[n + 1] > n2 / 4 || n < nArray.length - 2 && nArray[n + 2] > n2 * 2 / 4 || n < nArray.length - 3 && nArray[n + 3] > n2 * 3 / 4;
    }

    private Shape getCurtainProgressShape(int[] nArray, ImageTransition imageTransition) {
        GeneralPath generalPath = new GeneralPath(0);
        for (int i = 0; i < nArray.length; ++i) {
            if (this.direction.isVertical()) {
                generalPath.append(new Rectangle(0, i * this.size, imageTransition.getWidth(), nArray[i]), false);
                continue;
            }
            generalPath.append(new Rectangle(i * this.size, 0, nArray[i], imageTransition.getHeight()), false);
        }
        return generalPath;
    }

    @Override
    public void paint(Graphics2D graphics2D, ImageTransition imageTransition) {
        block5: {
            BufferedImage bufferedImage;
            int n;
            int n2;
            int n3;
            block6: {
                block4: {
                    n3 = imageTransition.getWidth();
                    n2 = imageTransition.getHeight();
                    n = this.getMaxProgress(imageTransition);
                    graphics2D.drawImage(imageTransition.getCurrentImage(), 0, 0, n3, n2, null);
                    bufferedImage = imageTransition.getOtherImage();
                    if (!this.type.equals((Object)CurtainType.fade) && (!this.type.equals((Object)CurtainType.fill) || !this.fade)) break block4;
                    int n4 = this.progress.length;
                    for (int i = 0; i < n4; ++i) {
                        Composite composite;
                        int n5;
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        int n10 = this.progress[i];
                        if (n10 <= 0) continue;
                        if (this.direction.isVertical()) {
                            n9 = 0;
                            n8 = i * this.size;
                            n7 = Math.min(n2 - i * this.size, this.type.equals((Object)CurtainType.fill) && this.fade ? n10 : this.size);
                            n6 = n9 + n3;
                            n5 = n8 + n7;
                            composite = LafUtils.setupAlphaComposite(graphics2D, (float)n10 / (float)this.size, n10 < this.size);
                            graphics2D.drawImage(bufferedImage, n9, n8, n6, n5, n9, n8, n6, n5, null);
                            LafUtils.restoreComposite(graphics2D, composite, n10 < this.size);
                            continue;
                        }
                        n9 = i * this.size;
                        n8 = 0;
                        n7 = Math.min(n3 - i * this.size, this.type.equals((Object)CurtainType.fill) && this.fade ? n10 : this.size);
                        n6 = n9 + n7;
                        n5 = n8 + n2;
                        composite = LafUtils.setupAlphaComposite(graphics2D, (float)n10 / (float)this.size, n10 < this.size);
                        graphics2D.drawImage(bufferedImage, n9, n8, n6, n5, n9, n8, n6, n5, null);
                        LafUtils.restoreComposite(graphics2D, composite, n10 < this.size);
                    }
                    break block5;
                }
                if (!this.type.equals((Object)CurtainType.fill)) break block6;
                Shape shape = LafUtils.intersectClip(graphics2D, this.clip);
                graphics2D.drawImage(bufferedImage, 0, 0, n3, n2, null);
                LafUtils.restoreClip(graphics2D, shape);
                break block5;
            }
            if (!this.type.equals((Object)CurtainType.slide)) break block5;
            int n11 = this.progress.length;
            for (int i = 0; i < n11; ++i) {
                Composite composite;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                int n17 = this.progress[i];
                if (n17 <= 0) continue;
                if (this.direction.isVertical()) {
                    n16 = this.slideDirection.equals((Object)CurtainSlideDirection.left) ? (this.direction.equals((Object)Direction.up) ? -1 : 1) : (this.slideDirection.equals((Object)CurtainSlideDirection.right) ? (this.direction.equals((Object)Direction.up) ? 1 : -1) : (i % 2 == 0 ? 1 : -1));
                    n15 = n16 * Math.round((float)n3 * ((float)n17 / (float)n)) - n16 * n3;
                    n14 = n15 + n3;
                    n13 = i * this.size;
                    n12 = n13 + Math.min(n2 - i * this.size, this.size);
                    composite = LafUtils.setupAlphaComposite(graphics2D, (float)n17 / (float)n, this.fade && n17 < n);
                    graphics2D.drawImage(bufferedImage, n15, n13, n14, n12, 0, n13, n3, n12, null);
                    LafUtils.restoreComposite(graphics2D, composite, this.fade && n17 < n);
                    continue;
                }
                n16 = this.slideDirection.equals((Object)CurtainSlideDirection.left) ? (this.direction.equals((Object)Direction.left) ? -1 : 1) : (this.slideDirection.equals((Object)CurtainSlideDirection.right) ? (this.direction.equals((Object)Direction.left) ? 1 : -1) : (i % 2 == 0 ? 1 : -1));
                n15 = i * this.size;
                n14 = n15 + Math.min(n3 - i * this.size, this.size);
                n13 = n16 * Math.round((float)n2 * ((float)n17 / (float)n)) - n16 * n2;
                n12 = n13 + n2;
                composite = LafUtils.setupAlphaComposite(graphics2D, (float)n17 / (float)n, this.fade && n17 < n);
                graphics2D.drawImage(bufferedImage, n15, n13, n14, n12, n15, 0, n14, n2, null);
                LafUtils.restoreComposite(graphics2D, composite, this.fade && n17 < n);
            }
        }
    }
}

