/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeModelListener;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeModel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AsyncTreeModel<E extends AsyncUniqueNode>
extends WebTreeModel<E> {
    protected static final String ROOT_CACHE = "root";
    protected List<AsyncTreeModelListener> asyncTreeModelListeners = new ArrayList<AsyncTreeModelListener>();
    protected WebAsyncTree<E> tree;
    protected AsyncTreeDataProvider<E> dataProvider;
    protected E rootNode = null;
    protected Map<String, Boolean> nodeCached = new HashMap<String, Boolean>();
    protected final Object cacheLock = new Object();
    protected final Object busyLock = new Object();

    public AsyncTreeModel(WebAsyncTree<E> webAsyncTree, AsyncTreeDataProvider<E> asyncTreeDataProvider) {
        super(null);
        this.tree = webAsyncTree;
        this.dataProvider = asyncTreeDataProvider;
    }

    public E getRoot() {
        if (this.rootNode == null) {
            this.rootNode = this.dataProvider.getRoot();
            this.registerObserver(this.rootNode);
        }
        return this.rootNode;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.dataProvider.isLeaf((AsyncUniqueNode)object);
    }

    @Override
    public int getChildCount(Object object) {
        AsyncUniqueNode asyncUniqueNode = (AsyncUniqueNode)object;
        if (this.nodeCached.containsKey(asyncUniqueNode.getId())) {
            return super.getChildCount(object);
        }
        this.loadChilds(asyncUniqueNode);
        return 0;
    }

    public E getChild(Object object, int n) {
        AsyncUniqueNode asyncUniqueNode = (AsyncUniqueNode)object;
        if (this.nodeCached.containsKey(asyncUniqueNode.getId())) {
            return (E)((AsyncUniqueNode)super.getChild(object, n));
        }
        return null;
    }

    @Override
    public void reload(TreeNode treeNode) {
        this.nodeCached.remove(((AsyncUniqueNode)treeNode).getId());
        super.reload(treeNode);
    }

    public AsyncTreeDataProvider<E> getDataProvider() {
        return this.dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChilds(E e) {
        Object object = this.busyLock;
        synchronized (object) {
            if (((AsyncUniqueNode)e).isBusy()) {
                return;
            }
            ((AsyncUniqueNode)e).setBusy(true);
            this.nodeChanged((TreeNode)e);
        }
        this.fireChildsLoadStarted(e);
        int n = ((DefaultMutableTreeNode)e).getChildCount();
        if (n > 0) {
            int[] nArray = new int[n];
            Object[] objectArray = new Object[n];
            for (int i = n - 1; i >= 0; --i) {
                nArray[i] = i;
                objectArray[i] = ((DefaultMutableTreeNode)e).getChildAt(i);
                ((DefaultMutableTreeNode)e).remove(i);
            }
            this.nodesWereRemoved((TreeNode)e, nArray, objectArray);
        }
        new Thread(new Runnable((AsyncUniqueNode)e){
            final /* synthetic */ AsyncUniqueNode val$node;
            {
                this.val$node = asyncUniqueNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final List<AsyncUniqueNode> list = AsyncTreeModel.this.dataProvider.getChilds(this.val$node);
                Object object = AsyncTreeModel.this.cacheLock;
                synchronized (object) {
                    AsyncTreeModel.this.nodeCached.put(this.val$node.getId(), true);
                }
                SwingUtils.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (list != null && list.size() > 0) {
                            AsyncTreeModel.this.insertNodesInto(list, val$node, 0);
                        }
                        Object object = AsyncTreeModel.this.busyLock;
                        synchronized (object) {
                            val$node.setBusy(false);
                            AsyncTreeModel.this.nodeChanged(val$node);
                        }
                        AsyncTreeModel.this.fireChildsLoadCompleted(val$node, list);
                    }
                });
            }
        }, "Async childs loader: " + ((UniqueNode)e).getId()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildNodes(E e, final List<E> list) {
        Object object = this.busyLock;
        synchronized (object) {
            if (((AsyncUniqueNode)e).isBusy()) {
                return;
            }
            ((AsyncUniqueNode)e).setBusy(true);
            this.nodeChanged((TreeNode)e);
        }
        object = this.cacheLock;
        synchronized (object) {
            this.nodeCached.put(((UniqueNode)e).getId(), true);
        }
        SwingUtils.invokeLater(new Runnable((AsyncUniqueNode)e){
            final /* synthetic */ AsyncUniqueNode val$node;
            {
                this.val$node = asyncUniqueNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (list != null && list.size() > 0) {
                    AsyncTreeModel.this.insertNodesInto(list, this.val$node, 0);
                }
                Object object = AsyncTreeModel.this.busyLock;
                synchronized (object) {
                    this.val$node.setBusy(false);
                    AsyncTreeModel.this.nodeChanged(this.val$node);
                }
                AsyncTreeModel.this.fireChildsLoadCompleted(this.val$node, list);
            }
        });
    }

    @Override
    public void insertNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n) {
        super.insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
        this.registerObserver((AsyncUniqueNode)mutableTreeNode);
    }

    @Override
    public void insertNodesInto(List<E> list, E e, int n) {
        super.insertNodesInto(list, e, n);
        for (AsyncUniqueNode asyncUniqueNode : list) {
            this.registerObserver(asyncUniqueNode);
        }
    }

    protected void registerObserver(E e) {
        ImageIcon imageIcon = ((AsyncUniqueNode)e).getLoaderIcon();
        if (imageIcon != null) {
            imageIcon.setImageObserver(new NodeImageObserver(this, this.tree, e));
        }
    }

    public List<AsyncTreeModelListener> getAsyncTreeModelListeners() {
        return this.asyncTreeModelListeners;
    }

    public void addAsyncTreeModelListener(AsyncTreeModelListener asyncTreeModelListener) {
        this.asyncTreeModelListeners.add(asyncTreeModelListener);
    }

    public void removeAsyncTreeModelListener(AsyncTreeModelListener asyncTreeModelListener) {
        this.asyncTreeModelListeners.add(asyncTreeModelListener);
    }

    protected void fireChildsLoadStarted(E e) {
        for (AsyncTreeModelListener asyncTreeModelListener : CollectionUtils.copy(this.asyncTreeModelListeners)) {
            asyncTreeModelListener.childsLoadStarted(e);
        }
    }

    protected void fireChildsLoadCompleted(E e, List<E> list) {
        for (AsyncTreeModelListener asyncTreeModelListener : CollectionUtils.copy(this.asyncTreeModelListeners)) {
            asyncTreeModelListener.childsLoadCompleted(e, list);
        }
    }

    protected static class NodeImageObserver<E extends AsyncUniqueNode>
    implements ImageObserver {
        private WebAsyncTree tree;
        private E node;
        final /* synthetic */ AsyncTreeModel this$0;

        NodeImageObserver(WebAsyncTree webAsyncTree, E e) {
            this.this$0 = var1_1;
            this.tree = webAsyncTree;
            this.node = e;
        }

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            Rectangle rectangle;
            if (((AsyncUniqueNode)this.node).isBusy() && (n & 0x30) != 0 && (rectangle = this.tree.getPathBounds(new TreePath(this.this$0.getPathToRoot((TreeNode)this.node)))) != null) {
                this.tree.repaint(rectangle);
            }
            return (n & 0xA0) == 0;
        }
    }
}

