/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.strokes;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class ShapeStroke
implements Stroke {
    private Shape[] shapes;
    private float advance;
    private boolean repeat = true;
    private AffineTransform t = new AffineTransform();
    private static final float FLATNESS = 1.0f;

    public ShapeStroke() {
        this(new Shape[]{new Ellipse2D.Float(0.0f, 0.0f, 4.0f, 4.0f)}, 8.0f);
    }

    public ShapeStroke(Shape shape, float f) {
        this(new Shape[]{shape}, f);
    }

    public ShapeStroke(Shape[] shapeArray, float f) {
        this.advance = f;
        this.shapes = new Shape[shapeArray.length];
        for (int i = 0; i < this.shapes.length; ++i) {
            Rectangle2D rectangle2D = shapeArray[i].getBounds2D();
            this.t.setToTranslation(-rectangle2D.getCenterX(), -rectangle2D.getCenterY());
            this.shapes[i] = this.t.createTransformedShape(shapeArray[i]);
        }
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath generalPath = new GeneralPath();
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n = 0;
        int n2 = this.shapes.length;
        while (n < n2 && !flatteningPathIterator.isDone()) {
            int n3 = flatteningPathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    generalPath.moveTo(f, f2);
                    f5 = 0.0f;
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    float f6 = fArray[0];
                    float f7 = fArray[1];
                    float f8 = f6 - f3;
                    float f9 = f7 - f4;
                    float f10 = (float)Math.sqrt(f8 * f8 + f9 * f9);
                    if (f10 >= f5) {
                        float f11 = 1.0f / f10;
                        float f12 = (float)Math.atan2(f9, f8);
                        while (n < n2 && f10 >= f5) {
                            float f13 = f3 + f5 * f8 * f11;
                            float f14 = f4 + f5 * f9 * f11;
                            this.t.setToTranslation(f13, f14);
                            this.t.rotate(f12);
                            generalPath.append(this.t.createTransformedShape(this.shapes[n]), false);
                            f5 += this.advance;
                            ++n;
                            if (!this.repeat) continue;
                            n %= n2;
                        }
                    }
                    f5 -= f10;
                    f3 = f6;
                    f4 = f7;
                }
            }
            flatteningPathIterator.next();
        }
        return generalPath;
    }
}

