/*
 * Decompiled with CFR 0.152.
 */
package com.alee.graphics.strokes;

import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class TextStroke
implements Stroke {
    private String text;
    private Font font;
    private boolean stretchToFit = false;
    private boolean repeat = false;
    private AffineTransform t = new AffineTransform();
    private static final float FLATNESS = 1.0f;

    public TextStroke(String string, Font font) {
        this(string, font, true, false);
    }

    public TextStroke(String string, Font font, boolean bl, boolean bl2) {
        this.text = string;
        this.font = font;
        this.stretchToFit = bl;
        this.repeat = bl2;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, this.text);
        GeneralPath generalPath = new GeneralPath();
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n = 0;
        int n2 = glyphVector.getNumGlyphs();
        if (n2 == 0) {
            return generalPath;
        }
        float f6 = this.stretchToFit ? this.measurePathLength(shape) / (float)glyphVector.getLogicalBounds().getWidth() : 1.0f;
        float f7 = 0.0f;
        while (n < n2 && !flatteningPathIterator.isDone()) {
            int n3 = flatteningPathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    generalPath.moveTo(f, f2);
                    f5 = f7 = glyphVector.getGlyphMetrics(n).getAdvance() * 0.5f;
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    float f8 = fArray[0];
                    float f9 = fArray[1];
                    float f10 = f8 - f3;
                    float f11 = f9 - f4;
                    float f12 = (float)Math.sqrt(f10 * f10 + f11 * f11);
                    if (f12 >= f5) {
                        float f13 = 1.0f / f12;
                        float f14 = (float)Math.atan2(f11, f10);
                        while (n < n2 && f12 >= f5) {
                            Shape shape2 = glyphVector.getGlyphOutline(n);
                            Point2D point2D = glyphVector.getGlyphPosition(n);
                            float f15 = (float)point2D.getX();
                            float f16 = (float)point2D.getY();
                            float f17 = f3 + f5 * f10 * f13;
                            float f18 = f4 + f5 * f11 * f13;
                            float f19 = f7;
                            f7 = n < n2 - 1 ? glyphVector.getGlyphMetrics(n + 1).getAdvance() * 0.5f : 0.0f;
                            this.t.setToTranslation(f17, f18);
                            this.t.rotate(f14);
                            this.t.translate(-f15 - f19, -f16);
                            generalPath.append(this.t.createTransformedShape(shape2), false);
                            f5 += (f19 + f7) * f6;
                            ++n;
                            if (!this.repeat) continue;
                            n %= n2;
                        }
                    }
                    f5 -= f12;
                    f3 = f8;
                    f4 = f9;
                }
            }
            flatteningPathIterator.next();
        }
        return generalPath;
    }

    public float measurePathLength(Shape shape) {
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        while (!flatteningPathIterator.isDone()) {
            int n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    float f6 = fArray[0];
                    float f7 = fArray[1];
                    float f8 = f6 - f3;
                    float f9 = f7 - f4;
                    f5 += (float)Math.sqrt(f8 * f8 + f9 * f9);
                    f3 = f6;
                    f4 = f7;
                }
            }
            flatteningPathIterator.next();
        }
        return f5;
    }
}

