/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;

@XStreamAlias(value="HSBColor")
public class HSBColor {
    @XStreamAsAttribute
    private float hue = 0.0f;
    @XStreamAsAttribute
    private float saturation = 0.0f;
    @XStreamAsAttribute
    private float brightness = 0.0f;

    public HSBColor() {
    }

    public HSBColor(float f, float f2, float f3) {
        this.hue = f;
        this.saturation = f2;
        this.brightness = f3;
    }

    public HSBColor(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public HSBColor(int n, int n2, int n3) {
        float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
        this.hue = fArray[0];
        this.saturation = fArray[1];
        this.brightness = fArray[2];
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float f) {
        this.brightness = f;
    }

    public float getHue() {
        return this.hue;
    }

    public void setHue(float f) {
        this.hue = f;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float f) {
        this.saturation = f;
    }

    public Color getColor() {
        return new Color(Color.HSBtoRGB(this.hue, this.saturation, this.brightness));
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[h=" + this.getHue() + ",s=" + this.getSaturation() + ",b=" + this.getBrightness() + "]";
    }
}

