/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicColorChooserUI;

public class WebColorChooserUI
extends BasicColorChooserUI {
    private WebColorChooserPanel colorChooserPanel;
    private ColorSelectionModel selectionModel;
    private ChangeListener modelChangeListener;
    private boolean modifying = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebColorChooserUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        this.selectionModel = this.chooser.getSelectionModel();
        this.chooser.setOpaque(false);
        this.chooser.setLayout(new BorderLayout());
        this.colorChooserPanel = new WebColorChooserPanel(false);
        this.colorChooserPanel.setColor(this.selectionModel.getSelectedColor());
        this.colorChooserPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!WebColorChooserUI.this.modifying) {
                    WebColorChooserUI.this.modifying = true;
                    WebColorChooserUI.this.selectionModel.setSelectedColor(WebColorChooserUI.this.colorChooserPanel.getColor());
                    WebColorChooserUI.this.modifying = false;
                }
            }
        });
        this.chooser.add((Component)this.colorChooserPanel, "Center");
        this.modelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!WebColorChooserUI.this.modifying) {
                    WebColorChooserUI.this.modifying = true;
                    WebColorChooserUI.this.colorChooserPanel.setColor(WebColorChooserUI.this.selectionModel.getSelectedColor());
                    WebColorChooserUI.this.modifying = false;
                }
            }
        };
        this.selectionModel.addChangeListener(this.modelChangeListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.chooser.remove(this.colorChooserPanel);
        this.chooser.setLayout(null);
        this.selectionModel.removeChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
        this.colorChooserPanel = null;
        this.selectionModel = null;
        this.chooser = null;
    }

    public boolean isShowButtonsPanel() {
        return this.colorChooserPanel.isShowButtonsPanel();
    }

    public void setShowButtonsPanel(boolean bl) {
        this.colorChooserPanel.setShowButtonsPanel(bl);
    }

    public boolean isWebOnlyColors() {
        return this.colorChooserPanel.isWebOnlyColors();
    }

    public void setWebOnlyColors(boolean bl) {
        this.colorChooserPanel.setWebOnlyColors(bl);
    }

    public Color getOldColor() {
        return this.colorChooserPanel.getOldColor();
    }

    public void setOldColor(Color color) {
        this.colorChooserPanel.setOldColor(color);
    }

    public void resetResult() {
        this.colorChooserPanel.resetResult();
    }

    public void setResult(int n) {
        this.colorChooserPanel.setResult(n);
    }

    public int getResult() {
        return this.colorChooserPanel.getResult();
    }

    public void addColorChooserListener(ColorChooserListener colorChooserListener) {
        this.colorChooserPanel.addColorChooserListener(colorChooserListener);
    }

    public void removeColorChooserListener(ColorChooserListener colorChooserListener) {
        this.colorChooserPanel.removeColorChooserListener(colorChooserListener);
    }
}

