/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.combobox;

import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.combobox.WebComboBoxCellRenderer;
import com.alee.laf.combobox.WebComboBoxStyle;
import com.alee.laf.scroll.WebScrollBarUI;
import com.alee.laf.scroll.WebScrollPaneUI;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WebComboBoxUI
extends BasicComboBoxUI
implements ShapeProvider {
    private ImageIcon expandIcon = WebComboBoxStyle.expandIcon;
    private ImageIcon collapseIcon = WebComboBoxStyle.collapseIcon;
    private int iconSpacing = WebComboBoxStyle.iconSpacing;
    private boolean drawBorder = WebComboBoxStyle.drawBorder;
    private int round = WebComboBoxStyle.round;
    private int shadeWidth = WebComboBoxStyle.shadeWidth;
    private boolean drawFocus = WebComboBoxStyle.drawFocus;
    private boolean mouseWheelScrollingEnabled = WebComboBoxStyle.mouseWheelScrollingEnabled;
    private MouseWheelListener mwl = null;
    private WebButton arrow = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        final JComboBox jComboBox = (JComboBox)jComponent;
        SwingUtils.setOrientation(jComboBox);
        jComboBox.setFocusable(true);
        jComboBox.setOpaque(false);
        this.updateBorder();
        if (!(jComboBox.getRenderer() instanceof WebComboBoxCellRenderer)) {
            jComboBox.setRenderer(new WebComboBoxCellRenderer(jComboBox));
        }
        this.mwl = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                int n2;
                if (WebComboBoxUI.this.mouseWheelScrollingEnabled && jComboBox.isEnabled() && (n2 = Math.min(Math.max(0, (n = jComboBox.getSelectedIndex()) + mouseWheelEvent.getWheelRotation()), jComboBox.getModel().getSize() - 1)) != n) {
                    jComboBox.setSelectedIndex(n2);
                }
            }
        };
        jComboBox.addMouseWheelListener(this.mwl);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removeMouseWheelListener(this.mwl);
        this.arrow = null;
        super.uninstallUI(jComponent);
    }

    public void setEditorColumns(int n) {
        if (this.editor instanceof JTextField) {
            ((JTextField)this.editor).setColumns(n);
        }
    }

    private void updateBorder() {
        if (this.drawBorder) {
            this.comboBox.setBorder(BorderFactory.createEmptyBorder(this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1));
        } else {
            this.comboBox.setBorder(null);
        }
    }

    @Override
    protected void installComponents() {
        this.comboBox.setLayout(this.createLayoutManager());
        this.arrowButton = this.createArrowButton();
        this.comboBox.add((Component)this.arrowButton, "1,0");
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add((Component)this.currentValuePane, "0,0");
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        Component component = comboBoxEditor.getEditorComponent();
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                WebComboBoxUI.this.comboBox.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebComboBoxUI.this.comboBox.repaint();
            }
        });
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.setUI(new WebTextFieldUI(jTextField, false));
            jTextField.setMargin(new Insets(0, 1, 0, 1));
        }
        return comboBoxEditor;
    }

    @Override
    protected JButton createArrowButton() {
        this.arrow = new WebButton();
        this.arrow.setUndecorated(true);
        this.arrow.setDrawFocus(false);
        this.arrow.setMoveIconOnPress(false);
        this.arrow.setName("ComboBox.arrowButton");
        this.arrow.setIcon(this.expandIcon);
        this.arrow.setLeftRightSpacing(this.iconSpacing);
        return this.arrow;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        if (this.arrowButton != null) {
            this.arrowButton.setFocusable(false);
        }
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){

            @Override
            protected JScrollPane createScroller() {
                ScrollPaneUI scrollPaneUI;
                JScrollPane jScrollPane = super.createScroller();
                if (WebLookAndFeel.isInstalled()) {
                    jScrollPane.setOpaque(false);
                    jScrollPane.getViewport().setOpaque(false);
                }
                if ((scrollPaneUI = jScrollPane.getUI()) instanceof WebScrollPaneUI) {
                    WebScrollPaneUI webScrollPaneUI = (WebScrollPaneUI)scrollPaneUI;
                    webScrollPaneUI.setDrawBorder(false);
                    ScrollBarUI scrollBarUI = jScrollPane.getVerticalScrollBar().getUI();
                    if (scrollBarUI instanceof WebScrollBarUI) {
                        WebScrollBarUI webScrollBarUI = (WebScrollBarUI)scrollBarUI;
                        webScrollBarUI.setScrollBorder(webScrollPaneUI.getDarkBorder());
                    }
                }
                return jScrollPane;
            }

            protected JList createList() {
                return super.createList();
            }

            @Override
            protected void configurePopup() {
                super.configurePopup();
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                        WebComboBoxUI.this.arrow.setIcon(WebComboBoxUI.this.collapseIcon);
                        comboBox.repaint();
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                        WebComboBoxUI.this.arrow.setIcon(WebComboBoxUI.this.expandIcon);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        WebComboBoxUI.this.arrow.setIcon(WebComboBoxUI.this.expandIcon);
                    }
                });
            }

            @Override
            public void show() {
                this.comboBox.firePopupMenuWillBecomeVisible();
                this.setListSelection(this.comboBox.getSelectedIndex());
                boolean bl = WebComboBoxUI.this.isComboboxCellEditor();
                this.setupPopupSize(bl);
                ComponentOrientation componentOrientation = this.comboBox.getComponentOrientation();
                int n = WebComboBoxUI.this.drawBorder ? WebComboBoxUI.this.shadeWidth : (bl ? -1 : 0);
                int n2 = (WebComboBoxUI.this.drawBorder ? WebComboBoxUI.this.shadeWidth : 0) - (bl ? 0 : 1);
                this.show(this.comboBox, componentOrientation.isLeftToRight() ? n : this.comboBox.getWidth() - this.getWidth() - n, this.comboBox.getHeight() - n2);
            }

            private void setupPopupSize(boolean bl) {
                Dimension dimension = this.comboBox.getSize();
                if (WebComboBoxUI.this.drawBorder) {
                    dimension.width -= WebComboBoxUI.this.shadeWidth * 2;
                }
                if (bl) {
                    dimension.width += 2;
                }
                Insets insets = this.getInsets();
                dimension.setSize(dimension.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
                Dimension dimension2 = rectangle.getSize();
                this.scroller.setMaximumSize(dimension2);
                this.scroller.setPreferredSize(dimension2);
                this.scroller.setMinimumSize(dimension2);
                this.list.revalidate();
            }

            private void setListSelection(int n) {
                if (n == -1) {
                    this.list.clearSelection();
                } else {
                    this.list.setSelectedIndex(n);
                    this.list.ensureIndexIsVisible(n);
                }
            }
        };
    }

    public boolean isComboboxCellEditor() {
        if (this.comboBox != null) {
            Object object = this.comboBox.getClientProperty("JComboBox.isTableCellEditor");
            return object != null && (Boolean)object != false;
        }
        return false;
    }

    @Override
    public Shape provideShape() {
        if (this.drawBorder) {
            return LafUtils.getWebBorderShape(this.comboBox, this.shadeWidth, this.round);
        }
        return SwingUtils.size(this.comboBox);
    }

    public ImageIcon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(ImageIcon imageIcon) {
        this.expandIcon = imageIcon;
        if (this.arrow != null && !this.isPopupVisible(this.comboBox)) {
            this.arrow.setIcon(imageIcon);
        }
    }

    public ImageIcon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(ImageIcon imageIcon) {
        this.collapseIcon = imageIcon;
        if (this.arrow != null && this.isPopupVisible(this.comboBox)) {
            this.arrow.setIcon(imageIcon);
        }
    }

    public int getIconSpacing() {
        return this.iconSpacing;
    }

    public void setIconSpacing(int n) {
        this.iconSpacing = n;
        if (this.arrow != null) {
            this.arrow.setLeftRightSpacing(n);
        }
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.updateBorder();
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean bl) {
        this.drawFocus = bl;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder();
    }

    public boolean isMouseWheelScrollingEnabled() {
        return this.mouseWheelScrollingEnabled;
    }

    public void setMouseWheelScrollingEnabled(boolean bl) {
        this.mouseWheelScrollingEnabled = bl;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
        if (!this.comboBox.isEditable()) {
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Cloneable cloneable;
        boolean bl2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.drawBorder) {
            this.comboBox.setBackground(StyleConstants.selectedBgColor);
            LafUtils.drawWebStyle(graphics2D, this.comboBox, this.drawFocus && SwingUtils.hasFocusOwner(this.comboBox) ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round, true, !this.isPopupVisible(this.comboBox));
        } else {
            bl2 = this.isPopupVisible(this.comboBox);
            cloneable = SwingUtils.size(this.comboBox);
            graphics2D.setPaint(new GradientPaint(0.0f, this.shadeWidth, bl2 ? StyleConstants.topSelectedBgColor : StyleConstants.topBgColor, 0.0f, this.comboBox.getHeight() - this.shadeWidth, bl2 ? StyleConstants.bottomSelectedBgColor : StyleConstants.bottomBgColor));
            graphics2D.fillRect(cloneable.x, cloneable.y, cloneable.width, cloneable.height);
        }
        if (this.comboBox.isEditable()) {
            bl2 = this.comboBox.getComponentOrientation().isLeftToRight();
            cloneable = this.comboBox.getInsets();
            int n = bl2 ? this.comboBox.getWidth() - ((Insets)cloneable).right - this.arrow.getWidth() - 1 : ((Insets)cloneable).left + this.arrow.getWidth();
            graphics2D.setPaint(this.comboBox.isEnabled() ? StyleConstants.borderColor : StyleConstants.disabledBorderColor);
            graphics2D.drawLine(n, ((Insets)cloneable).top + 1, n, this.comboBox.getHeight() - ((Insets)cloneable).bottom - 2);
        }
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        component.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean bl2 = false;
        if (component instanceof JPanel) {
            bl2 = true;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, n, n2, n3, n4, bl2);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new WebComboBoxLayout();
    }

    private class WebComboBoxLayout
    implements LayoutManager {
        private WebComboBoxLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return container.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return container.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            if (WebComboBoxUI.this.arrowButton != null) {
                Insets insets = WebComboBoxUI.this.getInsets();
                int n3 = n2 - (insets.top + insets.bottom);
                int n4 = ((WebComboBoxUI)WebComboBoxUI.this).arrowButton.getPreferredSize().width;
                if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    WebComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n4), insets.top, n4, n3);
                } else {
                    WebComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n4, n3);
                }
            }
            if (WebComboBoxUI.this.editor != null) {
                WebComboBoxUI.this.editor.setBounds(WebComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

