/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.optionpane;

import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.optionpane.WebOptionPaneStyle;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class WebOptionPaneUI
extends BasicOptionPaneUI {
    public static final ImageIcon INFORMATION_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/information.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/warning.png"));
    public static final ImageIcon ERROR_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/error.png"));
    public static final ImageIcon QUESTION_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/question.png"));

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebOptionPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.optionPane);
        this.optionPane.setOpaque(false);
        this.optionPane.setBackground(WebOptionPaneStyle.backgroundColor);
        this.optionPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
    }

    @Override
    protected Container createMessageArea() {
        Container container = super.createMessageArea();
        SwingUtils.setOpaqueRecursively(container, false);
        return container;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(false);
        }
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = this.getSizeButtonsToSameWidth();
            boolean bl2 = true;
            int n2 = objectArray.length;
            JButton[] jButtonArray = null;
            int n3 = 0;
            if (bl) {
                jButtonArray = new JButton[n2];
            }
            for (int i = 0; i < n2; ++i) {
                JButton jButton;
                Component component;
                Object object = objectArray[i];
                if (object instanceof Component) {
                    bl2 = false;
                    component = (Component)object;
                    container.add(component);
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof Icon ? new WebButton((Icon)object) : new WebButton(object.toString());
                    jButton.setName("OptionPane.button");
                    jButton.setMultiClickThreshhold(UIManager.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton((WebButton)jButton);
                    container.add(jButton);
                    ActionListener actionListener = this.createButtonActionListener(i);
                    if (actionListener != null) {
                        jButton.addActionListener(actionListener);
                    }
                    component = jButton;
                }
                if (bl && bl2 && component instanceof JButton) {
                    jButtonArray[i] = (JButton)component;
                    n3 = Math.max(n3, component.getMinimumSize().width);
                }
                if (i != n) continue;
                this.initialFocusComponent = component;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                jButton = (JButton)this.initialFocusComponent;
                jButton.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        JButton jButton;
                        JRootPane jRootPane;
                        if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && (jRootPane = SwingUtilities.getRootPane(jButton = (JButton)hierarchyEvent.getComponent())) != null) {
                            jRootPane.setDefaultButton(jButton);
                        }
                    }
                });
            }
            ((BasicOptionPaneUI.ButtonAreaLayout)container.getLayout()).setSyncAllWidths(bl && bl2);
        }
    }

    @Override
    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                Object[] objectArray2;
                int n = this.optionPane.getOptionType();
                if (n == 0) {
                    objectArray2 = new WebButton[2];
                    objectArray2[0] = new WebButton("");
                    objectArray2[0].setShineColor(StyleConstants.greenHighlight);
                    objectArray2[0].setLanguage("weblaf.optionpane.yes", new Object[0]);
                    objectArray2[1] = new WebButton("");
                    objectArray2[1].setShineColor(StyleConstants.redHighlight);
                    objectArray2[1].setLanguage("weblaf.optionpane.no", new Object[0]);
                } else if (n == 1) {
                    objectArray2 = new WebButton[3];
                    objectArray2[0] = new WebButton("");
                    objectArray2[0].setShineColor(StyleConstants.greenHighlight);
                    objectArray2[0].setLanguage("weblaf.optionpane.yes", new Object[0]);
                    objectArray2[1] = new WebButton("");
                    objectArray2[1].setShineColor(StyleConstants.redHighlight);
                    objectArray2[1].setLanguage("weblaf.optionpane.no", new Object[0]);
                    objectArray2[2] = new WebButton("");
                    ((WebButton)objectArray2[2]).setShineColor(StyleConstants.yellowHighlight);
                    ((WebButton)objectArray2[2]).setLanguage("weblaf.optionpane.cancel", new Object[0]);
                } else if (n == 2) {
                    objectArray2 = new WebButton[2];
                    objectArray2[0] = new WebButton("");
                    objectArray2[0].setShineColor(StyleConstants.greenHighlight);
                    objectArray2[0].setLanguage("weblaf.optionpane.ok", new Object[0]);
                    objectArray2[1] = new WebButton("");
                    objectArray2[1].setShineColor(StyleConstants.redHighlight);
                    ((WebButton)objectArray2[1]).setLanguage("weblaf.optionpane.cancel", new Object[0]);
                } else {
                    objectArray2 = new WebButton[]{new WebButton("")};
                    objectArray2[0].setShineColor(StyleConstants.greenHighlight);
                    objectArray2[0].setLanguage("weblaf.optionpane.ok", new Object[0]);
                }
                int n2 = 0;
                for (Object object : objectArray2) {
                    this.configureButton((WebButton)object);
                    ((AbstractButton)object).addActionListener(this.createButtonActionListener(n2));
                    ++n2;
                }
                return objectArray2;
            }
            return objectArray;
        }
        return null;
    }

    private void configureButton(WebButton webButton) {
        webButton.setLeftRightSpacing(10);
        webButton.setMinimumSize(new Dimension(70, 0));
        webButton.setRolloverShine(WebOptionPaneStyle.highlightControlButtons);
        Font font = UIManager.getFont("OptionPane.buttonFont");
        if (font != null) {
            webButton.setFont(font);
        }
    }

    @Override
    protected Icon getIconForType(int n) {
        return WebOptionPaneUI.getTypeIcon(n);
    }

    public static ImageIcon getTypeIcon(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        switch (n) {
            case 0: {
                return ERROR_ICON;
            }
            case 1: {
                return INFORMATION_ICON;
            }
            case 2: {
                return WARNING_ICON;
            }
            case 3: {
                return QUESTION_ICON;
            }
        }
        return null;
    }
}

