/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.proxy;

import com.alee.extended.optionpane.WebExtendedOptionPane;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.proxy.ProxySettings;
import com.alee.managers.proxy.WebProxyAuthenticator;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.CompareUtils;
import com.alee.utils.EncryptionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;

public class ProxyManager {
    public static String SETTINGS_GROUP = "ProxyManager";
    public static String PROXY_SETTINGS = "ProxySettings";
    public static String AUTO_SETTINGS_ON = "AutoSettingsOn";
    public static String ALWAYS_USE_SYSTEM_SETTINGS = "AlwaysUseSystemSettings";
    public static String SAVE_SETTINGS = "SaveSettings";
    private static Authenticator authenticator;
    private static boolean proxySet;
    private static boolean initialized;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(ProxySettings.class);
            ProxySettings proxySettings = ProxyManager.getProxySettings();
            ProxySettings proxySettings2 = ProxyManager.getSystemProxySettings();
            if (proxySettings.isUseProxy() != proxySettings2.isUseProxy() || !CompareUtils.equals(proxySettings.getProxyHost(), proxySettings2.getProxyHost()) || !CompareUtils.equals(proxySettings.getProxyPort(), proxySettings2.getProxyPort())) {
                if (ProxyManager.isAutoSettingsInitialization()) {
                    if (ProxyManager.isAlwaysUseSystemSettings()) {
                        proxySettings = proxySettings2;
                    }
                } else {
                    WebCheckBox webCheckBox = new WebCheckBox();
                    webCheckBox.setLanguage("weblaf.proxy.use.system.save", new Object[0]);
                    webCheckBox.setSelected(false);
                    webCheckBox.setFocusable(false);
                    String string = LanguageManager.get("weblaf.proxy.use.system.text");
                    String string2 = LanguageManager.get("weblaf.proxy.use.system.title");
                    WebExtendedOptionPane webExtendedOptionPane = WebExtendedOptionPane.showConfirmDialog(SwingUtils.getActiveWindow(), string, webCheckBox, string2, 0, 3);
                    int n = webExtendedOptionPane.getResult();
                    if (n == 0) {
                        proxySettings = proxySettings2;
                    }
                    if (webCheckBox.isSelected()) {
                        ProxyManager.setAutoSettingsInitialization(true);
                        ProxyManager.setAlwaysUseSystemSettings(n == 0);
                    }
                }
            }
            authenticator = new WebProxyAuthenticator();
            ProxyManager.setProxySettings(proxySettings);
        }
    }

    public static Authenticator getAuthenticator() {
        return authenticator;
    }

    public static void setAuthenticator(Authenticator authenticator) {
        ProxyManager.authenticator = authenticator;
        if (ProxyManager.getProxySettings().isUseProxy()) {
            Authenticator.setDefault(authenticator);
        }
    }

    public static void setAutoSettingsInitialization(boolean bl) {
        SettingsManager.set(SETTINGS_GROUP, AUTO_SETTINGS_ON, bl);
    }

    public static boolean isAutoSettingsInitialization() {
        return SettingsManager.get(SETTINGS_GROUP, (Object)AUTO_SETTINGS_ON, false);
    }

    public static void setAlwaysUseSystemSettings(boolean bl) {
        SettingsManager.set(SETTINGS_GROUP, ALWAYS_USE_SYSTEM_SETTINGS, bl);
    }

    public static boolean isAlwaysUseSystemSettings() {
        return SettingsManager.get(SETTINGS_GROUP, (Object)ALWAYS_USE_SYSTEM_SETTINGS, false);
    }

    public static ProxySettings getProxySettings() {
        return SettingsManager.get(SETTINGS_GROUP, (Object)PROXY_SETTINGS, ProxyManager.getSystemProxySettings());
    }

    public static void setProxySettings() {
        if (!proxySet) {
            ProxyManager.setProxySettings(ProxyManager.getProxySettings());
        }
    }

    public static void setEmptyProxySettings() {
        ProxyManager.setProxySettings(new ProxySettings());
    }

    public static ProxySettings setSystemProxySettings() {
        ProxySettings proxySettings = ProxyManager.getSystemProxySettings();
        ProxyManager.setProxySettings(proxySettings);
        return proxySettings;
    }

    public static void setProxySettings(String string, String string2) {
        ProxyManager.setProxySettings(new ProxySettings(string, string2));
    }

    public static void setProxySettings(String string, String string2, String string3, String string4) {
        ProxyManager.setProxySettings(new ProxySettings(string, string2, string3, string4));
    }

    public static void setProxySettings(ProxySettings proxySettings) {
        ProxyManager.setProxySettings(proxySettings, true);
    }

    public static void setProxySettings(ProxySettings proxySettings, boolean bl) {
        proxySet = true;
        if (bl) {
            SettingsManager.set(SETTINGS_GROUP, PROXY_SETTINGS, proxySettings);
        }
        Properties properties = System.getProperties();
        properties.setProperty("proxySet", "" + proxySettings.isUseProxy());
        if (proxySettings.isUseProxy()) {
            properties.setProperty("proxyHost", "" + proxySettings.getProxyHost());
            properties.setProperty("proxyPort", "" + proxySettings.getProxyPort());
            properties.setProperty("nonProxyHosts", "" + proxySettings.getNonProxyHosts());
            Authenticator.setDefault(authenticator);
        } else {
            properties.setProperty("proxyHost", "");
            properties.setProperty("proxyPort", "");
            properties.setProperty("nonProxyHosts", "");
            Authenticator.setDefault(null);
        }
    }

    public static URLConnection getURLConnection(URL uRL) throws IOException {
        ProxyManager.setProxySettings();
        ProxySettings proxySettings = ProxyManager.getProxySettings();
        if (proxySettings.isUseProxy()) {
            URLConnection uRLConnection = uRL.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettings.getProxyHost(), proxySettings.getProxyPortInt())));
            ProxyManager.setupProxy(uRLConnection);
            return uRLConnection;
        }
        return uRL.openConnection();
    }

    public static void setupProxy(URLConnection uRLConnection) {
        ProxyManager.setProxySettings();
        ProxySettings proxySettings = ProxyManager.getProxySettings();
        if (proxySettings.isUseProxy() && proxySettings.isUseProxyAuthentification()) {
            String string = EncryptionUtils.base64encode(proxySettings.getProxyLogin() + ":" + proxySettings.getProxyPassword());
            uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string);
        }
    }

    public static ProxySettings getSystemProxySettings() {
        InetSocketAddress inetSocketAddress;
        ProxySettings proxySettings = new ProxySettings();
        System.setProperty("java.net.useSystemProxies", "true");
        Proxy proxy = ProxyManager.getSystemHttpProxy();
        if (proxy != null && (inetSocketAddress = (InetSocketAddress)proxy.address()) != null && inetSocketAddress.getHostName() != null) {
            proxySettings.setUseProxy(true);
            proxySettings.setProxyHost(inetSocketAddress.getHostName());
            proxySettings.setProxyPort("" + inetSocketAddress.getPort());
        }
        System.setProperty("java.net.useSystemProxies", "false");
        return proxySettings;
    }

    private static Proxy getSystemHttpProxy() {
        try {
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<Proxy> list = proxySelector.select(new URI("http://www.google.com"));
            for (Proxy proxy : list) {
                if (proxy == null || !proxy.type().equals((Object)Proxy.Type.HTTP)) continue;
                return proxy;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        proxySet = false;
        initialized = false;
    }
}

