/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.extended.colorchooser.WebGradientColorChooser;
import com.alee.extended.date.WebDateField;
import com.alee.extended.panel.WebCollapsiblePane;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.managers.settings.processors.AbstractButtonSettingsProcessor;
import com.alee.managers.settings.processors.JComboBoxSettingsProcessor;
import com.alee.managers.settings.processors.JPasswordFieldSettingsProcessor;
import com.alee.managers.settings.processors.JSliderSettingsProcessor;
import com.alee.managers.settings.processors.JTextComponentSettingsProcessor;
import com.alee.managers.settings.processors.WebCollapsiblePaneSettingsProcessor;
import com.alee.managers.settings.processors.WebDateFieldSettingsProcessor;
import com.alee.managers.settings.processors.WebGradientColorChooserSettingsProcessor;
import com.alee.managers.settings.processors.WindowSettingsProcessor;
import com.alee.utils.ReflectUtils;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JSlider;
import javax.swing.text.JTextComponent;

public class ComponentSettingsManager {
    private static Map<Class, Class> settingsProcessorClasses = new LinkedHashMap<Class, Class>();
    private static Map<Component, SettingsProcessor> settingsProcessors = new HashMap<Component, SettingsProcessor>();
    private static boolean throwExceptions = true;
    private static boolean initialized = false;

    public static void initializeManager() {
        if (!initialized) {
            initialized = true;
            ComponentSettingsManager.registerSettingsProcessor(AbstractButton.class, AbstractButtonSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JComboBox.class, JComboBoxSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JSlider.class, JSliderSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JPasswordField.class, JPasswordFieldSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JTextComponent.class, JTextComponentSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(WebDateField.class, WebDateFieldSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(WebCollapsiblePane.class, WebCollapsiblePaneSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(WebGradientColorChooser.class, WebGradientColorChooserSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(Window.class, WindowSettingsProcessor.class);
        }
    }

    public static boolean isThrowExceptions() {
        return throwExceptions;
    }

    public static void setThrowExceptions(boolean bl) {
        throwExceptions = bl;
    }

    public static boolean isComponentSupported(Component component) {
        return ComponentSettingsManager.isComponentSupported(component.getClass());
    }

    public static boolean isComponentSupported(Class clazz) {
        return ComponentSettingsManager.findSuitableSettingsProcessor(clazz) != null;
    }

    public static <T extends SettingsProcessor> void registerSettingsProcessor(Class clazz, Class<T> clazz2) {
        settingsProcessorClasses.put(clazz, clazz2);
    }

    private static Class findSuitableSettingsProcessor(Class clazz) {
        for (Class clazz2 : settingsProcessorClasses.keySet()) {
            if (!ReflectUtils.isAssignable(clazz2, clazz)) continue;
            return settingsProcessorClasses.get(clazz2);
        }
        return null;
    }

    private static SettingsProcessor createSettingsProcessor(SettingsProcessorData settingsProcessorData) {
        Class clazz = ComponentSettingsManager.findSuitableSettingsProcessor(settingsProcessorData.getComponent().getClass());
        if (clazz != null) {
            try {
                return (SettingsProcessor)ReflectUtils.createInstance(clazz, settingsProcessorData);
            }
            catch (Throwable throwable) {
                if (throwExceptions) {
                    throw new RuntimeException("Cannot instantiate SettingsProcessor class: " + clazz.getCanonicalName() + ".", throwable);
                }
                return null;
            }
        }
        return null;
    }

    public static void registerComponent(SettingsProcessorData settingsProcessorData) {
        ComponentSettingsManager.unregisterComponent(settingsProcessorData.getComponent());
        SettingsProcessor settingsProcessor = ComponentSettingsManager.createSettingsProcessor(settingsProcessorData);
        if (settingsProcessor != null) {
            settingsProcessors.put(settingsProcessorData.getComponent(), settingsProcessor);
        } else if (throwExceptions) {
            throw new RuntimeException("Component type " + settingsProcessorData.getComponent().getClass().getCanonicalName() + " is not supported.");
        }
    }

    public static void loadSettings(Component component) {
        SettingsProcessor settingsProcessor = settingsProcessors.get(component);
        if (settingsProcessor != null) {
            settingsProcessor.load();
        } else if (throwExceptions) {
            throw new RuntimeException("Component " + component + " was not registered.");
        }
    }

    public static void saveSettings(Component component) {
        SettingsProcessor settingsProcessor = settingsProcessors.get(component);
        if (settingsProcessor != null) {
            settingsProcessor.save();
        } else if (throwExceptions) {
            throw new RuntimeException("Component " + component + " was not registered.");
        }
    }

    public static void unregisterComponent(Component component) {
        SettingsProcessor settingsProcessor = settingsProcessors.get(component);
        if (settingsProcessor != null) {
            settingsProcessor.destroy();
            settingsProcessors.remove(component);
        }
    }
}

