/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.laf.label.WebLabel;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.tooltip.TooltipAdapter;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TooltipManager {
    private static int defaultDelay = 500;
    private static boolean allowMultiplyTooltips = true;
    private static boolean showHotkeysInTooltips = true;
    private static boolean showHotkeysInOneTimeTooltips = false;
    private static Map<Component, List<WebCustomTooltip>> webTooltips = new WeakHashMap<Component, List<WebCustomTooltip>>();
    private static Map<Component, MouseAdapter> adapters = new WeakHashMap<Component, MouseAdapter>();
    private static Map<Component, Timer> timers = new WeakHashMap<Component, Timer>();
    private static List<WebCustomTooltip> oneTimeTooltips = new ArrayList<WebCustomTooltip>();
    private static boolean initialized = false;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            AWTEventListener aWTEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (aWTEvent instanceof MouseWheelEvent) {
                        TooltipManager.hideAllTooltips();
                    }
                }
            };
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.addAWTEventListener(aWTEventListener, 131072L);
        }
    }

    public static void hideAllTooltips() {
        Object object;
        for (Component object22 : CollectionUtils.copy(webTooltips.keySet())) {
            List<WebCustomTooltip> list;
            object = timers.get(object22);
            if (object != null) {
                ((Timer)object).stop();
            }
            if ((list = webTooltips.get(object22)) == null || list.size() <= 0) continue;
            for (WebCustomTooltip webCustomTooltip : CollectionUtils.copy(list)) {
                webCustomTooltip.closeTooltip();
            }
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(oneTimeTooltips);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (WebCustomTooltip)iterator.next();
            ((WebCustomTooltip)object).closeTooltip();
        }
    }

    public static WebCustomTooltip setTooltip(Component component, String string) {
        return TooltipManager.setTooltip(component, string, null);
    }

    public static WebCustomTooltip setTooltip(Component component, Icon icon, String string) {
        return TooltipManager.setTooltip(component, icon, string, null);
    }

    public static WebCustomTooltip setTooltip(Component component, String string, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, string, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(Component component, Icon icon, String string, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, icon, string, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(Component component, String string, TooltipWay tooltipWay, int n) {
        return TooltipManager.setTooltip(component, null, string, tooltipWay, n);
    }

    public static WebCustomTooltip setTooltip(Component component, Icon icon, String string, TooltipWay tooltipWay, int n) {
        return TooltipManager.setTooltip(component, new WebLabel(string, icon), tooltipWay, n);
    }

    public static WebCustomTooltip setTooltip(Component component, JComponent jComponent) {
        return TooltipManager.setTooltip(component, jComponent, null);
    }

    public static WebCustomTooltip setTooltip(Component component, JComponent jComponent, int n) {
        return TooltipManager.setTooltip(component, jComponent, null, n);
    }

    public static WebCustomTooltip setTooltip(Component component, JComponent jComponent, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, jComponent, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(Component component, JComponent jComponent, TooltipWay tooltipWay, int n) {
        return TooltipManager.addTooltip(component, jComponent, tooltipWay, n, true);
    }

    public static WebCustomTooltip addTooltip(Component component, String string) {
        return TooltipManager.addTooltip(component, string, null);
    }

    public static WebCustomTooltip addTooltip(Component component, Icon icon, String string) {
        return TooltipManager.addTooltip(component, icon, string, null);
    }

    public static WebCustomTooltip addTooltip(Component component, String string, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, string, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(Component component, Icon icon, String string, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, icon, string, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(Component component, String string, TooltipWay tooltipWay, int n) {
        return TooltipManager.addTooltip(component, null, string, tooltipWay, n);
    }

    public static WebCustomTooltip addTooltip(Component component, Icon icon, String string, TooltipWay tooltipWay, int n) {
        return TooltipManager.addTooltip(component, new WebLabel(string, icon), tooltipWay, n);
    }

    public static WebCustomTooltip addTooltip(Component component, JComponent jComponent) {
        return TooltipManager.addTooltip(component, jComponent, null);
    }

    public static WebCustomTooltip addTooltip(Component component, JComponent jComponent, int n) {
        return TooltipManager.addTooltip(component, jComponent, null, n);
    }

    public static WebCustomTooltip addTooltip(Component component, JComponent jComponent, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, jComponent, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(Component component, JComponent jComponent, TooltipWay tooltipWay, int n) {
        List<WebCustomTooltip> list = webTooltips.get(component);
        boolean bl = list != null && list.size() > 0 && !allowMultiplyTooltips;
        return TooltipManager.addTooltip(component, jComponent, tooltipWay, n, bl);
    }

    private static WebCustomTooltip addTooltip(final Component component, JComponent jComponent, TooltipWay tooltipWay, int n, boolean bl) {
        if (bl) {
            TooltipManager.removeTooltips(component);
        }
        if (webTooltips.get(component) == null) {
            webTooltips.put(component, new ArrayList());
        }
        WebCustomTooltip webCustomTooltip = new WebCustomTooltip(component, jComponent, tooltipWay, showHotkeysInTooltips);
        webTooltips.get(component).add(webCustomTooltip);
        if (!timers.containsKey(component) || !adapters.containsKey(component)) {
            final Timer timer = new Timer("TooltipManager.displayTimer", (long)n);
            timer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Window window = SwingUtils.getWindowAncestor(component);
                    if (window != null && window.isActive()) {
                        TooltipManager.showTooltips(component, false);
                    }
                }
            });
            timer.setRepeats(false);
            timers.put(component, timer);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    Window window = SwingUtils.getWindowAncestor(component);
                    if (window.isShowing() && window.isActive()) {
                        timer.start();
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.cancelTooltips();
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.cancelTooltips();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.cancelTooltips();
                }

                private void cancelTooltips() {
                    timer.stop();
                    TooltipManager.hideTooltips(component);
                }
            };
            component.addMouseListener(mouseAdapter);
            adapters.put(component, mouseAdapter);
        }
        return webCustomTooltip;
    }

    private static void hideTooltips(Component component) {
        if (webTooltips.get(component) != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(webTooltips.get(component));
            for (WebCustomTooltip webCustomTooltip : arrayList) {
                webCustomTooltip.closeTooltip();
            }
        }
    }

    public static boolean showTooltips(Component component) {
        return TooltipManager.showTooltips(component, false);
    }

    public static boolean showTooltips(Component component, boolean bl) {
        if (webTooltips.containsKey(component) && component.isShowing()) {
            if (bl) {
                timers.get(component).restart();
            } else {
                Window window = SwingUtils.getWindowAncestor(component);
                WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(window);
                if (webGlassPane != null) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(webTooltips.get(component));
                    for (WebCustomTooltip webCustomTooltip : arrayList) {
                        webGlassPane.showComponent(webCustomTooltip);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void showAllTooltips(Component component) {
        TooltipManager.hideAllTooltips();
        TooltipManager.showAllTooltips(SwingUtils.getWindowAncestor(component));
    }

    private static void showAllTooltips(Window window) {
        if (window.isShowing()) {
            for (Component component : webTooltips.keySet()) {
                if (SwingUtils.getWindowAncestor(component) != window || !component.isShowing()) continue;
                for (WebCustomTooltip webCustomTooltip : webTooltips.get(component)) {
                    TooltipManager.showOneTimeTooltip(webCustomTooltip, false);
                }
            }
        }
    }

    public static void showAllTooltips() {
        for (Component component : webTooltips.keySet()) {
            if (!component.isShowing()) continue;
            for (WebCustomTooltip webCustomTooltip : webTooltips.get(component)) {
                TooltipManager.showOneTimeTooltip(webCustomTooltip, false);
            }
        }
    }

    public static void installShowAllTooltipsAction(Component component) {
        TooltipManager.installShowAllTooltipsAction(component, Hotkey.F2);
    }

    public static void installShowAllTooltipsAction(final Component component, HotkeyData hotkeyData) {
        HotkeyManager.registerHotkey(component, hotkeyData, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent keyEvent) {
                TooltipManager.showAllTooltips(component);
            }
        }, true);
    }

    public static void removeTooltips(Component component) {
        if (webTooltips.get(component) != null) {
            for (WebCustomTooltip webCustomTooltip : CollectionUtils.copy((Collection)webTooltips.get(component))) {
                TooltipManager.removeTooltip(component, webCustomTooltip);
            }
        }
    }

    public static void removeTooltips(Component component, List<WebCustomTooltip> list) {
        for (WebCustomTooltip webCustomTooltip : list) {
            TooltipManager.removeTooltip(component, webCustomTooltip);
        }
    }

    public static void removeTooltip(Component component, WebCustomTooltip webCustomTooltip) {
        List<WebCustomTooltip> list = webTooltips.get(component);
        if (list != null && list.contains(webCustomTooltip)) {
            if (list.size() <= 1) {
                component.removeMouseListener(adapters.get(component));
                adapters.remove(component);
                timers.get(component).stop();
                timers.remove(component);
            }
            list.remove(webCustomTooltip);
            webCustomTooltip.closeTooltip();
            webCustomTooltip.destroyTooltip();
            if (list.size() == 0) {
                webTooltips.remove(component);
            }
        }
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, String string) {
        return TooltipManager.showOneTimeTooltip(component, point, string, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, Icon icon, String string) {
        return TooltipManager.showOneTimeTooltip(component, point, icon, string, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, String string, TooltipWay tooltipWay) {
        return TooltipManager.showOneTimeTooltip(component, point, null, string, tooltipWay);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, Icon icon, String string, TooltipWay tooltipWay) {
        WebCustomTooltip webCustomTooltip = new WebCustomTooltip(component, icon, string, tooltipWay, showHotkeysInOneTimeTooltips);
        webCustomTooltip.setDisplayLocation(point);
        return TooltipManager.showOneTimeTooltip(webCustomTooltip, true);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, JComponent jComponent) {
        return TooltipManager.showOneTimeTooltip(component, point, jComponent, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(Component component, Point point, JComponent jComponent, TooltipWay tooltipWay) {
        WebCustomTooltip webCustomTooltip = new WebCustomTooltip(component, jComponent, tooltipWay, showHotkeysInOneTimeTooltips);
        webCustomTooltip.setDisplayLocation(point);
        return TooltipManager.showOneTimeTooltip(webCustomTooltip, true);
    }

    public static WebCustomTooltip showOneTimeTooltip(WebCustomTooltip webCustomTooltip) {
        return TooltipManager.showOneTimeTooltip(webCustomTooltip, true);
    }

    private static WebCustomTooltip showOneTimeTooltip(final WebCustomTooltip webCustomTooltip, final boolean bl) {
        if (webCustomTooltip.getComponent() == null || !webCustomTooltip.getComponent().isShowing()) {
            return null;
        }
        Window window = SwingUtils.getWindowAncestor(webCustomTooltip.getComponent());
        final WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(window);
        if (webGlassPane == null) {
            return null;
        }
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                webCustomTooltip.updateLocation();
            }
        };
        webGlassPane.addComponentListener(componentAdapter);
        final AWTEventListener aWTEventListener = webCustomTooltip.isDefaultCloseBehavior() ? new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof MouseEvent && aWTEvent.getID() == 501) {
                    webCustomTooltip.closeTooltip();
                }
            }
        } : null;
        webCustomTooltip.addTooltipListener(new TooltipAdapter(){

            @Override
            public void tooltipShown() {
                if (webCustomTooltip.isDefaultCloseBehavior()) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 16L);
                }
            }

            @Override
            public void tooltipHidden() {
                webCustomTooltip.removeTooltipListener(this);
                if (webCustomTooltip.isDefaultCloseBehavior()) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
                }
                oneTimeTooltips.remove(webCustomTooltip);
                webGlassPane.removeComponentListener(componentAdapter);
                if (bl) {
                    webCustomTooltip.destroyTooltip();
                }
            }
        });
        oneTimeTooltips.add(webCustomTooltip);
        webGlassPane.showComponent(webCustomTooltip);
        return webCustomTooltip;
    }

    public static int getDefaultDelay() {
        return defaultDelay;
    }

    public static void setDefaultDelay(int n) {
        defaultDelay = n;
    }

    public static boolean isAllowMultiplyTooltips() {
        return allowMultiplyTooltips;
    }

    public static void setAllowMultiplyTooltips(boolean bl) {
        allowMultiplyTooltips = bl;
    }

    public static boolean isShowHotkeysInTooltips() {
        return showHotkeysInTooltips;
    }

    public static void setShowHotkeysInTooltips(boolean bl) {
        showHotkeysInTooltips = bl;
    }

    public static boolean isShowHotkeysInOneTimeTooltips() {
        return showHotkeysInOneTimeTooltips;
    }

    public static void setShowHotkeysInOneTimeTooltips(boolean bl) {
        showHotkeysInOneTimeTooltips = bl;
    }
}

