/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.HeadspaceMixer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

class HeadspaceSoundbank
implements Soundbank {
    String name;
    String version;
    String vendor;
    String description;
    Vector instruments = new Vector();
    Vector samples = new Vector();
    Vector sequences = new Vector();
    private long id = 0L;

    HeadspaceSoundbank(URL uRL) throws IOException {
        String string = uRL.getProtocol();
        if (!string.equals("file")) {
            InputStream inputStream = uRL.openStream();
            try {
                this.initialize(inputStream, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                inputStream.close();
                throw illegalArgumentException;
            }
        } else {
            String string2 = uRL.getFile();
            this.initialize(string2);
        }
    }

    HeadspaceSoundbank(String string) {
        this.initialize(string);
    }

    HeadspaceSoundbank(InputStream inputStream) throws IOException {
        this.initialize(inputStream, true);
    }

    HeadspaceSoundbank(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.initialize(fileInputStream, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            fileInputStream.close();
            throw illegalArgumentException;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundbankResource[] getResources() {
        SoundbankResource[] soundbankResourceArray;
        Vector vector = this.samples;
        synchronized (vector) {
            soundbankResourceArray = new SoundbankResource[this.samples.size()];
            for (int i = 0; i < soundbankResourceArray.length; ++i) {
                soundbankResourceArray[i] = (SoundbankResource)this.samples.elementAt(i);
            }
        }
        return soundbankResourceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument[] getInstruments() {
        Instrument[] instrumentArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            instrumentArray = new Instrument[this.instruments.size()];
            for (int i = 0; i < instrumentArray.length; ++i) {
                instrumentArray[i] = (Instrument)this.instruments.elementAt(i);
            }
        }
        return instrumentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument getInstrument(Patch patch) {
        Vector vector = this.instruments;
        synchronized (vector) {
            for (int i = 0; i < this.instruments.size(); ++i) {
                Instrument instrument = (Instrument)this.instruments.elementAt(i);
                if (instrument.getPatch().getBank() != patch.getBank() || instrument.getPatch().getProgram() != patch.getProgram()) continue;
                return instrument;
            }
        }
        return null;
    }

    private void setupInformation() {
        this.name = this.nGetName(this.id);
        if (this.name == null) {
            this.name = "Untitled Beatnik Soundbank";
        }
        int n = this.nGetVersionMajor(this.id);
        int n2 = this.nGetVersionMinor(this.id);
        int n3 = this.nGetVersionSubMinor(this.id);
        this.version = new String(n + "." + n2 + "." + n3);
        this.vendor = "Sun Microsystems, Beatnik";
        this.description = "Soundbank for use with Java Sound Audio Engine";
        this.nGetInstruments(this.id, this.instruments);
        this.nGetSamples(this.id, this.samples);
    }

    private void initialize(InputStream inputStream, boolean bl) throws IOException {
        HeadspaceMixer headspaceMixer = HeadspaceMixer.getMixerInstance();
        if (bl) {
            inputStream.mark(1024);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        byte[] byArray2 = null;
        int n = 0;
        boolean bl2 = false;
        int n2 = 4;
        while (true) {
            n = inputStream.read(byArray, 0, n2);
            n2 = byArray.length;
            if (n <= 0) break;
            if (!bl2) {
                if (n != 4 || (byArray[0] & 0xFF) != 73 || (byArray[1] & 0xFF) != 82 || (byArray[2] & 0xFF) != 69 || (byArray[3] & 0xFF) != 90) break;
                bl2 = true;
            }
            byteArrayOutputStream.write(byArray, 0, n);
        }
        if (bl2) {
            byArray2 = byteArrayOutputStream.toByteArray();
            this.id = this.nOpenResourceFromByteArray(byArray2, byArray2.length);
        }
        if (this.id == 0L) {
            if (bl) {
                inputStream.reset();
            }
            throw new IllegalArgumentException("unable to initialize soundbank");
        }
        this.setupInformation();
    }

    private void initialize(String string) {
        HeadspaceMixer headspaceMixer = HeadspaceMixer.getMixerInstance();
        this.id = this.nOpenResource(string);
        if (this.id == 0L) {
            throw new IllegalArgumentException("unable to load soundbank");
        }
        this.setupInformation();
    }

    private native long nOpenResource(String var1);

    private native long nOpenResourceFromByteArray(byte[] var1, int var2);

    private native boolean nCloseResource(long var1);

    private native String nGetName(long var1);

    private native int nGetVersionMajor(long var1);

    private native int nGetVersionMinor(long var1);

    private native int nGetVersionSubMinor(long var1);

    private native void nGetInstruments(long var1, Vector var3);

    private native void nGetSamples(long var1, Vector var3);
}

