/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.RIFFWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.spi.AudioFileWriter;

public class WaveFloatFileWriter
extends AudioFileWriter {
    public AudioFileFormat.Type[] getAudioFileTypes() {
        return new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};
    }

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        if (!audioInputStream.getFormat().getEncoding().equals(AudioFloatConverter.PCM_FLOAT)) {
            return new AudioFileFormat.Type[0];
        }
        return new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};
    }

    private void checkFormat(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        if (!AudioFileFormat.Type.WAVE.equals(type)) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (!audioInputStream.getFormat().getEncoding().equals(AudioFloatConverter.PCM_FLOAT)) {
            throw new IllegalArgumentException("File format " + audioInputStream.getFormat() + " not supported.");
        }
    }

    public void write(AudioInputStream audioInputStream, RIFFWriter rIFFWriter) throws IOException {
        int n;
        RIFFWriter rIFFWriter2 = rIFFWriter.writeChunk("fmt ");
        AudioFormat audioFormat = audioInputStream.getFormat();
        rIFFWriter2.writeUnsignedShort(3);
        rIFFWriter2.writeUnsignedShort(audioFormat.getChannels());
        rIFFWriter2.writeUnsignedInt((int)audioFormat.getSampleRate());
        rIFFWriter2.writeUnsignedInt((int)audioFormat.getFrameRate() * audioFormat.getFrameSize());
        rIFFWriter2.writeUnsignedShort(audioFormat.getFrameSize());
        rIFFWriter2.writeUnsignedShort(audioFormat.getSampleSizeInBits());
        rIFFWriter2.close();
        RIFFWriter rIFFWriter3 = rIFFWriter.writeChunk("data");
        byte[] byArray = new byte[1024];
        while ((n = audioInputStream.read(byArray, 0, byArray.length)) != -1) {
            rIFFWriter3.write(byArray, 0, n);
        }
        rIFFWriter3.close();
    }

    private AudioInputStream toLittleEndian(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat audioFormat2 = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), false);
        return AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        this.checkFormat(type, audioInputStream);
        if (audioInputStream.getFormat().isBigEndian()) {
            audioInputStream = this.toLittleEndian(audioInputStream);
        }
        RIFFWriter rIFFWriter = new RIFFWriter(new NoCloseOutputStream(outputStream), "WAVE");
        this.write(audioInputStream, rIFFWriter);
        int n = (int)rIFFWriter.getFilePointer();
        rIFFWriter.close();
        return n;
    }

    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        this.checkFormat(type, audioInputStream);
        if (audioInputStream.getFormat().isBigEndian()) {
            audioInputStream = this.toLittleEndian(audioInputStream);
        }
        RIFFWriter rIFFWriter = new RIFFWriter(file, "WAVE");
        this.write(audioInputStream, rIFFWriter);
        int n = (int)rIFFWriter.getFilePointer();
        rIFFWriter.close();
        return n;
    }

    private static class NoCloseOutputStream
    extends OutputStream {
        OutputStream out;

        public NoCloseOutputStream(OutputStream outputStream) {
            this.out = outputStream;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
        }
    }
}

