/*
 * Decompiled with CFR 0.152.
 */
package com.miui.home.launcher.upsidescene.data;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.miui.home.launcher.ItemInfo;
import com.miui.home.launcher.upsidescene.data.FreeStyleSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import libcore.io.IoUtils;
import miui.util.FileAccessable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class FreeButtonInfo
extends ItemInfo {
    private static final String TAG = "FreeButtonInfo";
    public static final String STATE_NORMAL = "normal";
    public static final String STATE_NORMAL_PRESSED = "normal_pressed";
    public static final String STATE_OPEN = "open";
    public static final String STATE_OPEN_PRESSED = "open_pressed";
    public static final String STATE_NORMAL_TO_OPEN = "normal_to_open";
    public static final String STATE_OPEN_TO_NORMAL = "open_to_normal";
    private static final String SUFFIX_NORMAL = "_normal";
    private static final String SUFFIX_NORMAL_PRESSED = "_normal_pressed";
    private static final String SUFFIX_OPEN = "_open";
    private static final String SUFFIX_OPEN_PRESSED = "_open_pressed";
    private static final String ROOT_TAG = "root";
    private static final String ANIMATION_LIST_TAG = "animation-list";
    private static final String ITEM_TAG = "item";
    static final String NAME_ATTR = "name";
    private static final String STATE_ATTR = "state";
    private static final String ONESHOT_ATTR = "oneshot";
    private static final String IMAGE_ATTR = "image";
    private static final String DURATION_ATTR = "duration";
    private static final String JPG_EXTENSION = ".jpg";
    private static final String PNG_EXTENSION = ".png";
    private static final String RESOURCES_DESCRIPTION_FILE = "description.xml";
    HashMap<String, Animation> mStateAnimations = new HashMap();
    FileAccessable mFile;
    String mPackageName;
    String mName;
    FileAccessable mPreviewImageName;
    Bitmap mPreviewImage;
    float mScale;
    private HashMap<FileAccessable, Bitmap> mBitmapCache = new HashMap();

    public FreeButtonInfo(FileAccessable file, String packageName, float scale) {
        this.itemType = 10;
        this.mFile = file;
        this.mPackageName = packageName;
        this.mScale = scale;
    }

    public String getName() {
        return this.mName;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    void loadIfNeed() throws XmlPullParserException, IOException {
        if (this.mStateAnimations.size() > 0) {
            return;
        }
        if (!this.mFile.exists()) {
            return;
        }
        if (this.mFile.isFile()) {
            this.mName = FreeButtonInfo.getFileNameNoEx(this.mPackageName);
            this.mPreviewImageName = this.mFile;
            this.addStaticPictureIfExists(STATE_NORMAL, this.mFile, true);
        } else if (!this.mFile.createBySubpath(RESOURCES_DESCRIPTION_FILE).exists()) {
            this.mName = this.mPackageName;
            this.mPreviewImageName = this.addStaticPictureIfExists(STATE_NORMAL, this.mFile.createBySubpath(String.valueOf(this.mPackageName) + SUFFIX_NORMAL), false);
            this.addStaticPictureIfExists(STATE_NORMAL_PRESSED, this.mFile.createBySubpath(String.valueOf(this.mPackageName) + SUFFIX_NORMAL_PRESSED), false);
            this.addStaticPictureIfExists(STATE_OPEN, this.mFile.createBySubpath(String.valueOf(this.mPackageName) + SUFFIX_OPEN), false);
            this.addStaticPictureIfExists(STATE_OPEN_PRESSED, this.mFile.createBySubpath(String.valueOf(this.mPackageName) + SUFFIX_OPEN_PRESSED), false);
        } else {
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            InputStream is = this.mFile.createBySubpath(RESOURCES_DESCRIPTION_FILE).getInputStream();
            try {
                String tag;
                parser.setInput(is, null);
                if (!ROOT_TAG.equals(FreeStyleSerializer.moveToNextStartTag(parser))) {
                    return;
                }
                this.mName = parser.getAttributeValue(null, NAME_ATTR);
                if (TextUtils.isEmpty(this.mName)) {
                    this.mName = this.mPackageName;
                }
                while ((tag = FreeStyleSerializer.moveToNextStartTag(parser)) != null) {
                    if (!ANIMATION_LIST_TAG.equals(tag)) continue;
                    Animation animation = new Animation();
                    String state = parser.getAttributeValue(null, STATE_ATTR);
                    if (TextUtils.isEmpty(state)) {
                        Log.w(TAG, "xml parse failed:free button animation must have 'state'");
                        continue;
                    }
                    String strOneshot = parser.getAttributeValue(null, ONESHOT_ATTR);
                    if (!TextUtils.isEmpty(strOneshot)) {
                        animation.oneshot = Boolean.parseBoolean(strOneshot);
                    }
                    while ((tag = FreeStyleSerializer.moveToNextStartTagOrEnd(parser, ANIMATION_LIST_TAG)) != null) {
                        if (!ITEM_TAG.equals(tag)) continue;
                        String pic = parser.getAttributeValue(null, IMAGE_ATTR);
                        if (this.mPreviewImageName == null && STATE_NORMAL.equals(state)) {
                            this.mPreviewImageName = this.mFile.createBySubpath(pic);
                        }
                        String strDuration = parser.getAttributeValue(null, DURATION_ATTR);
                        int duration = 20;
                        if (!TextUtils.isEmpty(strDuration)) {
                            try {
                                duration = Integer.parseInt(strDuration);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        animation.frames.add(new Pair<FileAccessable, Integer>(this.mFile.createBySubpath(pic), duration));
                    }
                    this.mStateAnimations.put(state, animation);
                }
            }
            finally {
                IoUtils.closeQuietly(is);
            }
        }
    }

    public static String getFileNameNoEx(String fileName) {
        int dot;
        if (!TextUtils.isEmpty(fileName) && (dot = fileName.lastIndexOf(46)) != -1) {
            return fileName.substring(0, dot);
        }
        return fileName;
    }

    private FileAccessable addStaticPictureIfExists(String state, FileAccessable file, boolean pathIncludeExtension) {
        FileAccessable finalFile = file;
        if (!pathIncludeExtension ? !(finalFile = file.createByExtension(PNG_EXTENSION)).exists() && !(finalFile = file.createByExtension(JPG_EXTENSION)).exists() : !file.exists()) {
            return null;
        }
        Animation animation = new Animation();
        animation.frames.add(new Pair<FileAccessable, Integer>(finalFile, 0));
        this.mStateAnimations.put(state, animation);
        return finalFile;
    }

    public Drawable getDrawable(String state, Context context) {
        Animation animation;
        block5: {
            this.loadIfNeed();
            animation = this.mStateAnimations.get(state);
            if (animation != null) break block5;
            return null;
        }
        try {
            if (animation.frames.size() == 1) {
                return this.getBitmapDrawable((FileAccessable)animation.frames.get((int)0).first, context);
            }
            AnimationDrawable animDrawable = new AnimationDrawable();
            animDrawable.setOneShot(animation.oneshot);
            for (Pair<FileAccessable, Integer> frame : animation.frames) {
                animDrawable.addFrame(this.getBitmapDrawable((FileAccessable)frame.first, context), (Integer)frame.second);
            }
            return animDrawable;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private BitmapDrawable getBitmapDrawable(FileAccessable file, Context context) throws IOException {
        Bitmap bitmap = FreeStyleSerializer.decodeBitmapFromFile(this.mBitmapCache, this.mScale, file);
        return new BitmapDrawable(context.getResources(), bitmap);
    }

    public String getPreviewImageName() {
        return this.mPreviewImageName.getName();
    }

    public FileAccessable getPreviewImageFile() {
        try {
            this.loadIfNeed();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mPreviewImageName;
    }

    public Bitmap getPreviewImage() {
        try {
            this.loadIfNeed();
            this.mPreviewImage = FreeStyleSerializer.decodeBitmapFromFile(this.mBitmapCache, this.mScale, this.mPreviewImageName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.mPreviewImage;
    }

    class Animation {
        public boolean oneshot = true;
        public ArrayList<Pair<FileAccessable, Integer>> frames = new ArrayList();

        Animation() {
        }
    }
}

