/*
 * Decompiled with CFR 0.152.
 */
package com.miui.home.launcher.upsidescene.data;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.android.internal.util.FastXmlSerializer;
import com.miui.home.launcher.upsidescene.data.Appearance;
import com.miui.home.launcher.upsidescene.data.FreeButtonInfo;
import com.miui.home.launcher.upsidescene.data.FreeStyle;
import com.miui.home.launcher.upsidescene.data.FreeStyleSerializable;
import com.miui.home.launcher.upsidescene.data.Function;
import com.miui.home.launcher.upsidescene.data.Screen;
import com.miui.home.launcher.upsidescene.data.Sprite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipFile;
import libcore.io.IoUtils;
import miui.util.FileAccessable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class FreeStyleSerializer
implements FreeStyleSerializable {
    public static final String TAG = "FreeStyleSerializer";
    public static final String SCENE_PERSIST_FILE_DIRECTORY = "free_style";
    private static final boolean IS_USE_FOLDER = false;
    public static String DATA_PATH = "com.miui.home.freestyle";
    public static final String DESCRIPTION_FILE = "description.xml";
    public static final String FREE_STYLE_DESCRIPTION_EDIT_FILE = "freestyle_edit";
    public static final String FREE_STYLE_DESCRIPTION_NEW_FILE = "freestyle_new";
    public static final String SCENE_TAG = "scene";
    public static final String SCENE_SCREEN_TAG = "screen";
    public static final String SCENE_NAME_ATTR = "name";
    public static final String SCENE_WIDTH_ATTR = "width";
    public static final String SCREEN_SPRITE_TAG = "sprite";
    public static final String SCREEN_HOME_ATTR = "home";
    public static final String SCREEN_WIDTH_ATTR = "width";
    public static final String SPRITE_LEFT_ATTR = "left";
    public static final String SPRITE_TOP_ATTR = "top";
    public static final String SPRITE_ROTATION_ATTR = "rotation";
    public static final String SPRITE_SCALE_X_ATTR = "scale_x";
    public static final String SPRITE_SCALE_Y_ATTR = "scale_y";
    public static final String SPRITE_WIDTH_ATTR = "width";
    public static final String SPRITE_HEIGHT_ATTR = "height";
    public static final String SPRITE_APPEARANCE_ATTR = "appearance";
    public static final String SPRITE_FUNCTION_ATTR = "function";
    public static final String SPRITE_INDEX_ATTR = "index";
    public static final String SPRITE_EDITNAME_ATTR = "_name";
    public static final String SCREEN_TYPE_ATTR = "type";
    public static final String SCREEN_TYPE_DRIFT_VAL = "drift";
    public static final String SCREEN_TYPE_BACKGROUND_VAL = "background";
    public static final String SCREEN_TYPE_FOREGROUND_VAL = "foreground";
    public static final String SCREEN_TYPE_DOCK_VAL = "dock";
    public static final String PATH_PREFIX_TOOLS = "tools";
    public static final String GADGET_DESCRIPTION_FILE_NAME = "description.xml";
    public static final String GADGET_DESCRIPTION_TITLE_TAG = "title";
    public static final String GADGET_PREVIEW_PNG_FILE_NAME = "preview/preview_cover_0.png";
    public static final String GADGET_PREVIEW_JPG_FILE_NAME = "preview/preview_cover_0.jpg";
    public static final String GADGET_PREVIEW_PNG_FILE_NAME_OLD_FORMAT = "preview/0.png";
    public static final String SIZE_VAL_MATCH_PARENT = "match_parent";
    public Context mContext;
    public String mFreeStyleName;
    public static final Comparator<Sprite> sSpriteIndexComparator = new Comparator<Sprite>(){

        @Override
        public int compare(Sprite s1, Sprite s2) {
            return s1.mIndex - s2.mIndex;
        }
    };

    public FreeStyleSerializer(Context context) {
        this.mContext = context.getApplicationContext();
    }

    @Override
    public FreeStyle load() {
        block5: {
            block4: {
                try {
                    if (new File(DATA_PATH).exists()) break block4;
                    return null;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.mFreeStyleName = this.loadFreeStyleName();
            if (!TextUtils.isEmpty(this.mFreeStyleName)) break block5;
            Log.d(TAG, "not found 'name' in scene.");
            return null;
        }
        FreeStyle originalOrEditStyle = this.loadOriginalOrEdit();
        originalOrEditStyle.mName = this.mFreeStyleName;
        FreeStyle newStyle = this.loadNew();
        this.mergeAdditionSprites(originalOrEditStyle, newStyle);
        List<FreeButtonInfo> freeButtons = this.loadAllFreeButtons();
        List<FreeStyle.MtzGadgetInfo> mtzGadgets = this.loadAllMtzGadgets();
        originalOrEditStyle.mFreeButtonInfos.addAll(freeButtons);
        originalOrEditStyle.mMtzGadgets.addAll(mtzGadgets);
        return originalOrEditStyle;
    }

    @Override
    public void save(FreeStyle freeStyle) {
        if (this.mFreeStyleName == null) {
            this.mFreeStyleName = freeStyle.mName;
        }
        this.saveFreeStyle(freeStyle, this.getEditPersistSettingsPath(this.mContext), false);
        this.saveFreeStyle(freeStyle, this.getNewPersistSettingsPath(this.mContext), true);
    }

    @Override
    public void clear(boolean alsoClearUserData) {
        File fileNew;
        File fileEdit = new File(this.getEditPersistSettingsPath(this.mContext));
        if (fileEdit.exists()) {
            fileEdit.delete();
        }
        if (alsoClearUserData && (fileNew = new File(this.getNewPersistSettingsPath(this.mContext))).exists()) {
            fileNew.delete();
        }
    }

    private static FileAccessable getFile(String fileSubpath) {
        try {
            return FileAccessable.Factory.create(DATA_PATH, fileSubpath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadFreeStyleName() {
        String string;
        FileAccessable file = FreeStyleSerializer.getFile("description.xml");
        if (!file.exists()) {
            return null;
        }
        InputStream is = null;
        try {
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            is = file.getInputStream();
            parser.setInput(is, null);
            if (!SCENE_TAG.equals(FreeStyleSerializer.moveToNextStartTag(parser))) {
                throw new RuntimeException("root tag name must be:scene");
            }
            string = parser.getAttributeValue(null, SCENE_NAME_ATTR);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(is);
                throw throwable;
            }
            IoUtils.closeQuietly(is);
            return null;
        }
        IoUtils.closeQuietly(is);
        return string;
    }

    public void saveFreeStyle(FreeStyle freeStyle, String savePath, boolean isUserCreated) {
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(savePath);
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(os, "utf-8");
                out.startDocument(null, true);
                out.startTag(null, SCENE_TAG);
                out.attribute(null, "width", Integer.toString(freeStyle.mRawWidth));
                out.attribute(null, SCENE_NAME_ATTR, freeStyle.mName);
                for (Screen screen : freeStyle.mScreens) {
                    String type;
                    out.startTag(null, SCENE_SCREEN_TAG);
                    switch (screen.getType()) {
                        case 1: {
                            type = SCREEN_TYPE_DRIFT_VAL;
                            break;
                        }
                        case 2: {
                            type = SCREEN_TYPE_BACKGROUND_VAL;
                            break;
                        }
                        case 3: {
                            type = SCREEN_TYPE_FOREGROUND_VAL;
                            break;
                        }
                        case 4: {
                            type = SCREEN_TYPE_DOCK_VAL;
                            break;
                        }
                        default: {
                            throw new RuntimeException("unknown screen type:" + screen.getType());
                        }
                    }
                    out.attribute(null, SCREEN_TYPE_ATTR, type);
                    out.attribute(null, "width", Integer.toString(screen.getWidth()));
                    out.attribute(null, SCREEN_HOME_ATTR, Integer.toString(screen.getHome()));
                    int size = screen.getSprites().size();
                    int i = 0;
                    while (i < size) {
                        Sprite sprite = screen.getSprites().get(i);
                        if (isUserCreated == sprite.mIsUserCreated) {
                            out.startTag(null, SCREEN_SPRITE_TAG);
                            out.attribute(null, SPRITE_LEFT_ATTR, Integer.toString(sprite.getLeft()));
                            out.attribute(null, SPRITE_TOP_ATTR, Integer.toString(sprite.getTop()));
                            out.attribute(null, SPRITE_EDITNAME_ATTR, sprite.getEditName());
                            out.attribute(null, SPRITE_ROTATION_ATTR, Float.toString(sprite.getRotation()));
                            out.attribute(null, SPRITE_SCALE_X_ATTR, Float.toString(sprite.getScaleX()));
                            out.attribute(null, SPRITE_SCALE_Y_ATTR, Float.toString(sprite.getScaleY()));
                            out.attribute(null, "width", Integer.toString(sprite.mRawWidth));
                            out.attribute(null, SPRITE_HEIGHT_ATTR, Integer.toString(sprite.mRawHeight));
                            out.attribute(null, SPRITE_APPEARANCE_ATTR, sprite.getAppearance().toString());
                            out.attribute(null, SPRITE_FUNCTION_ATTR, sprite.getFunction().toString());
                            out.endTag(null, SCREEN_SPRITE_TAG);
                        }
                        ++i;
                    }
                    out.endTag(null, SCENE_SCREEN_TAG);
                }
                out.endTag(null, SCENE_TAG);
                out.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException("save FreeStyle failed.", ex);
            }
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(os);
            throw throwable;
        }
        IoUtils.closeQuietly(os);
    }

    public List<FreeButtonInfo> loadAllFreeButtons() {
        ArrayList<FreeButtonInfo> freeButtons = new ArrayList<FreeButtonInfo>();
        FileAccessable folder = FreeStyleSerializer.getFile("skins/");
        List<FileAccessable> files = folder.list();
        for (FileAccessable file : files) {
            FreeButtonInfo info = new FreeButtonInfo(file, file.getName(), 1.0f);
            freeButtons.add(info);
        }
        return freeButtons;
    }

    public List<FreeStyle.MtzGadgetInfo> loadAllMtzGadgets() {
        ArrayList<FreeStyle.MtzGadgetInfo> mtzGadgets = new ArrayList<FreeStyle.MtzGadgetInfo>();
        FileAccessable folder = FreeStyleSerializer.getFile("tools/");
        List<FileAccessable> files = folder.list();
        if (files != null) {
            for (FileAccessable file : files) {
                FreeStyle.MtzGadgetInfo info = this.loadMtzGadgetInfo(file);
                if (info == null) continue;
                mtzGadgets.add(info);
            }
        }
        return mtzGadgets;
    }

    public FreeStyle.MtzGadgetInfo loadMtzGadgetInfo(FileAccessable file) {
        try {
            FileAccessable previewFile;
            String title = "";
            if (file.isFile()) {
                if (!(file instanceof FileAccessable.DeskFile)) {
                    throw new RuntimeException("mtz gadget parse failed:not support zip into zip");
                }
                ZipFile zipFile = new ZipFile(((FileAccessable.DeskFile)file).getFile());
                file = new FileAccessable.ZipInnerFile(zipFile, "/");
            }
            if (!(previewFile = file.createBySubpath(GADGET_PREVIEW_PNG_FILE_NAME)).exists() && !(previewFile = file.createBySubpath(GADGET_PREVIEW_JPG_FILE_NAME)).exists()) {
                previewFile = file.createBySubpath(GADGET_PREVIEW_PNG_FILE_NAME_OLD_FORMAT);
            }
            Bitmap previewBitmap = FreeStyleSerializer.decodeBitmapFromFile(null, 1.0f, previewFile);
            XmlPullParser descriptionXml = XmlPullParserFactory.newInstance().newPullParser();
            InputStream descriptionStream = file.createBySubpath("description.xml").getInputStream();
            try {
                String tag;
                descriptionXml.setInput(descriptionStream, null);
                while ((tag = FreeStyleSerializer.moveToNextStartTag(descriptionXml)) != null) {
                    if (!GADGET_DESCRIPTION_TITLE_TAG.equals(tag)) continue;
                    title = descriptionXml.nextText().trim();
                    break;
                }
            }
            finally {
                IoUtils.closeQuietly(descriptionStream);
            }
            FreeStyle.MtzGadgetInfo mtzInfo = new FreeStyle.MtzGadgetInfo();
            mtzInfo.path = "tools/" + file.getName();
            mtzInfo.title = title;
            mtzInfo.preview = previewBitmap;
            return mtzInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void mergeAdditionSprites(FreeStyle main, FreeStyle addition) {
        if (addition == null) {
            return;
        }
        this.mergeAdditionSpritesInScreen(main.getDriftScreen(), addition.getDriftScreen());
        this.mergeAdditionSpritesInScreen(main.getDockScreen(), addition.getDockScreen());
    }

    public void mergeAdditionSpritesInScreen(Screen screenMain, Screen screenAddition) {
        for (Sprite sprite : screenAddition.mSprites) {
            int index = Collections.binarySearch(screenMain.mSprites, sprite, sSpriteIndexComparator);
            index = index < 0 ? -1 - index : ++index;
            screenMain.mSprites.add(index, sprite);
        }
    }

    public FreeStyle loadOriginalOrEdit() throws IOException, XmlPullParserException {
        File file = new File(this.getEditPersistSettingsPath(this.mContext));
        if (!file.exists()) {
            FileAccessable originalFile = FileAccessable.Factory.create(DATA_PATH, "description.xml");
            if (!originalFile.exists()) {
                Log.e(TAG, "file not exists. file:" + file.toString());
                return null;
            }
            return this.loadFreeStyle(originalFile.getInputStream(), false);
        }
        return this.loadFreeStyle(new FileInputStream(file), false);
    }

    public FreeStyle loadNew() throws XmlPullParserException, IOException {
        File fileNew = new File(this.getNewPersistSettingsPath(this.mContext));
        if (!fileNew.exists()) {
            return null;
        }
        return this.loadFreeStyle(new FileInputStream(fileNew), true);
    }

    public FreeStyle loadFreeStyle(InputStream is, boolean isUserCreated) throws XmlPullParserException, IOException {
        if (is == null) {
            return null;
        }
        try {
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput(is, null);
            FreeStyle freeStyle = this.loadFreeStyle(parser, isUserCreated);
            return freeStyle;
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    public FreeStyle loadFreeStyle(XmlPullParser parser, boolean isUserCreated) throws XmlPullParserException, IOException {
        String tag;
        FreeStyle freeStyle = new FreeStyle();
        this.loadCurrentSceneDescription(freeStyle, parser);
        while ((tag = FreeStyleSerializer.moveToNextStartTagOrEnd(parser, SCENE_TAG)) != null) {
            if (tag.equals(SCENE_SCREEN_TAG)) {
                Screen screen = this.loadScreen(parser, isUserCreated, freeStyle.getSceneScale());
                if (screen == null) continue;
                freeStyle.mScreens.add(screen);
                continue;
            }
            Log.w(TAG, "unknown tag:" + tag);
        }
        return freeStyle;
    }

    public Screen loadScreen(XmlPullParser parser, boolean isUserCreated, float sceneScale) throws XmlPullParserException, IOException {
        String tag;
        Screen screen = new Screen();
        String type = parser.getAttributeValue(null, SCREEN_TYPE_ATTR);
        if (SCREEN_TYPE_DRIFT_VAL.equals(type)) {
            screen.mType = 1;
        } else if (SCREEN_TYPE_BACKGROUND_VAL.equals(type)) {
            screen.mType = 2;
        } else if (SCREEN_TYPE_FOREGROUND_VAL.equals(type)) {
            screen.mType = 3;
        } else if (SCREEN_TYPE_DOCK_VAL.equals(type)) {
            screen.mType = 4;
        } else {
            Log.w(TAG, "unknown screen type:" + type);
            return null;
        }
        screen.mWidth = this.parseIntValue(parser.getAttributeValue(null, "width"));
        screen.mHome = this.parseIntValue(parser.getAttributeValue(null, SCREEN_HOME_ATTR));
        while ((tag = FreeStyleSerializer.moveToNextStartTagOrEnd(parser, SCENE_SCREEN_TAG)) != null) {
            if (SCREEN_SPRITE_TAG.equals(tag)) {
                Sprite sprite = this.loadSprite(parser, isUserCreated, sceneScale);
                if (sprite == null) continue;
                screen.mSprites.add(sprite);
                continue;
            }
            Log.w(TAG, "unknown tag:" + tag);
        }
        return screen;
    }

    public Sprite loadSprite(XmlPullParser parser, boolean isUserCreated, float sceneScale) throws IOException {
        Sprite sprite = new Sprite();
        sprite.mIsUserCreated = isUserCreated;
        sprite.mLeft = this.parseIntValue(parser.getAttributeValue(null, SPRITE_LEFT_ATTR));
        sprite.mTop = this.parseIntValue(parser.getAttributeValue(null, SPRITE_TOP_ATTR));
        sprite.mRotation = this.parseFloatValue(parser.getAttributeValue(null, SPRITE_ROTATION_ATTR), 0.0f);
        sprite.mScaleX = this.parseFloatValue(parser.getAttributeValue(null, SPRITE_SCALE_X_ATTR), 0.0f);
        sprite.mScaleY = this.parseFloatValue(parser.getAttributeValue(null, SPRITE_SCALE_Y_ATTR), 0.0f);
        sprite.mRawWidth = this.parseIntValue(parser.getAttributeValue(null, "width"));
        sprite.mRawHeight = this.parseIntValue(parser.getAttributeValue(null, SPRITE_HEIGHT_ATTR));
        sprite.mEditName = parser.getAttributeValue(null, SPRITE_EDITNAME_ATTR);
        if (sprite.mRawWidth > 0 && sprite.mRawHeight > 0) {
            sprite.mWidth = FreeStyleSerializer.calcSize(sprite.mRawWidth, sceneScale);
            sprite.mHeight = FreeStyleSerializer.calcSize(sprite.mRawHeight, sceneScale);
        }
        sprite.mAppearance = Appearance.load(parser.getAttributeValue(null, SPRITE_APPEARANCE_ATTR), sceneScale);
        sprite.mFunction = Function.parse(parser.getAttributeValue(null, SPRITE_FUNCTION_ATTR));
        sprite.mIndex = this.parseIntValue(parser.getAttributeValue(null, SPRITE_INDEX_ATTR));
        return sprite;
    }

    public void loadCurrentSceneDescription(FreeStyle freeStyle, XmlPullParser parser) throws XmlPullParserException, IOException {
        if (!SCENE_TAG.equals(FreeStyleSerializer.moveToNextStartTag(parser))) {
            throw new RuntimeException("root tag name must be:scene");
        }
        DisplayMetrics dm = this.mContext.getResources().getDisplayMetrics();
        freeStyle.mHeight = dm.heightPixels;
        freeStyle.mWidth = dm.widthPixels;
        freeStyle.mRawWidth = this.parseIntValue(parser.getAttributeValue(null, "width"));
        freeStyle.mSceneScale = (float)freeStyle.mWidth / (float)freeStyle.mRawWidth;
    }

    public float parseFloatValue(String value, float defaultValue) {
        if (TextUtils.isEmpty(value)) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    public int parseIntValue(String value) {
        if (TextUtils.isEmpty(value)) {
            return 0;
        }
        if (value.equalsIgnoreCase(SIZE_VAL_MATCH_PARENT)) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getPersistDirectory(Context context) {
        return String.valueOf(context.getDir(SCENE_PERSIST_FILE_DIRECTORY, Context.MODE_WORLD_WRITEABLE).getAbsolutePath()) + "/" + this.mFreeStyleName;
    }

    public String getEditPersistSettingsPath(Context context) {
        String dir = this.getPersistDirectory(context);
        if (dir != null) {
            File file = new File(this.getPersistDirectory(context));
            if (!file.exists()) {
                file.mkdirs();
            }
            return String.valueOf(this.getPersistDirectory(context)) + "/" + FREE_STYLE_DESCRIPTION_EDIT_FILE;
        }
        return null;
    }

    public String getNewPersistSettingsPath(Context context) {
        String dir = this.getPersistDirectory(context);
        if (dir != null) {
            File file = new File(this.getPersistDirectory(context));
            if (!file.exists()) {
                file.mkdirs();
            }
            return String.valueOf(this.getPersistDirectory(context)) + "/" + FREE_STYLE_DESCRIPTION_NEW_FILE;
        }
        return null;
    }

    public static String moveToNextStartTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        return FreeStyleSerializer.moveToNextStartTagOrEnd(parser, null);
    }

    public static String moveToNextStartTagOrEnd(XmlPullParser parser, String endTag) throws XmlPullParserException, IOException {
        int eventType;
        while ((eventType = parser.next()) != 2 && eventType != 1) {
            if (endTag == null || eventType != 3 || !endTag.equals(parser.getName())) continue;
            return null;
        }
        return eventType == 1 ? null : parser.getName().trim();
    }

    public static Bitmap decodeBitmapFromFile(HashMap<FileAccessable, Bitmap> bitmapCache, float sceneScale, FileAccessable file) throws IOException {
        return null;
    }

    static int calcSize(int rawSize, float sceneScale) {
        return (int)((float)rawSize * sceneScale + 0.5f);
    }
}

