/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SelectThemeFolderDialog
extends Observable
implements ActionListener {
    private JDialog mDialog;
    private JButton scanBtn;
    private JButton saveBtn;
    private JButton cancelBtn;
    private JTextField mNameField;
    private JTextField mPathField;
    private Container mParent;
    private String mMtzFilePath;
    private String mMtzFileName;

    public SelectThemeFolderDialog(Container parentContainer, String mtzFilePath, String mtzFileName) {
        this.mMtzFilePath = mtzFilePath;
        this.mMtzFileName = mtzFileName;
        this.mDialog = new JDialog();
        this.mParent = parentContainer;
        this.mDialog.setModal(true);
        this.mDialog.setSize(400, 200);
        this.mDialog.setTitle(ResourceFactory.getString("choose_theme_out_folder"));
        this.mDialog.setResizable(false);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        this.mDialog.setLayout(layout);
        gc.fill = 1;
        gc.anchor = 17;
        JLabel nameLabel = new JLabel(ResourceFactory.getString("new_theme_themename"));
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        layout.setConstraints(nameLabel, gc);
        this.mDialog.add(nameLabel);
        this.mNameField = new JTextField(mtzFileName);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.gridwidth = 3;
        gc.weightx = 0.8;
        layout.setConstraints(this.mNameField, gc);
        this.mNameField.setEditable(false);
        this.mDialog.add(this.mNameField);
        JLabel pathLabel = new JLabel(ResourceFactory.getString("new_theme_themepath"));
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        layout.setConstraints(pathLabel, gc);
        this.mDialog.add(pathLabel);
        this.mPathField = new JTextField(String.valueOf(mtzFilePath) + File.separator + mtzFileName.substring(0, mtzFileName.length() - 4));
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 3;
        gc.weightx = 0.8;
        layout.setConstraints(this.mPathField, gc);
        this.mDialog.add(this.mPathField);
        this.scanBtn = new JButton(ResourceFactory.getString("global_scan"));
        gc.gridx = 4;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        layout.setConstraints(this.scanBtn, gc);
        this.mDialog.add(this.scanBtn);
        this.saveBtn = new JButton(ResourceFactory.getString("global_confirm_btn_lbl"));
        gc.gridx = 1;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        layout.setConstraints(this.saveBtn, gc);
        this.mDialog.add(this.saveBtn);
        this.cancelBtn = new JButton(ResourceFactory.getString("global_cancel"));
        gc.gridx = 2;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        layout.setConstraints(this.cancelBtn, gc);
        this.mDialog.add(this.cancelBtn);
        this.scanBtn.addActionListener(this);
        this.saveBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.mDialog.setDefaultCloseOperation(2);
        this.mDialog.setLocationRelativeTo(this.mParent);
    }

    public void openDialog() {
        this.mDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.scanBtn) {
            JFileChooser jfc = new JFileChooser();
            jfc.setDialogTitle(ResourceFactory.getString("choose_theme_out_folder"));
            jfc.setVisible(true);
            jfc.setCurrentDirectory(new File(ThemeHelper.sLastClosedInfo.get("mtzPath")));
            jfc.setFileSelectionMode(1);
            jfc.addActionListener(this);
            int state = jfc.showOpenDialog(this.mDialog);
            if (state == 0) {
                String srcFolder;
                File f = jfc.getSelectedFile();
                ThemeHelper.sThemeFolderPath = srcFolder = f.getAbsolutePath().trim();
                this.mPathField.setText(String.valueOf(srcFolder) + File.separator + this.mMtzFileName.substring(0, this.mMtzFileName.length() - 4));
                ThemeHelper.saveMtzInfo(f);
            }
        } else if (e.getSource() == this.saveBtn) {
            String name = this.mNameField.getText();
            String path = this.mPathField.getText();
            if (name == null || "".equals(name)) {
                JOptionPane.showMessageDialog(this.mDialog, ResourceFactory.getString("new_theme_tip_no_name"));
                return;
            }
            if (path == null || "".equals(path)) {
                JOptionPane.showMessageDialog(this.mDialog, ResourceFactory.getString("new_theme_tip_illegal_path"));
                return;
            }
            try {
                File f = new File(path);
                if (f.exists()) {
                    Object[] options = new Object[]{ResourceFactory.getString("global_yes"), ResourceFactory.getString("direct_open"), ResourceFactory.getString("global_cancel")};
                    int choice = JOptionPane.showOptionDialog(null, String.valueOf(f.getName()) + " " + ResourceFactory.getString("new_theme_tip_exist"), ResourceFactory.getString("new_theme_tip_exist"), 1, 3, null, options, options[1]);
                    if (choice == 2) {
                        return;
                    }
                    if (choice == 1) {
                        this.mDialog.dispose();
                        super.setChanged();
                        if (f.isDirectory()) {
                            this.notifyObservers(f);
                        }
                        return;
                    }
                    OS.rmDir(path);
                }
                f.mkdirs();
                ThemeHelper.sThemeFolderPath = path;
                ThemeHelper.sThemeName = name;
                ThemeHelper.saveMtzInfo(f);
                this.selectThemeFolderCompleted();
            }
            catch (Exception exception) {}
        } else if (e.getSource() == this.cancelBtn) {
            this.mDialog.dispose();
        }
    }

    public void selectThemeFolderCompleted() {
        this.mDialog.dispose();
        this.setChanged();
        this.notifyObservers(String.valueOf(this.mMtzFilePath) + File.separator + this.mMtzFileName);
    }
}

