/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ShortcutManager
implements AWTEventListener {
    private static ShortcutManager sInstance = new ShortcutManager();
    private Map<String, ShortcutListener> mListeners;
    private Set<Component> mIgnoredComponents;
    private boolean[] mKeys = new boolean[1000];

    private ShortcutManager() {
        this.mIgnoredComponents = new HashSet<Component>();
        this.mListeners = new HashMap<String, ShortcutListener>();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getClass() == KeyEvent.class) {
            KeyEvent ke = (KeyEvent)event;
            if (ke.getID() == 401) {
                this.mKeys[ke.getKeyCode()] = true;
                String shortcut = this.searchShortcut();
                ShortcutListener l = this.mListeners.get(shortcut);
                if (l != null && !this.isIgnored(event)) {
                    l.handle();
                }
            } else if (ke.getID() == 402) {
                this.mKeys[ke.getKeyCode()] = false;
            }
        }
    }

    protected String searchShortcut() {
        StringBuilder shortcut = new StringBuilder();
        int i = 0;
        while (i < this.mKeys.length) {
            if (this.mKeys[i]) {
                shortcut.append(i).append(".");
            }
            ++i;
        }
        return shortcut.toString();
    }

    protected boolean isIgnored(AWTEvent event) {
        if (!(event.getSource() instanceof Component)) {
            return false;
        }
        boolean ignored = false;
        Component com = (Component)event.getSource();
        while (com != null) {
            if (this.mIgnoredComponents.contains(com)) {
                ignored = true;
                break;
            }
            com = com.getParent();
        }
        return ignored;
    }

    public static ShortcutManager getInstance() {
        return sInstance;
    }

    public void removeShortcutListener(ShortcutListener l) {
        String tempKey = null;
        for (Map.Entry<String, ShortcutListener> e : this.mListeners.entrySet()) {
            if (!e.getValue().equals(l)) continue;
            tempKey = e.getKey();
        }
        this.mListeners.remove(tempKey);
    }

    public void addShortcutListener(ShortcutListener l, int ... keys) {
        StringBuilder sb = new StringBuilder();
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            if (keys[i] <= 0 || keys[i] >= this.mKeys.length) {
                System.out.println("Key is not valid");
                return;
            }
            sb.append(keys[i]).append(".");
            ++i;
        }
        String shortcut = sb.toString();
        if (this.mListeners.containsKey(shortcut)) {
            System.out.println("The shourt cut is already used.");
        } else {
            this.mListeners.put(shortcut, l);
        }
    }

    public void addIgnoredComponent(Component com) {
        this.mIgnoredComponents.add(com);
    }

    public void removeDiscardComponent(Component com) {
        this.mIgnoredComponents.remove(com);
    }

    public static interface ShortcutListener {
        public void handle();
    }
}

