/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icons;

import com.miui.theme.tool.gui.ApkSelectDialog;
import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.icons.IconManager;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IconEditCell
extends JPanel {
    private File mIconCaralogFile;
    private JLabel mLabel;
    public String mShowName;

    public IconEditCell(File iconCatalog) {
        this.mIconCaralogFile = iconCatalog;
        int size = GUIUtil.HDPI_SIZE;
        this.mLabel = new JLabel(GUIUtil.getIcon(this.mIconCaralogFile, size));
        this.mLabel.setOpaque(true);
        GUIUtil.fixSize(this.mLabel, new Dimension(size + 20, size + 20));
        this.mShowName = this.getShowName();
        this.mLabel.setText(this.mShowName);
        this.mLabel.setHorizontalTextPosition(0);
        this.mLabel.setVerticalTextPosition(3);
        this.mLabel.setCursor(Cursor.getPredefinedCursor(12));
        String toolTip = this.mShowName;
        if (!toolTip.equals(this.getPackageName())) {
            toolTip = String.valueOf(toolTip) + "(" + this.getPackageName() + ")";
        }
        this.setToolTipText(toolTip);
        this.add(this.mLabel);
        this.setDefaultBackground();
    }

    public void setDefaultBackground() {
        if (this.mLabel == null) {
            return;
        }
        File iconHdpiFile = new File(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + IconManager.PATH_HDPI + File.separator + this.mIconCaralogFile.getName());
        File iconXhdpiFile = new File(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + IconManager.PATH_XHDPI + File.separator + this.mIconCaralogFile.getName());
        if (iconHdpiFile.exists() || iconXhdpiFile.exists()) {
            this.mLabel.setBackground(Color.GRAY);
        } else {
            this.mLabel.setBackground(MainFrame.getInstance().getBackground());
        }
    }

    public void setSelectedBackground() {
        if (this.mLabel == null) {
            return;
        }
        this.mLabel.setBackground(Color.WHITE);
    }

    public String getFileName() {
        return this.mIconCaralogFile.getName();
    }

    public File getFile() {
        return this.mIconCaralogFile;
    }

    public String getPackageName() {
        String packageName = this.mIconCaralogFile.getName();
        if (packageName.indexOf(".") == -1) {
            return "";
        }
        return packageName.substring(0, packageName.lastIndexOf("."));
    }

    private String getShowName() {
        String packageName = this.getPackageName();
        if (IconManager.sSystemIconsName.containsKey(packageName)) {
            return IconManager.sSystemIconsName.get(packageName);
        }
        String name = ApkSelectDialog.getNameByPackageName(packageName);
        if (name != null) {
            return name;
        }
        if (ResourceFactory.containsKey(packageName)) {
            return ResourceFactory.getString(packageName);
        }
        return packageName;
    }
}

