/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.init;

import com.miui.theme.tool.init.ColorFile;
import com.miui.theme.tool.init.InitData;
import com.miui.theme.tool.init.MIUIThemeValues;
import com.miui.theme.tool.init.ThemeInitUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.io.IOUtils;

public class ThemeInitHelperManager {
    public static String EXTRA = "extra:";
    public static String THEME_VALUES_FILE = "theme_values.xml";

    public static String getDataInitFolder() {
        return String.valueOf(System.getProperty("user.dir")) + File.separator + "data" + File.separator + "init";
    }

    public static String getReplaceFolder() {
        return String.valueOf(ThemeInitHelperManager.getDataInitFolder()) + File.separator + "replaceFolder";
    }

    public static void convert() {
        InitData id = new InitData();
        File initFolder = new File(ThemeInitHelperManager.getDataInitFolder());
        File[] fileArray = initFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().endsWith(".csv")) {
                String content = ThemeInitHelperManager.readFromFile(f);
                String[] contents = content.split("\r\n");
                String folder = null;
                ColorFile cf = null;
                int i = 1;
                while (i < contents.length) {
                    String[] line = contents[i].split(",");
                    if (line.length != 0) {
                        if (!line[0].isEmpty()) {
                            if (id.mColorFileMap.containsKey(line[0])) {
                                cf = id.mColorFileMap.get(line[0]);
                            } else {
                                cf = new ColorFile();
                                id.mColorFileMap.put(line[0], cf);
                            }
                            String color = line[0];
                            String name = line[1];
                            cf.mColor = color;
                            cf.mName = name;
                            if (line.length > 4 && !line[4].isEmpty()) {
                                cf.mShowColor = line[4];
                            }
                        }
                        if (!line[2].isEmpty()) {
                            folder = line[2];
                        }
                        if (line.length > 3 && !line[3].isEmpty()) {
                            String path = String.valueOf(folder) + "\\" + line[3];
                            cf.mPath.add(path);
                            if (line.length > 4 && !line[4].isEmpty() && line[4].startsWith(EXTRA)) {
                                String extraColor = line[4].substring(EXTRA.length());
                                cf.mPathExtraMap.put(path, extraColor);
                            }
                        }
                    }
                    ++i;
                }
            }
            if (f.getName().endsWith(".png")) {
                String key = f.getName().substring(0, f.getName().length() - ".png".length());
                String value = f.getName();
                id.mPreview.put(key, value);
            }
            ++n2;
        }
        id.save();
    }

    public static String readFromFile(File target) {
        FileInputStream fis = null;
        InputStreamReader fsr = null;
        try {
            fis = new FileInputStream(target);
            fsr = new InputStreamReader((InputStream)fis, "gbk");
            String string = IOUtils.toString(fsr);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fsr != null) {
                    fsr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static InitData getInitData() {
        InitData initData = new InitData();
        initData.parse();
        return initData;
    }

    public static void generateInitPackage(String themePath, HashMap<String, String> colorMap, InitData id) {
        File replaceFolder = new File(ThemeInitHelperManager.getReplaceFolder());
        HashSet<String> fileSet = new HashSet<String>();
        ThemeInitUtil.getFileSet(replaceFolder, fileSet);
        for (String originColorString : id.mColorFileMap.keySet()) {
            Color originColor;
            ColorFile cf = id.mColorFileMap.get(originColorString);
            if (cf == null || (originColor = ThemeInitUtil.hex2color(originColorString)) == null) continue;
            for (String path : cf.mPath) {
                File originFile = new File(String.valueOf(replaceFolder.getAbsolutePath()) + File.separator + path);
                File destFile = new File(String.valueOf(themePath) + File.separator + path);
                if (cf.mPathExtraMap.containsKey(path)) {
                    Color extraDestColor = ThemeInitHelperManager.getDestColor(cf.mPathExtraMap.get(path), colorMap);
                    ThemeInitHelperManager.mapImageColor(originFile, destFile, originColor, ThemeInitHelperManager.getDestColor(originColorString, colorMap), extraDestColor);
                } else {
                    ThemeInitHelperManager.mapImageColor(originFile, destFile, originColor, ThemeInitHelperManager.getDestColor(originColorString, colorMap), null);
                }
                fileSet.remove(originFile.getAbsolutePath());
            }
        }
        for (String path : fileSet) {
            File originFile = new File(path);
            File destFile = new File(String.valueOf(themePath) + File.separator + path.substring(replaceFolder.getAbsolutePath().length()));
            if (originFile.isDirectory()) {
                destFile.mkdirs();
                continue;
            }
            try {
                ThemeInitUtil.copyFile(originFile, destFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String key : id.mColorFileMap.keySet()) {
            for (String value : id.mColorFileMap.get((Object)key).mThemeValues) {
                value = ThemeInitUtil.assurePath(value);
                ThemeInitHelperManager.mapThemeValueColor(themePath, value, ThemeInitHelperManager.getDestColor(key, colorMap));
            }
        }
    }

    private static void mapThemeValueColor(String themePath, String value, Color destColor) {
        String themeValuesPath = value.substring(0, value.lastIndexOf(File.separator));
        String themeValuesName = value.substring(themeValuesPath.length() + 1);
        themeValuesPath = String.valueOf(themeValuesPath) + File.separator + THEME_VALUES_FILE;
        File destFile = new File(String.valueOf(themePath) + File.separator + themeValuesPath);
        System.out.println(String.valueOf(destFile.getAbsolutePath()) + " " + themeValuesName);
        MIUIThemeValues mtv = new MIUIThemeValues();
        mtv.setXmlFile(destFile);
        mtv.parse();
        Vector<Vector<String>> allValues = mtv.getAll();
        for (Vector<String> values : allValues) {
            if (!values.get(1).equals(themeValuesName)) continue;
            Color originColor = ThemeInitUtil.hex2color(values.get(2));
            if (originColor != null) {
                System.out.println(String.valueOf(values.get(2)) + " TO " + ThemeInitUtil.color2hex(new Color(originColor.getRGB() & 0xFF000000 | destColor.getRGB() & 0xFFFFFF, true)));
                values.set(2, ThemeInitUtil.color2hex(new Color(originColor.getRGB() & 0xFF000000 | destColor.getRGB() & 0xFFFFFF, true)));
            } else {
                values.set(2, ThemeInitUtil.color2hex(destColor));
            }
            mtv.save();
            return;
        }
    }

    private static Color getDestColor(String originColorString, HashMap<String, String> colorMap) {
        String destColorString = originColorString;
        if (colorMap.containsKey(originColorString)) {
            destColorString = colorMap.get(originColorString);
        }
        return ThemeInitUtil.hex2color(destColorString);
    }

    private static void mapImageColor(File originFile, File destFile, Color originColor, Color destColor, Color extraDestColor) {
        BufferedImage image = ThemeInitUtil.getImage(originFile);
        int wStart = 0;
        int wEnd = image.getWidth();
        int hStart = 0;
        int hEnd = image.getHeight();
        if (originFile.getName().endsWith(".9.png")) {
            ++wStart;
            ++hStart;
            --wEnd;
            --hEnd;
        }
        int i = wStart;
        while (i < wEnd) {
            int j = hStart;
            while (j < hEnd) {
                block9: {
                    int rgb;
                    block8: {
                        rgb = image.getRGB(i, j);
                        if ((rgb & 0xFFFFFF) != (originColor.getRGB() & 0xFFFFFF)) break block8;
                        int imgAlpha = rgb >> 24 & 0xFF;
                        rgb = rgb & 0xFF000000 | destColor.getRGB() & 0xFFFFFF;
                        if (imgAlpha == 0) break block9;
                        if (extraDestColor != null) {
                            int mask = 255;
                            int newRgb = 0;
                            double aAlpha = 0.3;
                            double bAlpha = 1.0 * (double)imgAlpha / 255.0;
                            int k = 0;
                            while (k < 3) {
                                int a = extraDestColor.getRGB() >> 8 * k & mask;
                                int b = rgb >> 8 * k & mask;
                                int c = ThemeInitHelperManager.blendColor(a, b, aAlpha, bAlpha);
                                newRgb |= c << k * 2 * 4;
                                ++k;
                            }
                            rgb = newRgb |= (int)(aAlpha + bAlpha * (1.0 - aAlpha)) * 255 << 24;
                        }
                    }
                    image.setRGB(i, j, rgb);
                }
                ++j;
            }
            ++i;
        }
        ThemeInitUtil.saveImage(image, destFile);
    }

    private static int blendColor(int a, int b, double aAlpha, double bAlpha) {
        return (int)((double)a * aAlpha + (double)b * bAlpha * (1.0 - aAlpha));
    }
}

