/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.module;

import com.miui.theme.tool.module.EditModuleTableModel;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;

public class ColorRenderer
extends JPanel
implements TableCellRenderer {
    boolean isBordered = true;
    JLabel mLabel = new JLabel();
    JLabel mColorLabel = new JLabel();

    public ColorRenderer(boolean isBordered) {
        this.mColorLabel.setOpaque(true);
        this.isBordered = isBordered;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
        Color backColor = table.getBackground();
        EditModuleTableModel ittm = (EditModuleTableModel)table.getModel();
        if (!ittm.isRowChanged(row)) {
            backColor = Color.GRAY;
        }
        if (isSelected) {
            backColor = table.getSelectionBackground();
        }
        this.mLabel.setText((String)color);
        Color newColor = GUIUtil.hex2color((String)color);
        if (newColor == null) {
            this.setBackground(backColor);
            this.setLayout(new BorderLayout());
            this.add((Component)this.mLabel, "Center");
            return this;
        }
        this.mColorLabel.setBackground(newColor);
        if (this.isBordered) {
            MatteBorder border = BorderFactory.createMatteBorder(2, 5, 2, 5, backColor);
            this.mColorLabel.setBorder(border);
            this.setBackground(backColor);
        }
        this.setToolTipText("RGB value: " + newColor.getRed() + ", " + newColor.getGreen() + ", " + newColor.getBlue());
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)this.mColorLabel, "Center");
        int width = 60;
        int height = 20;
        jp.setMinimumSize(new Dimension(width, height));
        jp.setPreferredSize(new Dimension(width, height));
        jp.setMaximumSize(new Dimension(width, height));
        this.setLayout(new GridBagLayout());
        GridBagHelper.addComponent(this, this.mLabel, 1, 0, 1, 1, 0, 0, 0, 0, 1.0, 1.0, 2, 17);
        GridBagHelper.addComponent(this, jp, 0, 0, 1, 1, 0, 0, 0, 0, 0.0, 0.0, 0, 17);
        return this;
    }
}

