/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.ninepatch;

import com.miui.theme.tool.ninepatch.NinePatchPngFormatException;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class NinePatchChunk {
    static Logger logger = Logger.getLogger(NinePatchChunk.class.getName());
    public int size;
    public final int TYPE = 1852855395;
    public byte[] da;
    public int crcValue;
    private static final int NO_COLOR = 1;
    private static final int TRANSPARENT = 0;
    private static final int TRANSPARENT_COLOR = 0xFFFFFF;
    private boolean ignoreNinePatchFormatException = false;
    private byte wasDeSerialized = 0;
    private byte numXDivs;
    private byte numYDivs;
    private byte numColors;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;
    private int[] xDivs_arr;
    private int[] yDivs_arr;
    private int[] colors_arr;

    public boolean set9PatchChunkFromImageData(byte[] data) throws IOException, NinePatchPngFormatException {
        ByteArrayInputStream bain = new ByteArrayInputStream(data);
        BufferedImage im = ImageIO.read(bain);
        int black = -16777216;
        int w = im.getWidth();
        int h = im.getHeight();
        if (w < 3 || h < 3) {
            return false;
        }
        if (data[37] == 110 && data[38] == 112 && data[39] == 84 && data[40] == 99) {
            return false;
        }
        this.numXDivs = 0;
        ArrayList<Integer> listTemp = new ArrayList<Integer>();
        int i = 1;
        while (i < w) {
            if (im.getRGB(i, 0) == black) {
                listTemp.add(i - 1);
                ++i;
                while (i < w && im.getRGB(i, 0) == black) {
                    ++i;
                }
                listTemp.add(i - 1);
                continue;
            }
            if (NinePatchChunk.isTransparent(im.getRGB(i, 0))) {
                ++i;
                continue;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_wrong_color"));
        }
        if (listTemp.size() > 127) {
            return false;
        }
        this.numXDivs = (byte)listTemp.size();
        if (this.numXDivs == 0) {
            if (this.ignoreNinePatchFormatException) {
                return false;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_left_top"));
        }
        this.xDivs_arr = new int[listTemp.size()];
        i = 0;
        while (i < this.xDivs_arr.length) {
            this.xDivs_arr[i] = (Integer)listTemp.get(i);
            ++i;
        }
        listTemp.clear();
        this.numYDivs = 0;
        i = 1;
        while (i < h) {
            if (im.getRGB(0, i) == black) {
                listTemp.add(i - 1);
                ++i;
                while (i < h && im.getRGB(0, i) == black) {
                    ++i;
                }
                listTemp.add(i - 1);
                continue;
            }
            if (NinePatchChunk.isTransparent(im.getRGB(0, i))) {
                ++i;
                continue;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_wrong_color"));
        }
        if (listTemp.size() > 127) {
            return false;
        }
        this.numYDivs = (byte)listTemp.size();
        if (this.numYDivs == 0) {
            if (this.ignoreNinePatchFormatException) {
                return false;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_left_top"));
        }
        this.yDivs_arr = new int[listTemp.size()];
        i = 0;
        while (i < this.yDivs_arr.length) {
            this.yDivs_arr[i] = (Integer)listTemp.get(i);
            ++i;
        }
        listTemp.clear();
        this.paddingLeft = 0;
        for (i = 1; i < w && im.getRGB(i, h - 1) != black; ++i) {
            if (NinePatchChunk.isTransparent(im.getRGB(i, h - 1))) {
                continue;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_wrong_color"));
        }
        this.paddingLeft = i - 1;
        while (i < w && im.getRGB(i, h - 1) == black) {
            ++i;
        }
        this.paddingRight = w - 1 - i;
        if (this.paddingLeft == w - 1) {
            this.paddingLeft = this.xDivs_arr[0];
            this.paddingRight = w - 2 - this.xDivs_arr[1];
        }
        for (i = 1; i < h && im.getRGB(w - 1, i) != black; ++i) {
            if (NinePatchChunk.isTransparent(im.getRGB(w - 1, i))) {
                continue;
            }
            throw new NinePatchPngFormatException(ResourceFactory.getString("nine_patch_wrong_color"));
        }
        this.paddingTop = i - 1;
        while (i < h && im.getRGB(w - 1, i) == black) {
            ++i;
        }
        this.paddingBottom = h - 1 - i;
        if (this.paddingTop == h - 1) {
            this.paddingTop = this.yDivs_arr[0];
            this.paddingBottom = h - 2 - this.yDivs_arr[1];
        }
        int J = this.xDivs_arr[0] == 0 && this.xDivs_arr[this.xDivs_arr.length - 1] == w - 2 ? this.numXDivs - 1 : (this.xDivs_arr[0] == 0 && this.xDivs_arr[this.xDivs_arr.length - 1] < w - 2 || this.xDivs_arr[0] > 0 && this.xDivs_arr[this.xDivs_arr.length - 1] == w - 2 ? (int)this.numXDivs : this.numXDivs + 1);
        int K = this.yDivs_arr[0] == 0 && this.yDivs_arr[this.yDivs_arr.length - 1] == h - 2 ? this.numYDivs - 1 : (this.yDivs_arr[0] == 0 && this.yDivs_arr[this.yDivs_arr.length - 1] < h - 2 || this.yDivs_arr[0] > 0 && this.yDivs_arr[this.yDivs_arr.length - 1] == h - 2 ? (int)this.numYDivs : this.numYDivs + 1);
        this.numColors = (byte)(J * K);
        this.colors_arr = new int[this.numColors];
        this.size = 32 + (this.xDivs_arr.length + this.yDivs_arr.length + this.colors_arr.length) * 4;
        int p = 0;
        int q = 0;
        int k = 0;
        int x_len = this.xDivs_arr.length;
        int y_len = this.yDivs_arr.length;
        int s = 1;
        int e = this.yDivs_arr[p];
        while (s <= h - 2 && e <= h - 2 && p <= y_len) {
            if (s <= e) {
                q = 0;
                int ss = 1;
                int ee = this.xDivs_arr[q];
                while (ss <= w - 2 && ee <= w - 2 && q <= x_len) {
                    if (ss <= ee) {
                        this.colors_arr[k] = this.getColor(im, s, e, ss, ee);
                        ++k;
                    }
                    ss = ee + 1;
                    ee = this.getNext(this.xDivs_arr, q, w - 2);
                    ++q;
                }
            }
            s = e + 1;
            e = this.getNext(this.yDivs_arr, p, h - 2);
            ++p;
        }
        this.crcValue = this.getCrc();
        return true;
    }

    private int getCrc() {
        byte[] typeBytes = new byte[4];
        NinePatchUtils.getBytesFromInt(typeBytes, 0, 1852855395);
        this.da = new byte[this.size];
        this.da[0] = this.wasDeSerialized;
        this.da[1] = this.numXDivs;
        this.da[2] = this.numYDivs;
        this.da[3] = this.numColors;
        int i = 4;
        while (i <= 11) {
            this.da[i] = 0;
            ++i;
        }
        NinePatchUtils.getBytesFromInt(this.da, 12, this.paddingLeft);
        NinePatchUtils.getBytesFromInt(this.da, 16, this.paddingRight);
        NinePatchUtils.getBytesFromInt(this.da, 20, this.paddingTop);
        NinePatchUtils.getBytesFromInt(this.da, 24, this.paddingBottom);
        i = 28;
        while (i <= 31) {
            this.da[i] = 0;
            ++i;
        }
        int j = 32;
        int i2 = 0;
        while (i2 < this.xDivs_arr.length) {
            NinePatchUtils.getBytesFromInt(this.da, j, this.xDivs_arr[i2]);
            ++i2;
            j += 4;
        }
        i2 = 0;
        while (i2 < this.yDivs_arr.length) {
            NinePatchUtils.getBytesFromInt(this.da, j, this.yDivs_arr[i2]);
            ++i2;
            j += 4;
        }
        i2 = 0;
        while (i2 < this.colors_arr.length) {
            NinePatchUtils.getBytesFromInt(this.da, j, this.colors_arr[i2]);
            ++i2;
            j += 4;
        }
        CRC32 my_crc = new CRC32();
        my_crc.update(typeBytes);
        my_crc.update(this.da);
        return (int)my_crc.getValue();
    }

    private int getNext(int[] arr, int prepos, int lineLength) {
        if (prepos >= arr.length - 1) {
            return lineLength;
        }
        return arr[prepos + 1];
    }

    private int getColor(BufferedImage im, int y_start, int y_end, int x_start, int x_end) {
        if (x_start == x_end && y_start == y_end) {
            return im.getRGB(x_start, y_start);
        }
        boolean flag = true;
        boolean is_transparent = true;
        boolean is_solid = true;
        int rgb_pre = im.getRGB(x_start, y_start);
        int i = x_start;
        while (i <= x_end) {
            int j = y_start;
            while (j <= y_end) {
                int rgb_value = im.getRGB(i, j);
                if (is_transparent && rgb_value != 0xFFFFFF) {
                    is_transparent = false;
                }
                if (is_solid && rgb_value != rgb_pre) {
                    is_solid = false;
                }
                rgb_pre = rgb_value;
                if (!is_transparent && !is_solid) {
                    flag = false;
                    break;
                }
                ++j;
            }
            if (!flag) break;
            ++i;
        }
        if (is_transparent && is_solid) {
            logger.debug("transparent and solid color, return transparent");
        }
        if (is_transparent) {
            return 0;
        }
        if (is_solid) {
            return rgb_pre;
        }
        return 1;
    }

    public static boolean isTransparent(int rgb) {
        return (rgb >> 24 & 0xFF) == 0;
    }
}

