/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.gui.SetVectorableJList;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.ImageEditorPanel;
import com.miui.theme.tool.resourceeditor.ImagePreview;
import com.miui.theme.tool.resourceeditor.Notifier;
import com.miui.theme.tool.resourceeditor.Resource;
import com.miui.theme.tool.resourceeditor.ResourceMainPanel;
import com.miui.theme.tool.resourceeditor.ScreenshotXml;
import com.miui.theme.tool.resourceeditor.ShowResourceImagePanel;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class CenterEditorPanel
extends JPanel
implements ListSelectionListener,
Observer,
KeyListener,
ActionListener {
    BufferedImage mScreenshotImage;
    ResourceMainPanel mResourceMainPanel;
    private ScreenshotXml mScreenshotXml;
    private ImageEditorPanel mImageEditorPanel;
    private SetVectorableJList mResourceList;
    private JScrollPane mResourceScrollPane = new JScrollPane();
    private JPanel mCenterRightPanel;
    private JButton mUpResourcePathButton;
    private JButton mDownResourcePathButton;
    private JButton mAddResourceButton;
    private JButton mDeleteResourceButton;
    private JPanel mRightPanel;
    private JLabel mScreenshotDescriptionLabel;
    private JTextField mScreenshotDescriptionTextField;
    private JLabel mResourceDescriptionLabel;
    private JTextField mResourceDescriptionTextField;
    private JTextField mResourceXTextField;
    private JLabel mResourceXLabel;
    private JLabel mResourceYLabel;
    private JTextField mResourceYTextField;
    private JLabel mResourceWidthLabel;
    private JTextField mResourceWidthTextField;
    private JLabel mResourceHeightLabel;
    private JTextField mResourceHeightTextField;
    public Notifier mNotifier;
    private JScrollPane mImageEditorPanelScroll;
    private JButton mCopyResourceButton;
    private JButton mPasteResourceButton;
    private FileDrop.Listener mAddOneResourceListener = new FileDrop.Listener(){

        @Override
        public void filesDropped(File[] files) {
            File f = files[0];
            if (f.isDirectory()) {
                return;
            }
            if (MainFrame.getInstance().checkOpenMtz(f)) {
                return;
            }
            CenterEditorPanel.this.onCreateOneResource(files);
        }
    };
    private Vector<JTextComponent> valueFields;
    private JButton mAddResourcePathButton;
    private SetVectorableJList mResourcePathList;
    private JButton mDeleteResourcePathButton;
    private ShowResourceImagePanel mShowResourceImagePanel;
    private JLabel mScreenshotAnnotationLabel;
    private JTextArea mScreenshotAnootationTextArea;
    private JTextField mResourcePathDescriptionTextField;
    private JLabel mScreenshotTagLabel;
    private JComboBox mScreenshotTagComboBox;
    Resource mCurrentResource = null;
    private boolean lockTextField;
    private File mLastDir;
    private Vector<Resource> mSelectedResources;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public CenterEditorPanel(ResourceMainPanel rep) {
        this.mResourceMainPanel = rep;
        this.loadImage();
        this.mImageEditorPanel = new ImageEditorPanel(this.mScreenshotImage);
        this.mResourceList = new SetVectorableJList();
        this.mResourceList.setVector(this.mScreenshotXml.mResources);
        this.mResourceScrollPane.setViewportView(this.mResourceList);
        this.mResourceList.addListSelectionListener(this);
        this.mAddResourceButton = new JButton(ResourceFactory.getString("add_resource"));
        this.mAddResourceButton.addActionListener(this);
        this.mDeleteResourceButton = new JButton(ResourceFactory.getString("delete_resource"));
        this.mDeleteResourceButton.addActionListener(this);
        this.mCopyResourceButton = new JButton(ResourceFactory.getString("copy"));
        this.mCopyResourceButton.addActionListener(this);
        this.mPasteResourceButton = new JButton(ResourceFactory.getString("paste"));
        this.mPasteResourceButton.addActionListener(this);
        new FileDrop(MainFrame.out, (Component)this.mImageEditorPanel, this.mImageEditorPanel.getBorder(), this.mAddOneResourceListener);
        new FileDrop(MainFrame.out, (Component)this.mResourceList, this.mImageEditorPanel.getBorder(), this.mAddOneResourceListener);
        this.mCenterRightPanel = new JPanel();
        this.mCenterRightPanel.setLayout(new GridBagLayout());
        int level = 0;
        GridBagHelper.addComponent(this.mCenterRightPanel, this.mAddResourceButton, 0, level++, 2, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mCenterRightPanel, this.mResourceScrollPane, 0, level++, 2, 1, 0, 0, 0, 0, 1.0, 1.0, 1, 10);
        GridBagHelper.addComponent(this.mCenterRightPanel, this.mCopyResourceButton, 0, level, 1, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mCenterRightPanel, this.mPasteResourceButton, 1, level++, 1, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        GridBagHelper.addComponent(this.mCenterRightPanel, this.mDeleteResourceButton, 0, level++, 2, 1, 0, 0, 0, 0, 1.0, 0.0, 1, 10);
        this.mImageEditorPanelScroll = new JScrollPane();
        this.mImageEditorPanelScroll.setViewportView(this.mImageEditorPanel);
        this.setLayout(new GridBagLayout());
        GridBagHelper.addComponent(this, this.mImageEditorPanelScroll, 0, 0, 1, 1, 0, 0, 0, 0, 7.0, 1.0, 1, 11);
        GridBagHelper.addComponent(this, this.mCenterRightPanel, 1, 0, 1, 1, 0, 0, 0, 0, 1.0, 1.0, 1, 11);
        this.initRightPanel();
        this.initNotifier();
        this.mImageEditorPanel.bindNotifier(this.mNotifier);
        this.mImageEditorPanel.bindResources(this.mScreenshotXml.mResources);
        this.defaultResourceSelection();
    }

    private void initRightPanel() {
        this.mRightPanel = this.mResourceMainPanel.mRightPanel;
        this.mRightPanel.removeAll();
        this.mRightPanel.setLayout(new GridBagLayout());
        int textFieldCol = 10;
        int level = 0;
        this.valueFields = new Vector();
        this.mScreenshotDescriptionLabel = new JLabel(ResourceFactory.getString("screenshot.description"));
        this.mScreenshotDescriptionTextField = new JTextField(this.mScreenshotXml.mDescription);
        this.mScreenshotDescriptionTextField.setColumns(textFieldCol);
        this.valueFields.add(this.mScreenshotDescriptionTextField);
        this.mScreenshotTagLabel = new JLabel(ResourceFactory.getString("screenshot.tag"));
        this.mScreenshotTagComboBox = new JComboBox<String>(this.mResourceMainPanel.mScreenshotTree.getAllTags());
        this.mScreenshotTagComboBox.setEditable(true);
        this.mScreenshotTagComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CenterEditorPanel.this.refreshTag();
            }
        });
        this.mScreenshotTagComboBox.setSelectedItem(this.mScreenshotXml.mTag);
        GridBagHelper.addComponent(this.mRightPanel, this.mScreenshotDescriptionLabel, 0, level, 1, 1, 0, 0, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(this.mRightPanel, this.mScreenshotDescriptionTextField, 1, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(this.mRightPanel, this.mScreenshotTagLabel, 2, level, 1, 1, 0, 0, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(this.mRightPanel, this.mScreenshotTagComboBox, 3, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        this.mScreenshotAnnotationLabel = new JLabel(ResourceFactory.getString("screenshot.annotation"));
        this.mScreenshotAnootationTextArea = new JTextArea(this.mScreenshotXml.mAnnotation);
        this.valueFields.add(this.mScreenshotAnootationTextArea);
        GridBagHelper.addComponent(this.mRightPanel, this.mScreenshotAnnotationLabel, 0, ++level, 1, 1, 0, 0, 0.0, 0.0, 0, 17);
        GridBagHelper.addComponent(this.mRightPanel, this.mScreenshotAnootationTextArea, 0, ++level, 4, 2, 0, 0, 0.0, 2.0, 1, 10);
        ++level;
        GridBagHelper.addComponent(this.mRightPanel, new JLabel(), 0, ++level, 4, 1, 0, 0, 0, 20, 0.0, 0.0, 2, 13);
        this.mResourceDescriptionLabel = new JLabel(ResourceFactory.getString("resource.description"));
        this.mResourceDescriptionTextField = new JTextField();
        this.valueFields.add(this.mResourceDescriptionTextField);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceDescriptionLabel, 0, ++level, 1, 1, 0, 0, 0.0, 0.0, 0, 13);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceDescriptionTextField, 1, level, 3, 1, 0, 0, 0.0, 0.0, 2, 10);
        ++level;
        KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                int move = 0;
                if (ke.isAltDown() && ke.getKeyCode() == 38) {
                    move = 10;
                } else if (ke.isAltDown() && ke.getKeyCode() == 40) {
                    move = -10;
                } else if (ke.getKeyCode() == 38) {
                    move = 1;
                } else if (ke.getKeyCode() == 40) {
                    move = -1;
                }
                if (move != 0) {
                    JTextField jtf = (JTextField)ke.getSource();
                    int value = Integer.parseInt(jtf.getText());
                    jtf.setText(String.valueOf(value += move));
                    CenterEditorPanel.this.updateByFieldValue(jtf);
                }
            }
        };
        this.mResourceXLabel = new JLabel(ResourceFactory.getString("resource.x"));
        this.mResourceXTextField = new JTextField();
        this.mResourceXTextField.addKeyListener(ka);
        this.valueFields.add(this.mResourceXTextField);
        this.mResourceYLabel = new JLabel(ResourceFactory.getString("resource.y"));
        this.mResourceYTextField = new JTextField();
        this.mResourceYTextField.addKeyListener(ka);
        this.valueFields.add(this.mResourceYTextField);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceXLabel, 0, level, 1, 1, 0, 0, 0.0, 0.0, 0, 13);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceXTextField, 1, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceYLabel, 2, level, 1, 1, 0, 0, 0.0, 0.0, 0, 13);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceYTextField, 3, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        ++level;
        this.mResourceWidthLabel = new JLabel(ResourceFactory.getString("width"));
        this.mResourceWidthTextField = new JTextField();
        this.mResourceWidthTextField.addKeyListener(ka);
        this.valueFields.add(this.mResourceWidthTextField);
        this.mResourceHeightLabel = new JLabel(ResourceFactory.getString("height"));
        this.mResourceHeightTextField = new JTextField();
        this.mResourceHeightTextField.addKeyListener(ka);
        this.valueFields.add(this.mResourceHeightTextField);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceWidthLabel, 0, level, 1, 1, 0, 0, 0.0, 0.0, 0, 13);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceWidthTextField, 1, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceHeightLabel, 2, level, 1, 1, 0, 0, 0.0, 0.0, 0, 13);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourceHeightTextField, 3, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(this.mRightPanel, new JLabel(ResourceFactory.getString("resource_path_list")), 0, ++level, 4, 1, 0, 0, 0, 20, 0.0, 0.0, 2, 10);
        this.mResourcePathList = new SetVectorableJList();
        GridBagHelper.addComponent(this.mRightPanel, this.mResourcePathList, 0, ++level, 4, 1, 0, 0, 0.0, 3.0, 1, 10);
        new FileDrop(MainFrame.out, (Component)this.mResourcePathList, this.mResourcePathList.getBorder(), new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                File f = files[0];
                if (f.isDirectory()) {
                    return;
                }
                if (MainFrame.getInstance().checkOpenMtz(f)) {
                    return;
                }
                CenterEditorPanel.this.onAddResourcePaths(files);
            }
        });
        this.mResourcePathList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = CenterEditorPanel.this.mResourcePathList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                Resource resource = CenterEditorPanel.this.mCurrentResource;
                CenterEditorPanel.this.mResourcePathDescriptionTextField.setText(resource.mPathDescriptions.get(index));
                String path = String.valueOf(CenterEditorPanel.this.mResourceMainPanel.mPackageResourceCatalogPath) + File.separator + resource.mPaths.get(index);
                try {
                    File f = new File(path);
                    if (!f.exists()) {
                        CenterEditorPanel.this.mShowResourceImagePanel.setImage(null);
                        return;
                    }
                    FileInputStream fis = new FileInputStream(f);
                    BufferedImage image = ImageIO.read(fis);
                    fis.close();
                    CenterEditorPanel.this.mShowResourceImagePanel.setImage(image);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.mUpResourcePathButton = new JButton(ResourceFactory.getString("up"));
        this.mDownResourcePathButton = new JButton(ResourceFactory.getString("down"));
        this.mAddResourcePathButton = new JButton(ResourceFactory.getString("add_resource_path"));
        this.mDeleteResourcePathButton = new JButton(ResourceFactory.getString("delete_resource_path"));
        GridBagHelper.addComponent(this.mRightPanel, this.mUpResourcePathButton, 0, ++level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(this.mRightPanel, this.mDownResourcePathButton, 1, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(this.mRightPanel, this.mAddResourcePathButton, 2, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        GridBagHelper.addComponent(this.mRightPanel, this.mDeleteResourcePathButton, 3, level, 1, 1, 0, 0, 0.0, 0.0, 2, 10);
        this.mUpResourcePathButton.addActionListener(this);
        this.mDownResourcePathButton.addActionListener(this);
        this.mAddResourcePathButton.addActionListener(this);
        this.mDeleteResourcePathButton.addActionListener(this);
        GridBagHelper.addComponent(this.mRightPanel, new JLabel(), 0, ++level, 4, 1, 0, 0, 0, 20, 0.0, 0.0, 2, 13);
        this.mResourcePathDescriptionTextField = new JTextField();
        this.valueFields.add(this.mResourcePathDescriptionTextField);
        GridBagHelper.addComponent(this.mRightPanel, this.mResourcePathDescriptionTextField, 0, ++level, 4, 1, 0, 0, 0.0, 0.0, 2, 10);
        this.mShowResourceImagePanel = new ShowResourceImagePanel();
        GridBagHelper.addComponent(this.mRightPanel, this.mShowResourceImagePanel, 0, ++level, 4, 1, 0, 0, 0.0, 5.0, 1, 10);
        ++level;
        this.setResourceFieldEnable(false);
        for (JTextComponent field : this.valueFields) {
            field.addKeyListener(this);
        }
        this.mResourceMainPanel.validate();
        this.mResourceMainPanel.repaint();
    }

    protected void refreshTag() {
        System.out.println("refresh tag");
        this.mScreenshotXml.mTag = this.mScreenshotTagComboBox.getSelectedItem().toString();
    }

    private void setResourceFieldEnable(boolean val) {
        this.mResourceDescriptionTextField.setEnabled(val);
        this.mResourceXTextField.setEnabled(val);
        this.mResourceYTextField.setEnabled(val);
        this.mResourceWidthTextField.setEnabled(val);
        this.mResourceHeightTextField.setEnabled(val);
        this.mResourcePathList.setEnabled(val);
        this.mUpResourcePathButton.setEnabled(val);
        this.mDownResourcePathButton.setEnabled(val);
        this.mAddResourcePathButton.setEnabled(val);
        this.mDeleteResourcePathButton.setEnabled(val);
        this.mResourcePathDescriptionTextField.setEnabled(val);
    }

    public void updateByFieldValue(JTextComponent jtc) {
        if (jtc.equals(this.mScreenshotDescriptionTextField)) {
            this.mScreenshotXml.mDescription = this.mScreenshotDescriptionTextField.getText();
            this.mResourceMainPanel.mScreenshotTree.updateUI();
            return;
        }
        if (jtc.equals(this.mScreenshotAnootationTextArea)) {
            this.mScreenshotXml.mAnnotation = this.mScreenshotAnootationTextArea.getText();
            return;
        }
        if (this.lockTextField) {
            return;
        }
        if (this.mCurrentResource == null) {
            return;
        }
        Resource resource = this.mCurrentResource;
        if (jtc.equals(this.mResourceDescriptionTextField)) {
            resource.mDescription = this.mResourceDescriptionTextField.getText();
            this.mResourceList.updateUI();
        } else if (jtc.equals(this.mResourceXTextField)) {
            resource.mX = Integer.parseInt(this.mResourceXTextField.getText());
        } else if (jtc.equals(this.mResourceYTextField)) {
            resource.mY = Integer.parseInt(this.mResourceYTextField.getText());
        } else if (jtc.equals(this.mResourceWidthTextField)) {
            resource.mWidth = Integer.parseInt(this.mResourceWidthTextField.getText());
        } else if (jtc.equals(this.mResourceHeightTextField)) {
            resource.mHeight = Integer.parseInt(this.mResourceHeightTextField.getText());
        } else if (jtc.equals(this.mResourcePathDescriptionTextField)) {
            resource.mPathDescriptions.set(this.mResourcePathList.getSelectedIndex(), this.mResourcePathDescriptionTextField.getText());
        }
        this.mNotifier.doNotify(jtc);
    }

    private void loadImage() {
        this.mScreenshotXml = this.mResourceMainPanel.mCurrentScreenshotXml;
        if (this.mScreenshotXml == null) {
            return;
        }
        File f = this.mScreenshotXml.mFile;
        try {
            FileInputStream fis = new FileInputStream(f);
            this.mScreenshotImage = ImageIO.read(f);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (-1 == this.mResourceList.getSelectedIndex()) {
            return;
        }
        this.mCurrentResource = (Resource)this.mResourceList.getSelectedValue();
        this.mImageEditorPanel.bindResource(this.mCurrentResource);
        this.refreshRightPanel();
        this.defaultResourcePathSelection();
    }

    private void defaultResourcePathSelection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CenterEditorPanel.this.mResourcePathList.getModel().getSize() <= 0) {
                    return;
                }
                CenterEditorPanel.this.mResourcePathList.setSelectedIndex(0);
            }
        });
    }

    public void refreshRightPanel() {
        Resource resource = this.mCurrentResource;
        this.mResourceDescriptionTextField.setText(resource.mDescription);
        this.mResourceXTextField.setText(String.valueOf(resource.mX));
        this.mResourceYTextField.setText(String.valueOf(resource.mY));
        this.mResourceWidthTextField.setText(String.valueOf(resource.mWidth));
        this.mResourceHeightTextField.setText(String.valueOf(resource.mHeight));
        int selected = this.mResourcePathList.getSelectedIndex();
        this.mResourcePathList.setVector(resource.mPaths);
        if (selected != -1) {
            this.mResourcePathList.setSelectedIndex(selected);
        }
        this.setResourceFieldEnable(true);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ImageEditorPanel) {
            this.lockTextField = true;
            this.refreshRightPanel();
            this.lockTextField = false;
        } else if (arg instanceof Vector) {
            this.mSelectedResources = (Vector)arg;
            this.refreshResourceList();
        }
    }

    private void refreshResourceList() {
        if (this.mSelectedResources != null && !this.mSelectedResources.isEmpty()) {
            this.mResourceList.setVector(this.mSelectedResources);
        } else {
            this.mResourceList.setVector(this.mScreenshotXml.mResources);
        }
        this.defaultResourceSelection();
    }

    public void initNotifier() {
        this.mNotifier = new Notifier();
        this.mNotifier.addObserver(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateByFieldValue((JTextComponent)e.getSource());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mAddResourceButton)) {
            File[] files = this.onSelectResourcePaths();
            this.onCreateOneResource(files);
        } else if (e.getSource().equals(this.mDeleteResourceButton)) {
            this.mImageEditorPanel.unbindResource();
            Resource resource = this.mCurrentResource;
            this.mScreenshotXml.mResources.remove(resource);
            if (this.mSelectedResources != null && this.mSelectedResources.contains(resource)) {
                this.mSelectedResources.remove(resource);
            }
            this.refreshResourceList();
            this.initRightPanel();
        } else if (e.getSource().equals(this.mAddResourcePathButton)) {
            File[] files = this.onSelectResourcePaths();
            if (files == null) {
                return;
            }
            this.onAddResourcePaths(files);
        } else if (e.getSource().equals(this.mDeleteResourcePathButton)) {
            Resource resource = this.mCurrentResource;
            int[] indices = this.mResourcePathList.getSelectedIndices();
            int i = indices.length - 1;
            while (i >= 0) {
                int index = indices[i];
                if (resource.mPaths.size() > index) {
                    resource.mPaths.remove(index);
                }
                --i;
            }
            this.mResourcePathList.updateUI();
        } else if (e.getSource().equals(this.mUpResourcePathButton)) {
            int index = this.mResourcePathList.getSelectedIndex();
            if (index <= 0) {
                return;
            }
            Resource resource = this.mCurrentResource;
            String tmp = resource.mPaths.get(index);
            resource.mPaths.set(index, resource.mPaths.get(index - 1));
            resource.mPaths.set(index - 1, tmp);
            tmp = resource.mPathDescriptions.get(index);
            resource.mPathDescriptions.set(index, resource.mPathDescriptions.get(index - 1));
            resource.mPathDescriptions.set(index - 1, tmp);
            this.mResourcePathList.setSelectedIndex(index - 1);
            this.mResourcePathList.updateUI();
        } else if (e.getSource().equals(this.mDownResourcePathButton)) {
            Resource resource = this.mCurrentResource;
            int index = this.mResourcePathList.getSelectedIndex();
            if (index >= resource.mPaths.size() - 1) {
                return;
            }
            String tmp = resource.mPaths.get(index);
            resource.mPaths.set(index, resource.mPaths.get(index + 1));
            resource.mPaths.set(index + 1, tmp);
            tmp = resource.mPathDescriptions.get(index);
            resource.mPathDescriptions.set(index, resource.mPathDescriptions.get(index + 1));
            resource.mPathDescriptions.set(index + 1, tmp);
            this.mResourcePathList.setSelectedIndex(index + 1);
            this.mResourcePathList.updateUI();
        } else if (e.getSource().equals(this.mCopyResourceButton)) {
            Object[] resources = this.mResourceList.getSelectedValues();
            Resource[] clipboard = new Resource[resources.length];
            System.arraycopy(resources, 0, clipboard, 0, resources.length);
            this.mResourceMainPanel.setResourceClipboard(clipboard);
        } else if (e.getSource().equals(this.mPasteResourceButton)) {
            Resource[] clipboard = this.mResourceMainPanel.getResourceClipboard();
            if (clipboard == null) {
                return;
            }
            Resource[] resourceArray = clipboard;
            int n = clipboard.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r = resourceArray[n2];
                Resource newResource = new Resource(r);
                this.mScreenshotXml.mResources.add(newResource);
                ++n2;
            }
            this.refreshResourceList();
        }
    }

    private void defaultResourceSelection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((CenterEditorPanel)CenterEditorPanel.this).mScreenshotXml.mResources.size() <= 0) {
                    CenterEditorPanel.this.mDeleteResourceButton.setEnabled(false);
                    return;
                }
                CenterEditorPanel.this.mResourceList.setSelectedIndex(0);
            }
        });
    }

    private File[] onSelectResourcePaths() {
        JFileChooser jfc = new JFileChooser();
        jfc.setBounds(20, 20, 400, 400);
        jfc.setVisible(true);
        jfc.setDialogTitle(ResourceFactory.getString("select_a_resource"));
        if (this.mLastDir == null) {
            jfc.setCurrentDirectory(new File(this.mResourceMainPanel.mPackageResourceCatalogPath));
        } else {
            jfc.setCurrentDirectory(this.mLastDir);
        }
        jfc.setFileSelectionMode(0);
        jfc.setMultiSelectionEnabled(true);
        ImagePreview preview = new ImagePreview(jfc);
        jfc.addPropertyChangeListener(preview);
        jfc.setAccessory(preview);
        int state = jfc.showOpenDialog(null);
        if (state == 0) {
            return jfc.getSelectedFiles();
        }
        return null;
    }

    private void onAddResourcePaths(File[] selectedFiles) {
        Resource resource = this.mCurrentResource;
        String replacePath = new File(this.mResourceMainPanel.mPackageResourceCatalogPath).getAbsolutePath();
        File[] fileArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isDirectory()) {
                if (!f.getAbsolutePath().startsWith(replacePath)) {
                    GUIUtil.alert(String.valueOf(f.getAbsolutePath()) + ResourceFactory.getString("path_error"));
                } else {
                    String path = f.getAbsolutePath().substring(replacePath.length() + 1);
                    resource.mPaths.add(path);
                    resource.mPathDescriptions.add("");
                }
            }
            ++n2;
        }
        this.mResourcePathList.updateUI();
    }

    private void onCreateOneResource(File[] selectedFiles) {
        if (selectedFiles == null) {
            return;
        }
        Resource resource = new Resource();
        resource.mUUID = UUID.randomUUID();
        String replacePath = new File(this.mResourceMainPanel.mPackageResourceCatalogPath).getAbsolutePath();
        File[] fileArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isDirectory()) {
                if (!f.getAbsolutePath().startsWith(replacePath)) {
                    GUIUtil.alert(String.valueOf(f.getAbsolutePath()) + ResourceFactory.getString("path_error"));
                } else {
                    String path = f.getAbsolutePath().substring(replacePath.length() + 1);
                    resource.mPaths.add(path);
                    resource.mPathDescriptions.add("");
                    if (f.getAbsolutePath().endsWith(".png")) {
                        try {
                            resource.mDescription = f.getName().substring(0, f.getName().length() - 4);
                            FileInputStream fis = new FileInputStream(f);
                            BufferedImage bi = ImageIO.read(fis);
                            fis.close();
                            resource.mWidth = bi.getWidth();
                            resource.mHeight = bi.getHeight();
                            this.mLastDir = f.getParentFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.mDeleteResourceButton.setEnabled(true);
                }
            }
            ++n2;
        }
        if (resource.mPaths.size() <= 0) {
            return;
        }
        this.mScreenshotXml.mResources.add(resource);
        this.mResourceList.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((CenterEditorPanel)CenterEditorPanel.this).mScreenshotXml.mResources.size() <= 0) {
                    return;
                }
                CenterEditorPanel.this.mResourceList.setVector(((CenterEditorPanel)CenterEditorPanel.this).mScreenshotXml.mResources);
                CenterEditorPanel.this.mResourceList.setSelectedIndex(((CenterEditorPanel)CenterEditorPanel.this).mScreenshotXml.mResources.size() - 1);
            }
        });
    }
}

