/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Rectangle;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import org.jdom2.Content;
import org.jdom2.Element;

class Resource
implements Comparable<Resource> {
    int mX;
    int mY;
    int mWidth = 200;
    int mHeight = 200;
    String mDescription = ResourceFactory.getString("default");
    UUID mUUID = null;
    Vector<String> mPaths = new Vector();
    Vector<String> mPathDescriptions = new Vector();
    public static String RESOURCE_TAGNAME = "resource";
    public static String PATH_TAGNAME = "path";
    public static String PATH_SRC = "src";
    public static String PATH_DESCRIPTION = "description";
    public static String RESOURCE_DESCRIPTION = "description";
    public static String RESOURCE_UUID = "uuid";
    public static String RESOURCE_X = "x";
    public static String RESOURCE_Y = "y";
    public static String RESOURCE_WIDTH = "width";
    public static String RESOURCE_HEIGHT = "height";
    public static String RESOURCE_PATH = "path";

    public Resource() {
    }

    public Resource(Resource r) {
        this.mX = r.mX;
        this.mY = r.mY;
        this.mWidth = r.mWidth;
        this.mHeight = r.mHeight;
        this.mDescription = r.mDescription;
        this.mUUID = UUID.randomUUID();
        this.mPaths = new Vector<String>(r.mPaths);
        this.mPathDescriptions = new Vector<String>(r.mPathDescriptions);
    }

    public void parse(Element r) {
        this.mX = Integer.parseInt(r.getAttributeValue(RESOURCE_X));
        this.mY = Integer.parseInt(r.getAttributeValue(RESOURCE_Y));
        this.mWidth = Integer.parseInt(r.getAttributeValue(RESOURCE_WIDTH));
        this.mHeight = Integer.parseInt(r.getAttributeValue(RESOURCE_HEIGHT));
        this.mDescription = r.getAttributeValue(PATH_DESCRIPTION);
        this.mUUID = UUID.fromString(r.getAttributeValue(RESOURCE_UUID));
        for (Element path : r.getChildren()) {
            this.mPaths.add(path.getAttributeValue(PATH_SRC));
            this.mPathDescriptions.add(path.getAttributeValue(PATH_DESCRIPTION));
        }
        this.assurePath();
    }

    public void assurePath() {
        int i = 0;
        while (i < this.mPaths.size()) {
            String path = this.mPaths.get(i);
            path = ThemeHelper.assurePath(path);
            this.mPaths.set(i, path);
            ++i;
        }
    }

    public String toString() {
        return this.mDescription;
    }

    public Element getElement() {
        Element resource = new Element(RESOURCE_TAGNAME);
        resource.setAttribute(RESOURCE_DESCRIPTION, this.mDescription);
        resource.setAttribute(RESOURCE_X, String.valueOf(this.mX));
        resource.setAttribute(RESOURCE_Y, String.valueOf(this.mY));
        resource.setAttribute(RESOURCE_WIDTH, String.valueOf(this.mWidth));
        resource.setAttribute(RESOURCE_HEIGHT, String.valueOf(this.mHeight));
        resource.setAttribute(RESOURCE_UUID, this.mUUID.toString());
        int i = 0;
        while (i < this.mPaths.size()) {
            Element path = new Element(PATH_TAGNAME);
            path.setAttribute(PATH_SRC, this.mPaths.get(i));
            String desc = "";
            try {
                desc = this.mPathDescriptions.get(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.print(".");
            }
            path.setAttribute(PATH_DESCRIPTION, desc);
            resource.addContent((Content)path);
            ++i;
        }
        return resource;
    }

    @Override
    public int compareTo(Resource o) {
        Rectangle r1 = new Rectangle(this.mX, this.mY, this.mWidth, this.mHeight);
        Rectangle r2 = new Rectangle(o.mX, o.mY, o.mWidth, o.mHeight);
        if (r1.contains(r2)) {
            return 1;
        }
        if (r2.contains(r1)) {
            return -1;
        }
        return 0;
    }

    public void matchResource(String packageCatalogPath) {
        final HashMap<String, Integer> fileNameMap = new HashMap<String, Integer>();
        HashMap<String, String> fileDescriptionMap = new HashMap<String, String>();
        int i = 0;
        while (i < this.mPaths.size()) {
            String path = this.mPaths.get(i);
            File f = new File(String.valueOf(packageCatalogPath) + File.separator + path);
            if (!fileNameMap.containsKey(f.getName())) {
                fileNameMap.put(f.getName(), i);
            }
            fileDescriptionMap.put(f.getName(), this.mPathDescriptions.get(i));
            ++i;
        }
        Vector<String> filePaths = this.seekResourcePath(new File(packageCatalogPath), fileNameMap.keySet());
        Collections.sort(filePaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer i1 = (Integer)fileNameMap.get(new File(o1).getName());
                Integer i2 = (Integer)fileNameMap.get(new File(o2).getName());
                return i1.compareTo(i2);
            }
        });
        Vector<String> filePathDescriptions = new Vector<String>();
        int i2 = 0;
        while (i2 < filePaths.size()) {
            String desc = (String)fileDescriptionMap.get(new File(filePaths.get(i2)).getName());
            if (desc == null) {
                desc = "";
            }
            filePathDescriptions.add(i2, desc);
            filePaths.set(i2, filePaths.get(i2).substring(packageCatalogPath.length() + 1));
            ++i2;
        }
        this.mPathDescriptions = filePathDescriptions;
        this.mPaths = filePaths;
    }

    private Vector<String> seekResourcePath(File path, Set<String> fileNameSet) {
        Vector<String> paths = new Vector<String>();
        if (!path.exists()) {
            return paths;
        }
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                paths.addAll(this.seekResourcePath(f, fileNameSet));
            } else if (f.isFile() && fileNameSet.contains(f.getName())) {
                paths.add(f.getPath());
            }
            ++n2;
        }
        return paths;
    }
}

