/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ImageSelection;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class Screenshot {
    static Logger logger = Logger.getLogger(Screenshot.class.getName());
    public static float sScreenshotQuality = 0.85f;

    public static void main(String[] args) throws Exception {
        boolean device = false;
        boolean emulator = false;
        String serial = null;
        String filepath = null;
        boolean landscape = false;
        if (args.length == 0) {
            Screenshot.printUsageAndQuit();
        }
        int index = 0;
        do {
            String argument;
            if ("-d".equals(argument = args[index++])) {
                if (emulator || serial != null) {
                    Screenshot.printAndExit("-d conflicts with -e and -s", false);
                }
                device = true;
                continue;
            }
            if ("-e".equals(argument)) {
                if (device || serial != null) {
                    Screenshot.printAndExit("-e conflicts with -d and -s", false);
                }
                emulator = true;
                continue;
            }
            if ("-s".equals(argument)) {
                if (index == args.length) {
                    Screenshot.printAndExit("Missing serial number after -s", false);
                }
                if (device || emulator) {
                    Screenshot.printAndExit("-s conflicts with -d and -e", false);
                }
                serial = args[index++];
                continue;
            }
            if ("-l".equals(argument)) {
                landscape = true;
                continue;
            }
            filepath = argument;
            if (index >= args.length) continue;
            Screenshot.printAndExit("Too many arguments!", false);
        } while (index < args.length);
        if (filepath == null) {
            Screenshot.printUsageAndQuit();
        }
        Log.setLogOutput(new Log.ILogOutput(){

            @Override
            public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
                System.err.println(String.valueOf(logLevel.getStringValue()) + ":" + tag + ":" + message);
            }

            @Override
            public void printLog(Log.LogLevel logLevel, String tag, String message) {
                System.err.println(String.valueOf(logLevel.getStringValue()) + ":" + tag + ":" + message);
            }
        });
        AndroidDebugBridge.init(false);
        try {
            IDevice d;
            AndroidDebugBridge bridge = AndroidDebugBridge.createBridge();
            int count = 0;
            while (!bridge.hasInitialDeviceList()) {
                try {
                    Thread.sleep(100L);
                    ++count;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (count <= 100) continue;
                Screenshot.printAndExit("Timeout getting device list!", true);
                return;
            }
            IDevice[] devices = bridge.getDevices();
            if (devices.length == 0) {
                Screenshot.printAndExit("No devices found!", true);
            }
            IDevice target = null;
            if (emulator || device) {
                IDevice[] iDeviceArray = devices;
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    d = iDeviceArray[n2];
                    if (d.isEmulator() == emulator) {
                        if (target != null) {
                            if (emulator) {
                                Screenshot.printAndExit("Error: more than one emulator launched!", true);
                            } else {
                                Screenshot.printAndExit("Error: more than one device connected!", true);
                            }
                        }
                        target = d;
                    }
                    ++n2;
                }
            } else if (serial != null) {
                IDevice[] iDeviceArray = devices;
                int n = devices.length;
                int n3 = 0;
                while (n3 < n) {
                    d = iDeviceArray[n3];
                    if (serial.equals(d.getSerialNumber())) {
                        target = d;
                        break;
                    }
                    ++n3;
                }
            } else {
                if (devices.length > 1) {
                    Screenshot.printAndExit("Error: more than one emulator or device available!", true);
                }
                target = devices[0];
            }
            if (target != null) {
                try {
                    System.out.println("Taking screenshot from: " + target.getSerialNumber());
                    Screenshot.getDeviceImage(target, filepath, landscape);
                    System.out.println("Success.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Screenshot.printAndExit("Could not find matching device/emulator.", true);
            }
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    private void alertAndExit2(String str, boolean terminate) {
        JOptionPane.showMessageDialog(MainFrame.getInstance(), str);
    }

    public static void captureScreen(String filePath) throws Exception {
        AndroidDebugBridge.init(false);
        String adbLocation = ThemeHelper.getUserDir();
        adbLocation = OS.getOS() == 1 ? String.valueOf(adbLocation) + File.separator + "tools" + File.separator + "adb.exe" : (OS.getOS() == 3 ? String.valueOf(adbLocation) + File.separator + "tools" + File.separator + "adb-mac" : String.valueOf(adbLocation) + File.separator + "tools" + File.separator + "adb");
        AndroidDebugBridge bridge = AndroidDebugBridge.createBridge(adbLocation, false);
        int count = 0;
        while (!bridge.hasInitialDeviceList()) {
            try {
                Thread.sleep(100L);
                ++count;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (count <= 100) continue;
            Screenshot.printAndExit("Timeout getting device list!", true);
            return;
        }
        IDevice[] devices = bridge.getDevices();
        if (devices.length == 0) {
            Screenshot.printAndExit("No devices found!", true);
        }
        IDevice target = null;
        IDevice[] iDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice d = iDeviceArray[n2];
            if (!d.isEmulator()) {
                if (target != null) {
                    Screenshot.printAndExit("Error: more than one device connected!", true);
                }
                target = d;
            }
            ++n2;
        }
        if (target != null) {
            try {
                System.out.println("Taking screenshot from: " + target.getSerialNumber());
                Screenshot.getDeviceImage(target, filePath, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Screenshot.printAndExit("Could not find matching device/emulator.", true);
        }
    }

    public static void getDeviceImage(IDevice device, String filepath, boolean landscape) throws Exception {
        RawImage rawImage;
        try {
            rawImage = device.getScreenshot();
        }
        catch (IOException ioe) {
            Screenshot.printAndExit("Unable to get frame buffer: " + ioe.getMessage(), true);
            return;
        }
        if (rawImage == null) {
            return;
        }
        if (landscape) {
            rawImage = rawImage.getRotated();
        }
        BufferedImage imageRGB = new BufferedImage(rawImage.width, rawImage.height, 1);
        int index = 0;
        int IndexInc = rawImage.bpp >> 3;
        int y = 0;
        while (y < rawImage.height) {
            int x = 0;
            while (x < rawImage.width) {
                int value = rawImage.getARGB(index);
                index += IndexInc;
                imageRGB.setRGB(x, y, value);
                ++x;
            }
            ++y;
        }
        GUIUtil.saveImage(imageRGB, new File(filepath), sScreenshotQuality);
        ImageSelection is = new ImageSelection(imageRGB);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(is, null);
    }

    private static void printUsageAndQuit() {
        System.out.println("Usage: screenshot [-d | -e | -s SERIAL] [-l] OUT_FILE");
        System.out.println("");
        System.out.println("    -d      Uses the first device found.");
        System.out.println("    -e      Uses the first emulator found.");
        System.out.println("    -s      Targets the device by serial number.");
        System.out.println("");
        System.out.println("    -l      Rotate images for landscape mode.");
        System.out.println("");
        System.exit(1);
    }

    private static void printAndExit(String message, boolean terminate) throws Exception {
        logger.info(message);
        throw new Exception(message);
    }
}

