/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.update;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.update.UpdateFrame;
import com.miui.theme.tool.util.DownloadProgressListener;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.InternetDownloadTask;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;

public class CheckUpdateThread
extends Thread {
    public JButton mUpdateButton;
    private String mUrl;

    public CheckUpdateThread(JButton updateButton) {
        this.mUpdateButton = updateButton;
    }

    @Override
    public void run() {
        super.run();
        this.mUpdateButton.setEnabled(false);
        this.mUpdateButton.setText(ResourceFactory.getString("update_checking"));
        if (!ThemeHelper.isInnerUserMode()) {
            return;
        }
        this.mUrl = "http://mi.tlightsky.com/MIUIThemeEditor/version.txt";
        final File tmpVersionFile = new File(String.valueOf(ThemeHelper.getUserDir()) + File.separator + "version.new");
        try {
            InternetDownloadTask idt = new InternetDownloadTask(this.mUrl, new FileOutputStream(tmpVersionFile));
            idt.setDownloadProgressListener(new DownloadProgressListener(){

                @Override
                public void progress(long current, long total) {
                }

                @Override
                public void done(Object o) {
                    final UpdateFrame uf = new UpdateFrame();
                    if (uf.needUpdate()) {
                        CheckUpdateThread.this.mUpdateButton.setEnabled(true);
                        CheckUpdateThread.this.mUpdateButton.setVisible(true);
                        CheckUpdateThread.this.mUpdateButton.setText(ResourceFactory.getString("update_exist"));
                        CheckUpdateThread.this.mUpdateButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                uf.setVisible(true);
                            }
                        });
                    } else {
                        CheckUpdateThread.this.mUpdateButton.setText(ResourceFactory.getString("update_not_exist"));
                        CheckUpdateThread.this.mUpdateButton.setEnabled(false);
                    }
                    tmpVersionFile.delete();
                }

                @Override
                public void cancelled() {
                    GUIUtil.alert("update_user_cancelled");
                }
            });
            idt.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

