/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Set;

public class ThemeConf {
    public static final String CONF_FILE_COMMON = "common";
    public static final String CONF_FILE_MODULESTATE = "modulestate";
    public static final String CONF_MODULESTATE_TEMPLATE = "template";
    public static final String CONF_MODULESTATE_THEMEVALUES = "theme_values";
    public static final String CONF_COMMON_INNERUSER = "xiaomi";
    public static final String CONF_COMMON_KEEPRINGTONE = "keep_ringtone";
    public static final String CONF_COMMON_AUTO = "auto";
    public static final String CONF_COMMON_TEMPLATE = "template";
    private static final String CONFIGURATION = "configuration";
    private static final String CONFIGURATION_SEP = "$$";
    private static final String CONFIGURATION_SEP_RE = "\\$\\$";
    private static final String CONFIGURATION_LINE_SEP = "\n";
    public static HashMap<String, HashMap<String, String>> sConfiguration = new HashMap();

    public static HashMap<String, String> readConf(String fileName) {
        String filePath = String.valueOf(ThemeHelper.getUserDir()) + File.separator + CONFIGURATION + File.separator + fileName;
        File file = new File(filePath);
        HashMap<String, String> map = new HashMap<String, String>();
        sConfiguration.put(fileName, map);
        if (!file.exists()) {
            return map;
        }
        String str = ThemeHelper.readFromFile(file);
        if (str != null) {
            String[] strs = str.split(CONFIGURATION_LINE_SEP);
            int i = 0;
            while (i < strs.length) {
                String s = strs[i];
                String[] kv = s.split(CONFIGURATION_SEP_RE);
                if (kv != null && kv.length == 2) {
                    map.put(kv[0], kv[1]);
                }
                ++i;
            }
        }
        return map;
    }

    public static void writeConf(String fileName) {
        if (!sConfiguration.containsKey(fileName)) {
            return;
        }
        HashMap<String, String> map = sConfiguration.get(fileName);
        Set<String> keys = map.keySet();
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(String.valueOf(key) + CONFIGURATION_SEP + map.get(key) + CONFIGURATION_LINE_SEP);
        }
        String str = sb.toString();
        if (str.endsWith(CONFIGURATION_LINE_SEP)) {
            str = str.substring(0, str.length() - CONFIGURATION_LINE_SEP.length());
        }
        String filePath = String.valueOf(ThemeHelper.getUserDir()) + File.separator + CONFIGURATION + File.separator + fileName;
        File file = new File(filePath);
        ThemeHelper.writeToFile(file, str);
    }

    public static void setConf(String fileName, String key, String value) {
        HashMap<String, String> conf = null;
        conf = sConfiguration.containsKey(fileName) ? sConfiguration.get(fileName) : ThemeConf.readConf(fileName);
        conf.put(key, value);
    }

    public static String getConf(String fileName, String key) {
        HashMap<String, String> conf = null;
        conf = sConfiguration.containsKey(fileName) ? sConfiguration.get(fileName) : ThemeConf.readConf(fileName);
        if (conf.containsKey(key)) {
            return conf.get(key);
        }
        return "";
    }
}

