/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class HslFilter
implements IImageFilter {
    private static float[] sTempTriple = new float[3];
    private float mHueModify = Float.NaN;
    private float mSaturationModify = Float.NaN;
    private float mLightnessModify = Float.NaN;
    private float mHueAdjust = Float.NaN;
    private float mSaturationAdjust = Float.NaN;
    private float mLightnessAdjust = Float.NaN;
    public boolean useHsv;

    public void setHueModify(float hue) {
        this.mHueModify = ImageFilterUtils.clamp(0.0f, hue, 359.9999f);
    }

    public void setSaturationModify(float saturation) {
        this.mSaturationModify = ImageFilterUtils.clamp(0.0f, saturation /= 100.0f, 1.0f);
    }

    public void setLightnessModify(float lightness) {
        this.mLightnessModify = ImageFilterUtils.clamp(0.0f, lightness /= 100.0f, 1.0f);
    }

    public void setHueAdjust(float hue) {
        this.mHueAdjust = ImageFilterUtils.clamp(-180.0f, hue, 180.0f);
    }

    public void setSaturationAdjust(float saturation) {
        this.mSaturationAdjust = ImageFilterUtils.clamp(-1.0f, saturation /= 100.0f, 1.0f);
    }

    public void setLightnessAdjust(float lightness) {
        this.mLightnessAdjust = ImageFilterUtils.clamp(-1.0f, lightness /= 100.0f, 1.0f);
    }

    @Override
    public void process(ImageData imgData) {
        int width = imgData.width;
        int height = imgData.height;
        int[] pixels = imgData.pixels;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int colorIndex = y * width + x;
                int rgb = pixels[colorIndex];
                if (this.useHsv) {
                    ImageFilterUtils.RgbToHsv(rgb, sTempTriple);
                } else {
                    ImageFilterUtils.RgbToHsl(rgb, sTempTriple);
                }
                float h = sTempTriple[0];
                float s = sTempTriple[1];
                float l = sTempTriple[2];
                if (!Float.isNaN(this.mHueModify)) {
                    h = this.mHueModify;
                } else if (!Float.isNaN(this.mHueAdjust)) {
                    if ((h += this.mHueAdjust) >= 360.0f) {
                        h -= 360.0f;
                    } else if (h < 0.0f) {
                        h += 360.0f;
                    }
                }
                if (!Float.isNaN(this.mSaturationModify)) {
                    s = this.mSaturationModify;
                } else if (!Float.isNaN(this.mSaturationAdjust)) {
                    if (this.mSaturationAdjust <= 0.0f) {
                        s *= 1.0f + this.mSaturationAdjust;
                    } else {
                        float multipleFactor = Math.min(1.0f, this.mSaturationAdjust * 2.0f);
                        float additionFactor = (this.mSaturationAdjust - 0.5f) * 2.0f;
                        s *= 1.0f + multipleFactor;
                        if (additionFactor > 0.0f) {
                            s += additionFactor;
                        }
                    }
                    s = ImageFilterUtils.clamp(0.0f, s, 1.0f);
                }
                if (!Float.isNaN(this.mLightnessModify)) {
                    l = this.mLightnessModify;
                } else if (!Float.isNaN(this.mLightnessAdjust)) {
                    l = this.mLightnessAdjust <= 0.0f ? (l *= 1.0f + this.mLightnessAdjust) : 1.0f - (1.0f - l) * (1.0f - this.mLightnessAdjust);
                }
                int newRgb = this.useHsv ? ImageFilterUtils.HsvToRgb(h, s, l) : ImageFilterUtils.HslToRgb(h, s, l);
                pixels[colorIndex] = newRgb & 0xFFFFFF | pixels[colorIndex] & 0xFF000000;
                ++y;
            }
            ++x;
        }
    }
}

