/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import android.util.Log;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import miui.imagefilters.EdgesFilter;
import miui.imagefilters.GrayScaleFilter;
import miui.imagefilters.HslWrapFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.LevelsFilter;

public interface IImageFilter {
    public static final String TAG = "IImageFilter";

    public void process(ImageData var1);

    public static class Factory {
        public static IImageFilter create(String filterName, List<Map.Entry<String, String>> params) {
            IImageFilter filter = null;
            if ("Hsl".equalsIgnoreCase(filterName)) {
                filter = new HslWrapFilter();
            } else if ("Edges".equalsIgnoreCase(filterName)) {
                filter = new EdgesFilter();
            } else if ("Levels".equalsIgnoreCase(filterName)) {
                filter = new LevelsFilter();
            } else if ("GrayScale".equalsIgnoreCase(filterName)) {
                filter = new GrayScaleFilter();
            } else if (!"BlendImage".equalsIgnoreCase(filterName)) {
                Log.w(IImageFilter.TAG, "unknown filter:" + filterName);
                return null;
            }
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> param : params) {
                    Factory.setProperty(filter, param.getKey(), param.getValue());
                }
            }
            return filter;
        }

        private static void setProperty(Object obj, String property, String value) {
            Method[] methods;
            String strPropertyMethod = "set" + property;
            Method propertyMethod = null;
            Method[] methodArray = methods = obj.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (strPropertyMethod.equalsIgnoreCase(method.getName()) && method.getParameterTypes().length == 1) {
                    propertyMethod = method;
                    break;
                }
                ++n2;
            }
            if (propertyMethod == null) {
                Log.w(IImageFilter.TAG, "unknown property:" + property + ",obj:" + obj);
                return;
            }
            Class<?> paramClass = propertyMethod.getParameterTypes()[0];
            try {
                Object objValue = null;
                if (String.class.equals(paramClass)) {
                    objValue = value;
                } else if (Integer.TYPE.equals(paramClass)) {
                    objValue = Integer.parseInt(value);
                } else if (Float.TYPE.equals(paramClass)) {
                    objValue = Float.valueOf(Float.parseFloat(value));
                } else if (Double.TYPE.equals(paramClass)) {
                    objValue = Double.parseDouble(value);
                } else if (Boolean.TYPE.equals(paramClass)) {
                    objValue = Boolean.parseBoolean(value);
                } else if (paramClass.isEnum()) {
                    objValue = Enum.valueOf(paramClass, value);
                } else {
                    Log.w(IImageFilter.TAG, "unknown param type:" + paramClass.getName() + ",obj:" + obj + ",property:" + property);
                    return;
                }
                propertyMethod.invoke(obj, objValue);
            }
            catch (Exception e) {
                Log.e(IImageFilter.TAG, "set property fail. obj:" + obj + ",property:" + property + ",value:" + value, e);
            }
        }
    }
}

