/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.extended.colorchooser.ColorChooserFieldType;
import com.alee.extended.image.WebImage;
import com.alee.extended.painter.DefaultPainter;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebDialog;
import com.alee.laf.text.WebTextField;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.ColorUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class WebColorChooserField
extends WebTextField {
    public static final ImageIcon pipetteIcon = new ImageIcon(WebColorChooserField.class.getResource("icons/eyedropper.png"));
    private Color color;
    private ColorChooserFieldType fieldType;
    private boolean pipetteEnabled = true;
    private int pipettePixels = 9;
    private int pixelSize = 11;
    private String last = "";
    private Robot robot;
    private WebImage pipettePicker;
    private WebButton colorButton;
    private JWindow popup;
    private WebColorChooserPanel colorChooserPanel;

    public WebColorChooserField() {
        this(Color.WHITE);
    }

    public WebColorChooserField(Color color) {
        this.updatePipette();
        this.colorButton = new WebButton(ImageUtils.createColorChooserIcon(color));
        this.colorButton.setFocusable(false);
        this.colorButton.setShadeWidth(0);
        this.colorButton.setMoveIconOnPress(false);
        this.colorButton.setRolloverDecoratedOnly(true);
        this.colorButton.setCursor(Cursor.getDefaultCursor());
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebColorChooserField.this.showColorChooserPopup();
            }
        });
        this.setTrailingComponent(this.colorButton);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebColorChooserField.this.updateColorFromField();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (WebColorChooserField.this.isEnabled() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    WebColorChooserField.this.showColorChooserPopup();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebColorChooserField.this.updateColorFromField();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (WebColorChooserField.this.isEnabled()) {
                    if (Hotkey.ESCAPE.isTriggered(keyEvent)) {
                        WebColorChooserField.this.updateViewFromColor();
                    } else if (Hotkey.DOWN.isTriggered(keyEvent)) {
                        WebColorChooserField.this.showColorChooserPopup();
                    }
                }
            }
        });
        this.setFieldType(ColorChooserFieldType.rgb);
        this.setColor(color);
        this.updateMargin();
        this.setHorizontalAlignment(0);
    }

    public boolean isPipetteEnabled() {
        return this.pipetteEnabled;
    }

    public void setPipetteEnabled(boolean bl) {
        this.pipetteEnabled = bl;
        this.updatePipette();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateViewFromColor();
    }

    public ColorChooserFieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(ColorChooserFieldType colorChooserFieldType) {
        this.fieldType = colorChooserFieldType;
        this.updateFieldType();
    }

    @Override
    public void setDrawBorder(boolean bl) {
        super.setDrawBorder(bl);
        this.updateMargin();
    }

    private void updateViewFromColor() {
        this.colorButton.setIcon(ImageUtils.createColorChooserIcon(this.color));
        this.updateText();
    }

    private void updateColorFromField() {
        String string = this.getText();
        if (!string.equals(this.last)) {
            try {
                Color color;
                boolean bl = this.fieldType.equals((Object)ColorChooserFieldType.hex);
                Color color2 = color = bl ? ColorUtils.parseHexColor(string) : ColorUtils.parseRgbColor(string);
                if (color != null) {
                    color = ColorUtils.removeAlpha(color);
                    this.setColor(color);
                } else {
                    this.updateViewFromColor();
                }
            }
            catch (Throwable throwable) {
                this.updateViewFromColor();
            }
        }
    }

    private void updateFieldType() {
        if (this.fieldType != null) {
            boolean bl = this.fieldType.equals((Object)ColorChooserFieldType.hex);
            this.setColumns(bl ? 6 : 9);
            this.updateText();
        }
    }

    private void updateText() {
        if (this.color != null) {
            String string = this.getColorText(this.color);
            this.setText(string);
            this.last = string;
        }
    }

    private String getColorText(Color color) {
        boolean bl = this.fieldType.equals((Object)ColorChooserFieldType.hex);
        return bl ? ColorUtils.getHexColor(color) : color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    private void updateMargin() {
        this.setMargin(this.isDrawBorder() ? new Insets(-1, 0, -1, -1) : new Insets(0, 0, 0, 0));
    }

    private void updatePipette() {
        if (this.pipetteEnabled) {
            this.installPipette();
        } else {
            this.uninstallPipette();
        }
        this.revalidate();
    }

    private void installPipette() {
        if (this.pipettePicker == null) {
            this.pipettePicker = new WebImage(pipetteIcon);
            try {
                this.robot = new Robot();
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            if (this.robot != null) {
                MouseAdapter mouseAdapter = new MouseAdapter(){
                    private boolean shouldUpdateColor;
                    private WebDialog window;
                    private WebPanel screen;
                    private WebLabel info;
                    private boolean updating = false;
                    private BufferedImage screenshot;
                    private Color color;

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (WebColorChooserField.this.pipetteEnabled && SwingUtils.isLeftMouseButton(mouseEvent)) {
                            this.shouldUpdateColor = true;
                            this.createPreviewWindow();
                            this.updateWindowLocation();
                            this.window.pack();
                            this.window.setVisible(true);
                            this.screen.requestFocus();
                            this.updateScreenshot();
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                        if (WebColorChooserField.this.pipetteEnabled && SwingUtils.isLeftMouseButton(mouseEvent) && this.window != null) {
                            this.updateWindowLocation();
                            this.updateScreenshot();
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        if (WebColorChooserField.this.pipetteEnabled && SwingUtils.isLeftMouseButton(mouseEvent) && this.window != null) {
                            this.window.dispose();
                        }
                    }

                    private void updateScreenshot() {
                        if (!this.updating) {
                            this.updating = true;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (screen != null) {
                                        Point point = MouseInfo.getPointerInfo().getLocation();
                                        screenshot = WebColorChooserField.this.robot.createScreenCapture(new Rectangle(point.x - WebColorChooserField.this.pipettePixels / 2, point.y - WebColorChooserField.this.pipettePixels / 2, WebColorChooserField.this.pipettePixels, WebColorChooserField.this.pipettePixels));
                                        color = new Color(screenshot.getRGB(WebColorChooserField.this.pipettePixels / 2, WebColorChooserField.this.pipettePixels / 2));
                                        if (screen != null) {
                                            screen.repaint();
                                            info.setText(WebColorChooserField.this.getColorText(color));
                                        } else {
                                            screenshot.flush();
                                            screenshot = null;
                                            color = null;
                                        }
                                    }
                                    updating = false;
                                }
                            }).start();
                        }
                    }

                    private void createPreviewWindow() {
                        this.window = new WebDialog(WebColorChooserField.this.pipettePicker);
                        this.window.setLayout(new BorderLayout());
                        this.window.setUndecorated(true);
                        this.window.setAlwaysOnTop(true);
                        this.window.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent windowEvent) {
                                if (screenshot != null) {
                                    if (shouldUpdateColor) {
                                        WebColorChooserField.this.setColor(color);
                                    }
                                    screenshot.flush();
                                    screenshot = null;
                                }
                                HotkeyManager.unregisterHotkeys(screen);
                                window = null;
                                screen = null;
                            }
                        });
                        DefaultPainter<WebPanel> defaultPainter = new DefaultPainter<WebPanel>(){

                            @Override
                            public void paint(Graphics2D graphics2D, Rectangle rectangle, WebPanel webPanel) {
                                if (window.isShowing() && WebColorChooserField.this.robot != null) {
                                    graphics2D.drawImage(screenshot, rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4, null);
                                    graphics2D.setPaint(Color.BLACK);
                                    graphics2D.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
                                    graphics2D.setPaint(Color.WHITE);
                                    graphics2D.drawRect(1, 1, rectangle.width - 3, rectangle.height - 3);
                                    int n = rectangle.x + rectangle.width / 2;
                                    int n2 = rectangle.y + rectangle.height / 2;
                                    graphics2D.setPaint(Color.WHITE);
                                    graphics2D.drawLine(n - 1, n2 - 7, n - 1, n2 + 7);
                                    graphics2D.drawLine(n + 1, n2 - 7, n + 1, n2 + 7);
                                    graphics2D.drawLine(n - 7, n2 - 1, n + 7, n2 - 1);
                                    graphics2D.drawLine(n - 7, n2 + 1, n + 7, n2 + 1);
                                    graphics2D.setPaint(Color.BLACK);
                                    graphics2D.drawLine(n, n2 - 7, n, n2 + 7);
                                    graphics2D.drawLine(n - 7, n2, n + 7, n2);
                                }
                            }
                        };
                        this.screen = new WebPanel(defaultPainter);
                        this.screen.setFocusable(true);
                        this.screen.setPreferredSize(new Dimension(WebColorChooserField.this.pipettePixels * WebColorChooserField.this.pixelSize + 4, WebColorChooserField.this.pipettePixels * WebColorChooserField.this.pixelSize + 4));
                        this.window.add((Component)this.screen, "Center");
                        this.info = new WebLabel(10);
                        this.info.setMargin(4);
                        this.info.setIcon(new Icon(){

                            @Override
                            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                                if (color != null) {
                                    Graphics2D graphics2D = (Graphics2D)graphics;
                                    graphics2D.setPaint(Color.BLACK);
                                    graphics2D.drawRect(n, n2, 15, 15);
                                    graphics2D.setPaint(Color.WHITE);
                                    graphics2D.drawRect(n + 1, n2 + 1, 13, 13);
                                    graphics2D.setPaint(color);
                                    graphics2D.fillRect(n + 2, n2 + 2, 12, 12);
                                }
                            }

                            @Override
                            public int getIconWidth() {
                                return 16;
                            }

                            @Override
                            public int getIconHeight() {
                                return 16;
                            }
                        });
                        this.info.setPainter(new DefaultPainter<WebLabel>(){

                            @Override
                            public Insets getMargin(WebLabel webLabel) {
                                return new Insets(0, 2, 2, 2);
                            }

                            @Override
                            public void paint(Graphics2D graphics2D, Rectangle rectangle, WebLabel webLabel) {
                                graphics2D.setPaint(Color.BLACK);
                                graphics2D.drawRect(rectangle.x, rectangle.y - 1, rectangle.width - 1, rectangle.height);
                            }
                        });
                        this.window.add((Component)this.info, "South");
                        HotkeyManager.registerHotkey((Component)this.screen, Hotkey.ESCAPE, new HotkeyRunnable(){

                            @Override
                            public void run(KeyEvent keyEvent) {
                                if (window != null) {
                                    shouldUpdateColor = false;
                                    window.dispose();
                                }
                            }
                        });
                    }

                    private void updateWindowLocation() {
                        Point point = MouseInfo.getPointerInfo().getLocation();
                        Rectangle rectangle = this.window.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getBounds();
                        int n = this.window.getWidth();
                        int n2 = this.window.getHeight();
                        int n3 = point.x + 20 + n < rectangle.x + rectangle.width ? point.x + 20 : point.x - 20 - n;
                        int n4 = point.y + 20 + n2 < rectangle.y + rectangle.height ? point.y + 20 : point.y - 20 - n2;
                        this.window.setLocation(n3, n4);
                    }
                };
                this.pipettePicker.addMouseListener(mouseAdapter);
                this.pipettePicker.addMouseMotionListener(mouseAdapter);
                this.pipettePicker.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.setLeadingComponent(this.pipettePicker);
    }

    private void uninstallPipette() {
        this.setLeadingComponent(null);
    }

    private void showColorChooserPopup() {
        if (!this.requestFocusInWindow() && !this.isFocusOwner()) {
            return;
        }
        this.updateColorFromField();
        if (this.popup == null || this.colorChooserPanel == null) {
            Window window = SwingUtils.getWindowAncestor(this);
            this.colorChooserPanel = new WebColorChooserPanel(true);
            this.colorChooserPanel.setColor(this.color);
            this.colorChooserPanel.setUndecorated(false);
            this.colorChooserPanel.setDrawFocus(false);
            this.colorChooserPanel.setRound(StyleConstants.smallRound);
            this.colorChooserPanel.setShadeWidth(0);
            this.popup = new JWindow(window);
            this.popup.setLayout(new BorderLayout());
            this.popup.add(this.colorChooserPanel);
            SwingUtils.setWindowOpaque(this.popup, false);
            this.popup.pack();
            this.updatePopupLocation();
            window.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }
            });
            window.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }
            });
            FocusManager.registerFocusTracker(new DefaultFocusTracker(this.colorChooserPanel){

                @Override
                public boolean isTrackingEnabled() {
                    return true;
                }

                @Override
                public void focusChanged(boolean bl) {
                    if (!bl) {
                        WebColorChooserField.this.popup.setVisible(false);
                    }
                }
            });
            this.colorChooserPanel.addColorChooserListener(new ColorChooserListener(){

                @Override
                public void okPressed(ActionEvent actionEvent) {
                    WebColorChooserField.this.setColor(WebColorChooserField.this.colorChooserPanel.getColor());
                    WebColorChooserField.this.popup.setVisible(false);
                }

                @Override
                public void resetPressed(ActionEvent actionEvent) {
                }

                @Override
                public void cancelPressed(ActionEvent actionEvent) {
                    WebColorChooserField.this.popup.setVisible(false);
                }
            });
        } else {
            this.updatePopupLocation();
            this.colorChooserPanel.setColor(this.color);
        }
        SwingUtils.copyOrientation(this, this.popup);
        this.popup.setVisible(true);
        this.colorChooserPanel.requestFocusInWindow();
    }

    private void updatePopupLocation() {
        Point point = this.getLocationOnScreen();
        Rectangle rectangle = this.popup.getGraphicsConfiguration().getBounds();
        int n = this.isDrawBorder() ? this.getShadeWidth() : 0;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = bl ? (point.x + n + this.popup.getWidth() <= rectangle.x + rectangle.width ? point.x + n : point.x + n2 - n - this.popup.getWidth()) : (point.x + n2 - n - this.popup.getWidth() >= rectangle.x ? point.x + n2 - n - this.popup.getWidth() : point.x + n);
        int n5 = point.y + n3 + this.popup.getHeight() <= rectangle.y + rectangle.height ? point.y + n3 + (this.isDrawBorder() ? 0 : 1) : point.y - this.popup.getHeight() - (this.isDrawBorder() ? 0 : 1);
        this.popup.setLocation(n4, n5);
    }
}

