/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.drag.FileDropHandler;
import com.alee.extended.filechooser.FilesSelectionListener;
import com.alee.extended.filechooser.FilesToChoose;
import com.alee.extended.filechooser.SelectionMode;
import com.alee.extended.filechooser.WebFileChooser;
import com.alee.extended.filefilter.DefaultFileFilter;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.panel.CenterPanel;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WebFileChooserField
extends WebPanel {
    public static final ImageIcon CROSS_ICON = new ImageIcon(WebFileChooserField.class.getResource("icons/cross.png"));
    private List<FilesSelectionListener> listeners = new ArrayList<FilesSelectionListener>();
    private List<File> selectedFiles = new ArrayList<File>();
    private SelectionMode selectionMode = SelectionMode.MULTIPLE_SELECTION;
    private int preferredWidth = -1;
    private boolean showFileShortName = true;
    private boolean showFileIcon = true;
    private boolean showRemoveButton = true;
    private boolean showFileExtensions = false;
    private boolean showChooseButton = true;
    private boolean filesDropEnabled = true;
    private WebFileChooser webFileChooser = null;
    private WebPanel contentPanel;
    private WebScrollPane scroll;
    private WebButton chooseButton;

    public WebFileChooserField() {
        this((Window)null);
    }

    public WebFileChooserField(Window window) {
        this(window, true);
    }

    public WebFileChooserField(boolean bl) {
        this((Window)null, bl);
    }

    public WebFileChooserField(Window window, boolean bl) {
        super(true);
        this.showChooseButton = bl;
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.setWebColored(false);
        this.setDrawFocus(true);
        this.setMargin(-1);
        this.setBackground(Color.WHITE);
        this.contentPanel = new WebPanel();
        this.contentPanel.setOpaque(false);
        this.setTransferHandler(new FileDropHandler(){

            @Override
            protected boolean isDropEnabled() {
                return WebFileChooserField.this.filesDropEnabled;
            }

            @Override
            protected boolean filesImported(List<File> list) {
                WebFileChooserField.this.setSelectedFiles(list);
                return WebFileChooserField.this.getSelectedFiles().size() > 0;
            }
        });
        this.contentPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                Rectangle rectangle = WebFileChooserField.this.contentPanel.getVisibleRect();
                WebFileChooserField.this.contentPanel.scrollRectToVisible(new Rectangle(rectangle.x + mouseWheelEvent.getWheelRotation() * 25, rectangle.y, rectangle.width, rectangle.height));
            }
        });
        this.scroll = new WebScrollPane(this.contentPanel, false){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = ((WebFileChooserField)WebFileChooserField.this).contentPanel.getPreferredSize().height;
                return dimension;
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(21);
        this.scroll.setMargin(1);
        this.add((Component)this.scroll, (Object)"Center");
        if (this.showChooseButton) {
            this.webFileChooser = new WebFileChooser(window);
            this.webFileChooser.setSelectionMode(this.selectionMode);
            this.webFileChooser.setOkListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebFileChooserField.this.setSelectedFiles(WebFileChooserField.this.webFileChooser.getSelectedFiles());
                }
            });
            this.chooseButton = new WebButton("...");
            this.chooseButton.setRound(this.getRound());
            this.chooseButton.setLeftRightSpacing(StyleConstants.smallLeftRightSpacing);
            this.chooseButton.setDrawFocus(false);
            this.chooseButton.setDrawLeft(false);
            this.chooseButton.setDrawLeftLine(true);
            this.chooseButton.setRolloverDarkBorderOnly(false);
            this.chooseButton.setShadeWidth(0);
            this.chooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebFileChooserField.this.webFileChooser.setVisible(true);
                    WebFileChooserField.this.chooseButton.requestFocusInWindow();
                }
            });
            this.contentPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        WebFileChooserField.this.chooseButton.doClick(0);
                    }
                }
            });
            this.add((Component)this.chooseButton, (Object)"After");
        }
        this.updateContentLayout();
    }

    private void updateContentLayout() {
        this.contentPanel.setLayout(new HorizontalFlowLayout(0, this.isSingleSelection()));
    }

    public WebFileChooser getWebFileChooser() {
        return this.webFileChooser;
    }

    public WebButton getChooseButton() {
        return this.chooseButton;
    }

    public boolean isShowChooseButton() {
        return this.showChooseButton;
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        if (this.webFileChooser != null) {
            this.webFileChooser.setSelectionMode(selectionMode);
        }
        this.updateContentLayout();
    }

    public boolean isFilesDropEnabled() {
        return this.filesDropEnabled;
    }

    public void setFilesDropEnabled(boolean bl) {
        this.filesDropEnabled = bl;
    }

    public void setCurrentDirectory(String string) {
        this.webFileChooser.setCurrentDirectory(string);
    }

    public void setCurrentDirectory(File file) {
        this.webFileChooser.setCurrentDirectory(file);
    }

    public File getCurrentDirectory() {
        return this.webFileChooser.getCurrentDirectory();
    }

    public FilesToChoose getFilesToChoose() {
        return this.webFileChooser.getFilesToChoose();
    }

    public void setFilesToChoose(FilesToChoose filesToChoose) {
        this.webFileChooser.setFilesToChoose(filesToChoose);
    }

    public List<DefaultFileFilter> getAvailableFilters() {
        if (this.webFileChooser != null) {
            return this.webFileChooser.getAvailableFilters();
        }
        return null;
    }

    public void setAvailableFilter(DefaultFileFilter defaultFileFilter) {
        this.webFileChooser.setAvailableFilter(defaultFileFilter);
    }

    public void setAvailableFilters(List<DefaultFileFilter> list) {
        this.webFileChooser.setAvailableFilters(list);
    }

    public boolean isShowFileShortName() {
        return this.showFileShortName;
    }

    public void setShowFileShortName(boolean bl) {
        this.showFileShortName = bl;
        this.updateSelectedFiles();
    }

    public boolean isShowFileIcon() {
        return this.showFileIcon;
    }

    public void setShowFileIcon(boolean bl) {
        this.showFileIcon = bl;
        this.updateSelectedFiles();
    }

    public boolean isShowRemoveButton() {
        return this.showRemoveButton;
    }

    public void setShowRemoveButton(boolean bl) {
        this.showRemoveButton = bl;
        this.updateSelectedFiles();
    }

    public boolean isShowFileExtensions() {
        return this.showFileExtensions;
    }

    public void setShowFileExtensions(boolean bl) {
        this.showFileExtensions = bl;
        this.updateSelectedFiles();
    }

    public List<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setSelectedFile(File file) {
        this.selectedFiles.clear();
        if (file != null && FileUtils.isFileAccepted(file, this.getAvailableFilters())) {
            this.selectedFiles.add(file);
        }
        this.updateSelectedFiles();
        this.fireSelectionChanged(this.selectedFiles);
    }

    public void setSelectedFiles(List<File> list) {
        this.selectedFiles.clear();
        if (list != null && list.size() > 0) {
            if (this.isSingleSelection()) {
                for (File file : list) {
                    if (!FileUtils.isFileAccepted(file, this.getAvailableFilters())) continue;
                    this.selectedFiles.add(file);
                    break;
                }
            } else {
                for (File file : list) {
                    if (!FileUtils.isFileAccepted(file, this.getAvailableFilters())) continue;
                    this.selectedFiles.add(file);
                }
            }
        }
        this.updateSelectedFiles();
        this.fireSelectionChanged(this.selectedFiles);
    }

    public void clearSelectedFiles() {
        this.setSelectedFiles(null);
    }

    private void updateSelectedFiles() {
        this.contentPanel.removeAll();
        for (File file : this.selectedFiles) {
            FilePlate filePlate = new FilePlate(file);
            filePlate.applyComponentOrientation(this.getComponentOrientation());
            this.contentPanel.add((Component)filePlate);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    private boolean isSingleSelection() {
        return this.getSelectionMode().equals((Object)SelectionMode.SINGLE_SELECTION);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            dimension.width = this.preferredWidth;
        }
        return dimension;
    }

    public void addSelectedFilesListener(FilesSelectionListener filesSelectionListener) {
        this.listeners.add(filesSelectionListener);
    }

    public void removeSelectedFilesListener(FilesSelectionListener filesSelectionListener) {
        this.listeners.remove(filesSelectionListener);
    }

    private void fireSelectionChanged(List<File> list) {
        for (FilesSelectionListener filesSelectionListener : CollectionUtils.copy(this.listeners)) {
            filesSelectionListener.selectionChanged(list);
        }
    }

    public class FilePlate
    extends WebPanel {
        public FilePlate(final File file) {
            super(true);
            this.setLayout(new BorderLayout());
            this.setDrawSides(false, false, false, true);
            this.setShadeWidth(0);
            this.setMargin(0, 3, 0, 1);
            this.setFocusable(true);
            String string = FileUtils.getDisplayFileName(file);
            final String string2 = WebFileChooserField.this.showFileExtensions || file.isDirectory() ? string : FileUtils.getFileNamePart(string);
            final String string3 = file.getAbsolutePath();
            final WebLabel webLabel = new WebLabel(WebFileChooserField.this.showFileShortName ? string2 : string3);
            webLabel.setIcon(WebFileChooserField.this.showFileIcon ? FileUtils.getFileIcon(file, false) : null);
            webLabel.setMargin(0, 0, 0, 2);
            this.add((Component)webLabel, (Object)"Center");
            this.addMouseListener(new MouseAdapter(){
                private boolean showShortName;
                {
                    this.showShortName = WebFileChooserField.this.showFileShortName;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    FilePlate.this.requestFocusInWindow();
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        if (WebFileChooserField.this.getSelectionMode().equals((Object)SelectionMode.MULTIPLE_SELECTION)) {
                            this.showShortName = !this.showShortName;
                            webLabel.setText(this.showShortName ? string2 : string3);
                        } else {
                            WebFileChooserField.this.setShowFileShortName(!WebFileChooserField.this.isShowFileShortName());
                        }
                    }
                    FilePlate.this.scrollToPlate();
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    FilePlate.this.scrollToPlate();
                }
            });
            if (WebFileChooserField.this.showRemoveButton) {
                WebButton webButton = new WebButton(CROSS_ICON);
                webButton.setLeftRightSpacing(0);
                webButton.setInnerShadeWidth(2);
                webButton.setRound(StyleConstants.smallRound);
                webButton.setShadeWidth(StyleConstants.shadeWidth);
                webButton.setFocusable(false);
                webButton.setRolloverDecoratedOnly(true);
                webButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WebFileChooserField.this.selectedFiles.remove(file);
                        WebFileChooserField.this.contentPanel.remove(FilePlate.this);
                        WebFileChooserField.this.revalidate();
                        WebFileChooserField.this.repaint();
                        WebFileChooserField.this.fireSelectionChanged(WebFileChooserField.this.selectedFiles);
                    }
                });
                this.add((Component)new CenterPanel(webButton), (Object)"After");
            }
        }

        private void scrollToPlate() {
            Rectangle rectangle = this.getBounds();
            int n = WebFileChooserField.this.scroll.getWidth() - 2;
            rectangle.width = n < rectangle.width ? n : rectangle.width;
            WebFileChooserField.this.contentPanel.scrollRectToVisible(rectangle);
        }
    }
}

