/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.ninepatch;

import com.alee.extended.ninepatch.NinePatchInfo;
import com.alee.extended.ninepatch.ZoomChangeListener;
import com.alee.laf.StyleConstants;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.swing.MouseEventType;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NinePatchEditor
extends JComponent {
    public static final Color STRETCH_GUIDELINES_COLOR = new Color(60, 150, 0);
    public static final Color STRETCH_COLOR = new Color(80, 150, 0, 100);
    public static final Color CONTENT_GUIDELINES_COLOR = new Color(80, 80, 80, 200);
    public static final Color CONTENT_COLOR = new Color(90, 90, 255, 100);
    public static final Color METRICS_BORDER = new Color(191, 191, 191);
    public static final Color METRICS_TOP = Color.WHITE;
    public static final Color METRICS_BOTTOM = new Color(229, 233, 238);
    public static final int RULER_LENGTH = 20;
    public static final int ADDITIONAL_SPACE = 80;
    public static final int SNAP = 3;
    public static final int MIN_ZOOM = 1;
    public static final int MAX_ZOOM = 32;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private List<ZoomChangeListener> zoomChangeListeners = new ArrayList<ZoomChangeListener>();
    private List<NinePatchInfo> history = new ArrayList<NinePatchInfo>();
    private int historyState = -1;
    private BufferedImage ninePatchImage = null;
    private NinePatchIcon ninePatchIcon = null;
    private boolean showGuideSpacing = true;
    private boolean showRuler = true;
    private boolean fillStretchAreas = true;
    private boolean fillContentArea = true;
    private boolean showRulerCursorPosition = true;
    private boolean showAreaCursorPosition = false;
    private int zoom = 5;
    private WebScrollPane view;
    private boolean changed = false;
    private boolean someDragged = false;
    private HotkeyRunnable undoRunnable;
    private HotkeyRunnable redoRunnable;

    public NinePatchEditor() {
        SwingUtils.setOrientation(this);
        this.setFocusable(true);
        this.setLayout(new TableLayout(new double[][]{{20.0, -2.0, -1.0}, {20.0, -2.0, -1.0}}));
        this.setFont(new JLabel().getFont().deriveFont(10.0f));
        this.view = new WebScrollPane(this, false);
        NinePatchEditorMouseAdapter ninePatchEditorMouseAdapter = new NinePatchEditorMouseAdapter();
        this.addMouseListener(ninePatchEditorMouseAdapter);
        this.addMouseMotionListener(ninePatchEditorMouseAdapter);
        this.addMouseWheelListener(ninePatchEditorMouseAdapter);
    }

    public WebScrollPane getView() {
        return this.view;
    }

    public boolean isSomeDragged() {
        return this.someDragged;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int n) {
        this.zoom = Math.max(1, Math.min(n, 32));
        this.revalidate();
        this.repaint();
        this.fireZoomChanged();
    }

    public boolean isFillStretchAreas() {
        return this.fillStretchAreas;
    }

    public void setFillStretchAreas(boolean bl) {
        this.fillStretchAreas = bl;
        this.repaint();
    }

    public boolean isFillContentArea() {
        return this.fillContentArea;
    }

    public void setFillContentArea(boolean bl) {
        this.fillContentArea = bl;
        this.repaint();
    }

    public boolean isShowRulerCursorPosition() {
        return this.showRulerCursorPosition;
    }

    public void setShowRulerCursorPosition(boolean bl) {
        this.showRulerCursorPosition = bl;
        this.repaint();
    }

    public boolean isShowAreaCursorPosition() {
        return this.showAreaCursorPosition;
    }

    public void setShowAreaCursorPosition(boolean bl) {
        this.showAreaCursorPosition = bl;
        this.repaint();
    }

    public boolean isShowGuideSpacing() {
        return this.showGuideSpacing;
    }

    public void setShowGuideSpacing(boolean bl) {
        this.showGuideSpacing = bl;
        this.repaint();
    }

    public boolean isShowRuler() {
        return this.showRuler;
    }

    public void setShowRuler(boolean bl) {
        this.showRuler = bl;
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.ninePatchIcon.getImage();
    }

    public BufferedImage getNinePatchImage() {
        this.assembleImage();
        return this.ninePatchImage;
    }

    public void setNinePatchImage(BufferedImage bufferedImage) {
        if (this.isSomeDragged()) {
            return;
        }
        this.disassembleImage(bufferedImage);
        this.validateIcon();
        this.revalidate();
        this.repaint();
        this.clearHistory();
        this.saveHistoryState();
        this.changed = false;
        this.fireStateChanged();
    }

    public void setNinePatchIcon(NinePatchIcon ninePatchIcon) {
        if (this.isSomeDragged()) {
            return;
        }
        this.ninePatchIcon = ninePatchIcon;
        this.validateIcon();
        this.revalidate();
        this.repaint();
        this.clearHistory();
        this.saveHistoryState();
        this.changed = false;
        this.fireStateChanged();
    }

    public void setNinePatchInfo(NinePatchInfo ninePatchInfo) {
        if (this.ninePatchIcon == null || ninePatchInfo == null || this.isSomeDragged() || this.getNinePatchInfo().equals(ninePatchInfo)) {
            return;
        }
        this.ninePatchIcon.setVerticalStretch(ninePatchInfo.getVerticalStretch());
        this.verifyVerticalStretchAreas();
        this.ninePatchIcon.setHorizontalStretch(ninePatchInfo.getHorizontalStretch());
        this.verifyHorizontalStretchAreas();
        this.ninePatchIcon.setMargin(ninePatchInfo.getMargin());
        this.verifyMargin();
        this.validateIcon();
        this.revalidate();
        this.repaint();
        this.saveHistoryState();
    }

    public NinePatchInfo getNinePatchInfo() {
        if (this.ninePatchIcon == null) {
            return null;
        }
        NinePatchInfo ninePatchInfo = new NinePatchInfo();
        ninePatchInfo.setImageSize(this.ninePatchIcon.getRealImageSize());
        ninePatchInfo.setHorizontalStretch(this.ninePatchIcon.getHorizontalStretch());
        ninePatchInfo.setVerticalStretch(this.ninePatchIcon.getVerticalStretch());
        ninePatchInfo.setMargin(this.ninePatchIcon.getMargin());
        return ninePatchInfo;
    }

    public NinePatchIcon getNinePatchIcon() {
        return this.ninePatchIcon;
    }

    public void undo() {
        if (!this.isSomeDragged() && this.historyState > 0) {
            --this.historyState;
            this.restoreHistoryState(this.history.get(this.historyState));
        }
    }

    public void redo() {
        if (!this.isSomeDragged() && this.historyState < this.history.size() - 1) {
            ++this.historyState;
            this.restoreHistoryState(this.history.get(this.historyState));
        }
    }

    private void restoreHistoryState(NinePatchInfo ninePatchInfo) {
        if (!ninePatchInfo.getImageSize().equals(this.ninePatchIcon.getRealImageSize())) {
            return;
        }
        this.ninePatchIcon.setMargin(SwingUtils.copy(ninePatchInfo.getMargin()));
        this.ninePatchIcon.setHorizontalStretch(NinePatchUtils.copy(ninePatchInfo.getHorizontalStretch()));
        this.ninePatchIcon.setVerticalStretch(NinePatchUtils.copy(ninePatchInfo.getVerticalStretch()));
        this.validateIcon();
        this.revalidate();
        this.repaint();
        this.fireStateChanged();
        this.changed = this.historyState > 0;
    }

    private void saveHistoryState() {
        if (this.ninePatchIcon != null) {
            for (int i = this.history.size() - 1; i > this.historyState; --i) {
                this.history.remove(i);
            }
            NinePatchInfo ninePatchInfo = new NinePatchInfo();
            ninePatchInfo.setImageSize(this.ninePatchIcon.getRealImageSize());
            ninePatchInfo.setMargin(SwingUtils.copy(this.ninePatchIcon.getMargin()));
            ninePatchInfo.setHorizontalStretch(NinePatchUtils.copy(this.ninePatchIcon.getHorizontalStretch()));
            ninePatchInfo.setVerticalStretch(NinePatchUtils.copy(this.ninePatchIcon.getVerticalStretch()));
            this.history.add(ninePatchInfo);
            this.historyState = this.history.size() - 1;
            this.changed = true;
        }
    }

    private void clearHistory() {
        this.history.clear();
        this.historyState = -1;
    }

    private void validateIcon() {
    }

    private boolean hasHorizontalStretch() {
        for (NinePatchInterval ninePatchInterval : this.ninePatchIcon.getHorizontalStretch()) {
            if (ninePatchInterval.isPixel()) continue;
            return true;
        }
        return false;
    }

    private int getSnap() {
        return Math.max(3, this.zoom / 2);
    }

    private void verifyHorizontalStretchAreas() {
        boolean[] blArray = this.getHorizontalFilledPixels();
        this.ninePatchIcon.setHorizontalStretch(NinePatchUtils.parseStretchIntervals(blArray));
    }

    private boolean[] getHorizontalFilledPixels() {
        boolean[] blArray = new boolean[this.getImage().getWidth()];
        for (NinePatchInterval ninePatchInterval : this.ninePatchIcon.getHorizontalStretch()) {
            for (int i = ninePatchInterval.getStart(); i <= ninePatchInterval.getEnd(); ++i) {
                if (ninePatchInterval.isPixel() || i >= blArray.length) continue;
                blArray[i] = true;
            }
        }
        return blArray;
    }

    private void verifyVerticalStretchAreas() {
        boolean[] blArray = this.getVerticalFilledPixels();
        this.ninePatchIcon.setVerticalStretch(NinePatchUtils.parseStretchIntervals(blArray));
    }

    private boolean[] getVerticalFilledPixels() {
        boolean[] blArray = new boolean[this.getImage().getHeight()];
        for (NinePatchInterval ninePatchInterval : this.ninePatchIcon.getVerticalStretch()) {
            for (int i = ninePatchInterval.getStart(); i <= ninePatchInterval.getEnd(); ++i) {
                if (ninePatchInterval.isPixel() || i >= blArray.length) continue;
                blArray[i] = true;
            }
        }
        return blArray;
    }

    private void verifyMargin() {
        int n;
        Insets insets = this.ninePatchIcon.getMargin();
        int n2 = this.getImage().getHeight() - 1;
        if (insets.top > n2) {
            insets.top = n2;
        }
        if (insets.bottom + insets.top > n2) {
            insets.bottom = n2 - insets.top;
        }
        if (insets.left > (n = this.getImage().getWidth() - 1)) {
            insets.left = n;
        }
        if (insets.right + insets.left > n) {
            insets.right = n - insets.left;
        }
    }

    private void disassembleImage(BufferedImage bufferedImage) {
        try {
            this.ninePatchIcon = new NinePatchIcon(bufferedImage);
            this.ninePatchImage = bufferedImage;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2, 3);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 1, 1, null);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.drawLine(1, 0, bufferedImage2.getWidth() - 2, 0);
            graphics2D.drawLine(0, 1, 0, bufferedImage2.getHeight() - 2);
            graphics2D.dispose();
            this.ninePatchIcon = new NinePatchIcon(bufferedImage2);
            this.ninePatchImage = bufferedImage2;
        }
    }

    private void assembleImage() {
        int n;
        this.ninePatchImage = ImageUtils.createCompatibleImage(this.getImage().getWidth() + 2, this.getImage().getHeight() + 2, 3);
        Graphics2D graphics2D = this.ninePatchImage.createGraphics();
        graphics2D.drawImage((Image)this.getImage(), 1, 1, null);
        graphics2D.dispose();
        int n2 = Color.BLACK.getRGB();
        boolean[] blArray = this.getHorizontalFilledPixels();
        for (int i = 0; i < this.getImage().getWidth(); ++i) {
            if (!blArray[i]) continue;
            this.ninePatchImage.setRGB(i + 1, 0, n2);
        }
        boolean[] blArray2 = this.getVerticalFilledPixels();
        for (int i = 0; i < this.getImage().getHeight(); ++i) {
            if (!blArray2[i]) continue;
            this.ninePatchImage.setRGB(0, i + 1, n2);
        }
        Insets insets = this.ninePatchIcon.getMargin();
        for (n = insets.left; n < this.getImage().getWidth() - insets.right; ++n) {
            this.ninePatchImage.setRGB(n + 1, this.ninePatchImage.getHeight() - 1, n2);
        }
        for (n = insets.top; n < this.getImage().getHeight() - insets.bottom; ++n) {
            this.ninePatchImage.setRGB(this.ninePatchImage.getWidth() - 1, n + 1, n2);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.ninePatchIcon != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            BufferedImage bufferedImage = this.getImage();
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = bufferedImage.getWidth() * this.zoom;
            int n4 = bufferedImage.getHeight() * this.zoom;
            Insets insets = this.ninePatchIcon.getMargin();
            int n5 = (n + (this.showRuler ? 20 : 0)) / 2 - n3 / 2;
            int n6 = (n2 + (this.showRuler ? 20 : 0)) / 2 - n4 / 2;
            Stroke stroke = graphics2D.getStroke();
            LafUtils.drawAlphaLayer(graphics2D, n5, n6, n3, n4);
            graphics2D.setPaint(Color.DARK_GRAY);
            graphics2D.drawRect(n5, n6, n3, n4);
            graphics.drawImage(bufferedImage, n5, n6, n3, n4, null);
            graphics2D.setStroke(StyleConstants.guidelinesStroke);
            for (NinePatchInterval ninePatchInterval : this.ninePatchIcon.getHorizontalStretch()) {
                if (ninePatchInterval.isPixel()) continue;
                if (this.fillStretchAreas) {
                    graphics2D.setPaint(STRETCH_COLOR);
                    graphics2D.fillRect(n5 + ninePatchInterval.getStart() * this.zoom, n6, (ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1) * this.zoom, n4);
                }
                graphics2D.setPaint(STRETCH_GUIDELINES_COLOR);
                graphics2D.drawLine(n5 + ninePatchInterval.getStart() * this.zoom, 0, n5 + ninePatchInterval.getStart() * this.zoom, n6 + n4 - 1);
                graphics2D.drawLine(n5 + (ninePatchInterval.getEnd() + 1) * this.zoom, 0, n5 + (ninePatchInterval.getEnd() + 1) * this.zoom, n6 + n4 - 1);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.fillRect(n5 + ninePatchInterval.getStart() * this.zoom + 1, n6 - this.zoom, (ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1) * this.zoom - 1, this.zoom);
            }
            for (NinePatchInterval ninePatchInterval : this.ninePatchIcon.getVerticalStretch()) {
                if (ninePatchInterval.isPixel()) continue;
                if (this.fillStretchAreas) {
                    graphics2D.setPaint(STRETCH_COLOR);
                    graphics2D.fillRect(n5, n6 + ninePatchInterval.getStart() * this.zoom, n3, (ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1) * this.zoom);
                }
                graphics2D.setPaint(STRETCH_GUIDELINES_COLOR);
                graphics2D.drawLine(0, n6 + ninePatchInterval.getStart() * this.zoom, n5 + n3 - 1, n6 + ninePatchInterval.getStart() * this.zoom);
                graphics2D.drawLine(0, n6 + (ninePatchInterval.getEnd() + 1) * this.zoom, n5 + n3 - 1, n6 + (ninePatchInterval.getEnd() + 1) * this.zoom);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.fillRect(n5 - this.zoom, n6 + ninePatchInterval.getStart() * this.zoom + 1, this.zoom, (ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1) * this.zoom - 1);
            }
            int n7 = this.getContentStartX(n5, n, n3, insets);
            int n8 = this.getContentEndX(n5, n, n3, insets);
            int n9 = this.getContentStartY(n6, n2, n4, insets);
            int n10 = this.getContentEndY(n6, n2, n4, insets);
            if (this.fillContentArea) {
                graphics2D.setPaint(CONTENT_COLOR);
                graphics2D.fillRect(n7 + 1, n9 + 1, n3 - (insets.left + insets.right) * this.zoom - 1, n4 - (insets.top + insets.bottom) * this.zoom - 1);
            }
            graphics2D.setPaint(CONTENT_GUIDELINES_COLOR);
            graphics2D.drawLine(n7, n6, n7, n2);
            graphics2D.drawLine(n8, n6, n8, n2);
            graphics2D.drawLine(n5, n9, n, n9);
            graphics2D.drawLine(n5, n10, n, n10);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.fillRect(n5 + n3 + 1, n9 + 1, this.zoom, n10 - n9 - 1);
            graphics2D.fillRect(n7 + 1, n6 + n4 + 1, n8 - n7 - 1, this.zoom);
            graphics2D.setStroke(stroke);
            if (this.showGuideSpacing) {
                int n11;
                Integer n12;
                Integer n13;
                Integer n14;
                graphics2D.setPaint(Color.BLACK);
                List<Integer> list = this.getHorizontalGuides();
                for (int i = 0; i < list.size() - 1; ++i) {
                    Integer n15 = list.get(i);
                    n14 = list.get(i + 1);
                    n13 = n5 + n15 * this.zoom;
                    n12 = n5 + n14 * this.zoom;
                    int n16 = n6 - this.zoom - 10;
                    n11 = n6 - this.zoom - 7;
                    graphics2D.drawLine(n13, n16, n12, n16);
                    graphics2D.drawLine(n13, n16, n13, n11);
                    graphics2D.drawLine(n12, n16, n12, n11);
                    String string = "" + (n14 - n15);
                    graphics2D.drawString(string, (n13 + n12) / 2 - fontMetrics.stringWidth(string) / 2, n6 - this.zoom - 15);
                }
                List<Integer> list2 = this.getVerticalGuides();
                for (int i = 0; i < list2.size() - 1; ++i) {
                    n14 = list2.get(i);
                    n13 = list2.get(i + 1);
                    n12 = n6 + n14 * this.zoom;
                    Integer n17 = n6 + n13 * this.zoom;
                    n11 = n5 - this.zoom - 10;
                    int n18 = n5 - this.zoom - 7;
                    graphics2D.drawLine(n11, n12, n11, n17);
                    graphics2D.drawLine(n11, n12, n18, n12);
                    graphics2D.drawLine(n11, n17, n18, n17);
                    String string = "" + (n13 - n14);
                    graphics2D.drawString(string, n11 - fontMetrics.stringWidth(string) - 5, (n12 + n17) / 2 + fontMetrics.getAscent() / 2);
                }
            }
            if (this.showRuler) {
                this.drawRuler(graphics2D, new Point(n5 - 1, n6 - 1), n5, n6, n3, n4);
            }
        }
    }

    private void drawRuler(Graphics2D graphics2D, Point point, int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        int n6;
        Object object2;
        Rectangle rectangle = this.getVisibleRect();
        int n7 = this.getMinorTicks();
        int n8 = this.getMajorTicks();
        int n9 = this.zoom;
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, METRICS_TOP, rectangle.x, rectangle.y + 20, METRICS_BOTTOM));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, 20);
        graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, METRICS_TOP, rectangle.x + 20, rectangle.y, METRICS_BOTTOM));
        graphics2D.fillRect(rectangle.x, rectangle.y, 20, rectangle.height);
        if (this.showRulerCursorPosition || this.showAreaCursorPosition) {
            object2 = SwingUtils.getMousePoint(this);
            if (((Point)object2).x > rectangle.x + 20 && ((Point)object2).x < rectangle.x + rectangle.width && ((Point)object2).y > rectangle.y + 20 && ((Point)object2).y < rectangle.y + rectangle.height) {
                n6 = (((Point)object2).x - n) / this.zoom - (((Point)object2).x >= n ? 0 : 1);
                n5 = (((Point)object2).y - n2) / this.zoom - (((Point)object2).y >= n2 ? 0 : 1);
                object = LafUtils.setupAlphaComposite(graphics2D, 0.5f);
                if (this.showRulerCursorPosition) {
                    graphics2D.setPaint(Color.RED);
                    graphics2D.fillRect(n + n6 * this.zoom, rectangle.y, this.zoom, 20);
                    graphics2D.fillRect(rectangle.x, n2 + n5 * this.zoom, 20, this.zoom);
                }
                if (this.showAreaCursorPosition) {
                    Shape shape = LafUtils.intersectClip(graphics2D, new Rectangle(rectangle.x + 20, rectangle.y + 20, rectangle.width - 20, rectangle.height - 20), this.showAreaCursorPosition);
                    graphics2D.setPaint(Color.RED);
                    graphics2D.fillRect(n + n6 * this.zoom, rectangle.y, this.zoom, rectangle.height);
                    graphics2D.fillRect(rectangle.x, n2 + n5 * this.zoom, rectangle.width, this.zoom);
                    LafUtils.restoreClip(graphics2D, shape);
                }
                LafUtils.restoreComposite(graphics2D, (Composite)object);
            }
        }
        graphics2D.setPaint(Color.BLACK);
        for (n5 = n6 = rectangle.x + (point.x - rectangle.x) % n7; n5 <= rectangle.x + rectangle.width; n5 += n7) {
            graphics2D.drawLine(n5, rectangle.y + 20 - 6, n5, rectangle.y + 20);
        }
        for (n5 = n6 = rectangle.x + (point.x - rectangle.x) % n8; n5 <= rectangle.x + rectangle.width; n5 += n8) {
            graphics2D.drawLine(n5, rectangle.y + 20 - 15, n5, rectangle.y + 20);
            object2 = "" + (n5 - point.x) / n9;
            graphics2D.drawString((String)object2, n5 + 2, rectangle.y + 20 - 10);
        }
        graphics2D.setPaint(Color.BLACK);
        graphics2D.drawLine(rectangle.x + 20, rectangle.y + 20, rectangle.x + rectangle.width, rectangle.y + 20);
        for (n5 = n6 = rectangle.y + (point.y - rectangle.y) % n7; n5 <= rectangle.y + rectangle.height; n5 += n7) {
            graphics2D.drawLine(rectangle.x + 20 - 6, n5, rectangle.x + 20, n5);
        }
        for (n5 = n6 = rectangle.y + (point.y - rectangle.y) % n8; n5 <= rectangle.y + rectangle.height; n5 += n8) {
            graphics2D.drawLine(rectangle.x + 20 - 15, n5, rectangle.x + 20, n5);
            object2 = "" + (n5 - point.y) / n9;
            graphics2D.rotate(Math.toRadians(-90.0));
            graphics2D.drawString((String)object2, 1 - n5 - this.getFontMetrics(this.getFont()).stringWidth((String)object2) - 2, rectangle.x + 20 - 10);
            graphics2D.rotate(Math.toRadians(90.0));
        }
        graphics2D.setPaint(Color.BLACK);
        graphics2D.drawLine(rectangle.x + 20, rectangle.y + 20, rectangle.x + 20, rectangle.y + rectangle.height);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(rectangle.x, rectangle.y, 20, 20);
        String string = this.zoom + "x";
        object = graphics2D.getFontMetrics();
        graphics2D.setPaint(Color.DARK_GRAY);
        graphics2D.drawString(string, rectangle.x + 10 - ((FontMetrics)object).stringWidth(string) / 2, rectangle.y + 10 + ((FontMetrics)object).getHeight() / 4);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.drawLine(rectangle.x + 20, rectangle.y, rectangle.x + 20, rectangle.y + 20);
        graphics2D.drawLine(rectangle.x, rectangle.y + 20, rectangle.x + 20, rectangle.y + 20);
    }

    private int getMajorTicks() {
        switch (this.zoom) {
            case 1: {
                return this.zoom * 50;
            }
            case 2: {
                return this.zoom * 20;
            }
            case 3: {
                return this.zoom * 20;
            }
            case 4: {
                return this.zoom * 10;
            }
            case 5: {
                return this.zoom * 10;
            }
            case 6: {
                return this.zoom * 10;
            }
        }
        return this.zoom * 5;
    }

    private int getMinorTicks() {
        switch (this.zoom) {
            case 1: {
                return this.zoom * 5;
            }
            case 2: {
                return this.zoom * 5;
            }
            case 3: {
                return this.zoom * 2;
            }
            case 4: {
                return this.zoom * 2;
            }
            case 5: {
                return this.zoom;
            }
            case 6: {
                return this.zoom;
            }
        }
        return this.zoom;
    }

    private List<Integer> getHorizontalGuides() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (NinePatchInterval ninePatchInterval : this.ninePatchIcon.getHorizontalStretch()) {
            if (!arrayList.contains(ninePatchInterval.getStart())) {
                arrayList.add(ninePatchInterval.getStart());
            }
            if (arrayList.contains(ninePatchInterval.getEnd() + 1)) continue;
            arrayList.add(ninePatchInterval.getEnd() + 1);
        }
        Insets insets = this.ninePatchIcon.getMargin();
        if (!arrayList.contains(insets.left)) {
            arrayList.add(insets.left);
        }
        if (!arrayList.contains(this.getImage().getWidth() - insets.right)) {
            arrayList.add(this.getImage().getWidth() - insets.right);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private List<Integer> getVerticalGuides() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (NinePatchInterval ninePatchInterval : this.ninePatchIcon.getVerticalStretch()) {
            if (!arrayList.contains(ninePatchInterval.getStart())) {
                arrayList.add(ninePatchInterval.getStart());
            }
            if (arrayList.contains(ninePatchInterval.getEnd() + 1)) continue;
            arrayList.add(ninePatchInterval.getEnd() + 1);
        }
        Insets insets = this.ninePatchIcon.getMargin();
        if (!arrayList.contains(insets.top)) {
            arrayList.add(insets.top);
        }
        if (!arrayList.contains(this.getImage().getHeight() - insets.bottom)) {
            arrayList.add(this.getImage().getHeight() - insets.bottom);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private int getContentStartX(int n, int n2, int n3, Insets insets) {
        return n + insets.left * this.zoom;
    }

    private int getContentEndX(int n, int n2, int n3, Insets insets) {
        return n + n3 - insets.right * this.zoom;
    }

    private int getContentStartY(int n, int n2, int n3, Insets insets) {
        return n + insets.top * this.zoom;
    }

    private int getContentEndY(int n, int n2, int n3, Insets insets) {
        return n + n3 - insets.bottom * this.zoom;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(20 + ((this.ninePatchImage != null ? this.ninePatchImage.getWidth() : 0) + 2) * this.zoom + 80, 20 + ((this.ninePatchImage != null ? this.ninePatchImage.getHeight() : 0) + 2) * this.zoom + 80);
    }

    public List<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : CollectionUtils.copy(this.changeListeners)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public List<ZoomChangeListener> getZoomChangeListeners() {
        return this.zoomChangeListeners;
    }

    public void addZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        this.zoomChangeListeners.add(zoomChangeListener);
    }

    public void removeZoomChangeListener(ZoomChangeListener zoomChangeListener) {
        this.zoomChangeListeners.add(zoomChangeListener);
    }

    private void fireZoomChanged() {
        for (ZoomChangeListener zoomChangeListener : CollectionUtils.copy(this.zoomChangeListeners)) {
            zoomChangeListener.zoomChanged();
        }
    }

    private class NinePatchEditorMouseAdapter
    extends MouseAdapter {
        private boolean cameraDragged = false;
        private boolean hContentAreaDragged = false;
        private boolean hContentStartDragged = false;
        private boolean hContentEndDragged = false;
        private boolean vContentAreaDragged = false;
        private boolean vContentStartDragged = false;
        private boolean vContentEndDragged = false;
        private boolean contentAreaDragged = false;
        private boolean hStretchAreaDragged = false;
        private boolean hStretchStartDragged = false;
        private boolean hStretchEndDragged = false;
        private boolean vStretchAreaDragged = false;
        private boolean vStretchStartDragged = false;
        private boolean vStretchEndDragged = false;
        private boolean addingHorizontalStretch = false;
        private boolean addingVerticalStretch = false;
        private boolean removingHorizontalStretch = false;
        private boolean removingVerticalStretch = false;
        private int startX = -1;
        private int startY = -1;
        private Rectangle startRect = null;
        private Insets startMargin = null;
        private NinePatchInterval changedInterval = null;
        private NinePatchInterval removedInterval = null;

        private NinePatchEditorMouseAdapter() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.mouseEvent(mouseWheelEvent, MouseEventType.mouseWheelMoved);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseEvent(mouseEvent, MouseEventType.mousePressed);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseEvent(mouseEvent, MouseEventType.mouseDragged);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseEvent(mouseEvent, MouseEventType.mouseReleased);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseEvent(mouseEvent, MouseEventType.mouseEntered);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseEvent(mouseEvent, MouseEventType.mouseExited);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseEvent(mouseEvent, MouseEventType.mouseMoved);
        }

        private void mouseEvent(MouseEvent mouseEvent, MouseEventType mouseEventType) {
            if (this.processMouseEvent(mouseEvent, mouseEventType)) {
                NinePatchEditor.this.repaint();
            }
        }

        private boolean processMouseEvent(MouseEvent mouseEvent, MouseEventType mouseEventType) {
            boolean bl = false;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            BufferedImage bufferedImage = NinePatchEditor.this.getImage();
            int n3 = NinePatchEditor.this.getWidth();
            int n4 = NinePatchEditor.this.getHeight();
            int n5 = bufferedImage.getWidth() * NinePatchEditor.this.zoom;
            int n6 = bufferedImage.getHeight() * NinePatchEditor.this.zoom;
            Insets insets = NinePatchEditor.this.ninePatchIcon.getMargin();
            int n7 = (n3 + (NinePatchEditor.this.showRuler ? 20 : 0)) / 2 - n5 / 2;
            int n8 = (n4 + (NinePatchEditor.this.showRuler ? 20 : 0)) / 2 - n6 / 2;
            int n9 = NinePatchEditor.this.getContentStartX(n7, n3, n5, insets);
            int n10 = NinePatchEditor.this.getContentEndX(n7, n3, n5, insets);
            int n11 = NinePatchEditor.this.getContentStartY(n8, n4, n6, insets);
            int n12 = NinePatchEditor.this.getContentEndY(n8, n4, n6, insets);
            if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                NinePatchEditor.this.requestFocusInWindow();
            }
            if ((NinePatchEditor.this.showRulerCursorPosition || NinePatchEditor.this.showAreaCursorPosition) && mouseEventType.equals((Object)MouseEventType.mouseMoved) || mouseEventType.equals((Object)MouseEventType.mouseDragged) || mouseEventType.equals((Object)MouseEventType.mouseEntered) || mouseEventType.equals((Object)MouseEventType.mouseExited)) {
                bl = true;
            }
            if (!NinePatchEditor.this.someDragged && mouseEventType.equals((Object)MouseEventType.mouseWheelMoved) && (SwingUtils.isCtrl(mouseEvent) || SwingUtils.isAlt(mouseEvent))) {
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
                NinePatchEditor.this.setZoom(NinePatchEditor.this.getZoom() - mouseWheelEvent.getWheelRotation());
                NinePatchEditor.this.setCursor(Cursor.getDefaultCursor());
                return bl;
            }
            if (SwingUtilities.isMiddleMouseButton(mouseEvent) && (this.cameraDragged || !NinePatchEditor.this.someDragged)) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.cameraDragged = true;
                    this.startRect = NinePatchEditor.this.getVisibleRect();
                    mouseEvent = SwingUtilities.convertMouseEvent(NinePatchEditor.this, mouseEvent, NinePatchEditor.this.view);
                    this.startX = mouseEvent.getX();
                    this.startY = mouseEvent.getY();
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(12));
                } else if (this.cameraDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    mouseEvent = SwingUtilities.convertMouseEvent(NinePatchEditor.this, mouseEvent, NinePatchEditor.this.view);
                    NinePatchEditor.this.view.getWebHorizontalScrollBar().setValue(this.startRect.x - (mouseEvent.getX() - this.startX));
                    NinePatchEditor.this.view.getWebVerticalScrollBar().setValue(this.startRect.y - (mouseEvent.getY() - this.startY));
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(12));
                } else if (this.cameraDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.cameraDragged = false;
                    NinePatchEditor.this.setCursor(Cursor.getDefaultCursor());
                }
                return bl;
            }
            if (NinePatchEditor.this.ninePatchIcon == null || NinePatchEditor.this.ninePatchImage == null) {
                return bl;
            }
            if (this.hContentAreaDragged || !NinePatchEditor.this.someDragged && new Rectangle(n9, n8 + n6, n10 - n9, NinePatchEditor.this.zoom).contains(n, n2)) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.hContentAreaDragged = true;
                    this.startX = n;
                    this.startMargin = insets;
                } else if (this.hContentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n13;
                    int n14 = (n - this.startX) / NinePatchEditor.this.zoom;
                    int n15 = this.startMargin.left + n14;
                    if (n15 < 0) {
                        n15 = 0;
                    }
                    if (n15 > bufferedImage.getWidth() - 1) {
                        n15 = bufferedImage.getWidth() - 1;
                    }
                    if ((n13 = this.startMargin.right - n14) < 0) {
                        n13 = 0;
                    }
                    if (n13 > bufferedImage.getWidth() - 1) {
                        n13 = bufferedImage.getWidth() - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(new Insets(this.startMargin.top, n15, this.startMargin.bottom, n13));
                    bl = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.hContentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.hContentAreaDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                return bl;
            }
            if (this.vContentAreaDragged || !NinePatchEditor.this.someDragged && new Rectangle(n7 + n5, n11, NinePatchEditor.this.zoom, n12 - n11).contains(n, n2)) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.vContentAreaDragged = true;
                    this.startY = n2;
                    this.startMargin = insets;
                } else if (this.vContentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n16;
                    int n17 = (n2 - this.startY) / NinePatchEditor.this.zoom;
                    int n18 = this.startMargin.top + n17;
                    if (n18 < 0) {
                        n18 = 0;
                    }
                    if (n18 > bufferedImage.getHeight() - 1) {
                        n18 = bufferedImage.getHeight() - 1;
                    }
                    if ((n16 = this.startMargin.bottom - n17) < 0) {
                        n16 = 0;
                    }
                    if (n16 > bufferedImage.getHeight() - 1) {
                        n16 = bufferedImage.getHeight() - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(new Insets(n18, this.startMargin.left, n16, this.startMargin.right));
                    bl = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.vContentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.vContentAreaDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                return bl;
            }
            if (this.hContentStartDragged || !NinePatchEditor.this.someDragged && n2 >= n8 && n9 + NinePatchEditor.this.getSnap() >= n && n9 - NinePatchEditor.this.getSnap() <= n) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.hContentStartDragged = true;
                    this.startX = n;
                    this.startMargin = insets;
                } else if (this.hContentStartDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n19 = (n - this.startX) / NinePatchEditor.this.zoom;
                    int n20 = this.startMargin.left + n19;
                    if (n20 < 0) {
                        n20 = 0;
                    }
                    if (n20 > bufferedImage.getWidth() - this.startMargin.right - 1) {
                        n20 = bufferedImage.getWidth() - this.startMargin.right - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(new Insets(this.startMargin.top, n20, this.startMargin.bottom, this.startMargin.right));
                    bl = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.hContentStartDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.hContentStartDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(11));
                return bl;
            }
            if (this.hContentEndDragged || !NinePatchEditor.this.someDragged && n2 >= n8 && n10 + NinePatchEditor.this.getSnap() >= n && n10 - NinePatchEditor.this.getSnap() <= n) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.hContentEndDragged = true;
                    this.startX = n;
                    this.startMargin = insets;
                } else if (this.hContentEndDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n21 = (n - this.startX) / NinePatchEditor.this.zoom;
                    int n22 = this.startMargin.right - n21;
                    if (n22 < 0) {
                        n22 = 0;
                    }
                    if (n22 > bufferedImage.getWidth() - this.startMargin.left - 1) {
                        n22 = bufferedImage.getWidth() - this.startMargin.left - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(new Insets(this.startMargin.top, this.startMargin.left, this.startMargin.bottom, n22));
                    bl = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.hContentEndDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.hContentEndDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(11));
                return bl;
            }
            if (this.vContentStartDragged || !NinePatchEditor.this.someDragged && n >= n7 && n11 + NinePatchEditor.this.getSnap() >= n2 && n11 - NinePatchEditor.this.getSnap() <= n2) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.vContentStartDragged = true;
                    this.startY = n2;
                    this.startMargin = insets;
                } else if (this.vContentStartDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n23 = (n2 - this.startY) / NinePatchEditor.this.zoom;
                    int n24 = this.startMargin.top + n23;
                    if (n24 < 0) {
                        n24 = 0;
                    }
                    if (n24 > bufferedImage.getHeight() - this.startMargin.bottom - 1) {
                        n24 = bufferedImage.getHeight() - this.startMargin.bottom - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(new Insets(n24, this.startMargin.left, this.startMargin.bottom, this.startMargin.right));
                    bl = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.vContentStartDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.vContentStartDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(9));
                return bl;
            }
            if (this.vContentEndDragged || !NinePatchEditor.this.someDragged && n >= n7 && n12 + NinePatchEditor.this.getSnap() >= n2 && n12 - NinePatchEditor.this.getSnap() <= n2) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.vContentEndDragged = true;
                    this.startY = n2;
                    this.startMargin = insets;
                } else if (this.vContentEndDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n25 = (n2 - this.startY) / NinePatchEditor.this.zoom;
                    int n26 = this.startMargin.bottom - n25;
                    if (n26 < 0) {
                        n26 = 0;
                    }
                    if (n26 > bufferedImage.getHeight() - this.startMargin.top - 1) {
                        n26 = bufferedImage.getHeight() - this.startMargin.top - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(new Insets(this.startMargin.top, this.startMargin.left, n26, this.startMargin.right));
                    bl = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.vContentEndDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.vContentEndDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(9));
                return bl;
            }
            for (NinePatchInterval ninePatchInterval : NinePatchEditor.this.ninePatchIcon.getHorizontalStretch()) {
                if (ninePatchInterval.isPixel()) continue;
                if (this.hStretchAreaDragged && this.changedInterval.isSame(ninePatchInterval) || !NinePatchEditor.this.someDragged && new Rectangle(n7 + ninePatchInterval.getStart() * NinePatchEditor.this.zoom, n8 - NinePatchEditor.this.zoom, (ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1) * NinePatchEditor.this.zoom, NinePatchEditor.this.zoom + (NinePatchEditor.this.fillStretchAreas ? n6 : 0)).contains(n, n2)) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                        NinePatchEditor.this.someDragged = true;
                        this.hStretchAreaDragged = true;
                        this.startX = n;
                        this.changedInterval = ninePatchInterval.clone();
                    } else if (this.hStretchAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int n27;
                        int n28 = (n - this.startX) / NinePatchEditor.this.zoom;
                        int n29 = this.changedInterval.getStart() + n28;
                        if (n29 < 0) {
                            n29 = 0;
                        }
                        if (n29 > bufferedImage.getWidth() - 1) {
                            n29 = bufferedImage.getWidth() - 1;
                        }
                        if ((n27 = this.changedInterval.getEnd() + n28) < 0) {
                            n27 = 0;
                        }
                        if (n27 > bufferedImage.getWidth() - 1) {
                            n27 = bufferedImage.getWidth() - 1;
                        }
                        ninePatchInterval.setStart(n29);
                        ninePatchInterval.setEnd(n27);
                        bl = true;
                    } else if (this.hStretchAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.hStretchAreaDragged = false;
                        NinePatchEditor.this.verifyHorizontalStretchAreas();
                        bl = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                    return bl;
                }
                if (n2 > n8 + n6) continue;
                if (this.hStretchStartDragged && this.changedInterval.isSame(ninePatchInterval) || !NinePatchEditor.this.someDragged && n7 + ninePatchInterval.getStart() * NinePatchEditor.this.zoom - NinePatchEditor.this.getSnap() <= n && n <= n7 + ninePatchInterval.getStart() * NinePatchEditor.this.zoom + NinePatchEditor.this.getSnap()) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                        NinePatchEditor.this.someDragged = true;
                        this.hStretchStartDragged = true;
                        this.startX = n;
                        this.changedInterval = ninePatchInterval.clone();
                    } else if (this.hStretchStartDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int n30 = (n - this.startX) / NinePatchEditor.this.zoom;
                        int n31 = this.changedInterval.getStart() + n30;
                        if (n31 < 0) {
                            n31 = 0;
                        }
                        if (n31 > this.changedInterval.getEnd()) {
                            n31 = this.changedInterval.getEnd();
                        }
                        ninePatchInterval.setStart(n31);
                        bl = true;
                    } else if (this.hStretchStartDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.hStretchStartDragged = false;
                        NinePatchEditor.this.verifyHorizontalStretchAreas();
                        bl = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(11));
                    return bl;
                }
                if ((!this.hStretchEndDragged || !this.changedInterval.isSame(ninePatchInterval)) && (NinePatchEditor.this.someDragged || n7 + (ninePatchInterval.getEnd() + 1) * NinePatchEditor.this.zoom - NinePatchEditor.this.getSnap() > n || n > n7 + (ninePatchInterval.getEnd() + 1) * NinePatchEditor.this.zoom + NinePatchEditor.this.getSnap())) continue;
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.hStretchEndDragged = true;
                    this.startX = n;
                    this.changedInterval = ninePatchInterval.clone();
                } else if (this.hStretchEndDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n32 = (n - this.startX) / NinePatchEditor.this.zoom;
                    int n33 = this.changedInterval.getEnd() + n32;
                    if (n33 < this.changedInterval.getStart()) {
                        n33 = this.changedInterval.getStart();
                    }
                    if (n33 > bufferedImage.getWidth() - 1) {
                        n33 = bufferedImage.getWidth() - 1;
                    }
                    ninePatchInterval.setEnd(n33);
                    bl = true;
                } else if (this.hStretchEndDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.hStretchEndDragged = false;
                    NinePatchEditor.this.verifyHorizontalStretchAreas();
                    bl = true;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(11));
                return bl;
            }
            for (NinePatchInterval ninePatchInterval : NinePatchEditor.this.ninePatchIcon.getVerticalStretch()) {
                if (ninePatchInterval.isPixel()) continue;
                if (this.vStretchAreaDragged && this.changedInterval.isSame(ninePatchInterval) || !NinePatchEditor.this.someDragged && new Rectangle(n7 - NinePatchEditor.this.zoom, n8 + ninePatchInterval.getStart() * NinePatchEditor.this.zoom, NinePatchEditor.this.zoom + (NinePatchEditor.this.fillStretchAreas ? n5 : 0), (ninePatchInterval.getEnd() - ninePatchInterval.getStart() + 1) * NinePatchEditor.this.zoom).contains(n, n2)) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                        NinePatchEditor.this.someDragged = true;
                        this.vStretchAreaDragged = true;
                        this.startY = n2;
                        this.changedInterval = ninePatchInterval.clone();
                    } else if (this.vStretchAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int n34;
                        int n35 = (n2 - this.startY) / NinePatchEditor.this.zoom;
                        int n36 = this.changedInterval.getStart() + n35;
                        if (n36 < 0) {
                            n36 = 0;
                        }
                        if (n36 > bufferedImage.getHeight() - 1) {
                            n36 = bufferedImage.getHeight() - 1;
                        }
                        if ((n34 = this.changedInterval.getEnd() + n35) < 0) {
                            n34 = 0;
                        }
                        if (n34 > bufferedImage.getHeight() - 1) {
                            n34 = bufferedImage.getHeight() - 1;
                        }
                        ninePatchInterval.setStart(n36);
                        ninePatchInterval.setEnd(n34);
                        bl = true;
                    } else if (this.vStretchAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.vStretchAreaDragged = false;
                        NinePatchEditor.this.verifyVerticalStretchAreas();
                        bl = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                    return bl;
                }
                if (n > n7 + n5) continue;
                if (this.vStretchStartDragged && this.changedInterval.isSame(ninePatchInterval) || !NinePatchEditor.this.someDragged && n8 + ninePatchInterval.getStart() * NinePatchEditor.this.zoom - NinePatchEditor.this.getSnap() <= n2 && n2 <= n8 + ninePatchInterval.getStart() * NinePatchEditor.this.zoom + NinePatchEditor.this.getSnap()) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                        NinePatchEditor.this.someDragged = true;
                        this.vStretchStartDragged = true;
                        this.startY = n2;
                        this.changedInterval = ninePatchInterval.clone();
                    } else if (this.vStretchStartDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int n37 = (n2 - this.startY) / NinePatchEditor.this.zoom;
                        int n38 = this.changedInterval.getStart() + n37;
                        if (n38 < 0) {
                            n38 = 0;
                        }
                        if (n38 > this.changedInterval.getEnd()) {
                            n38 = this.changedInterval.getEnd();
                        }
                        ninePatchInterval.setStart(n38);
                        bl = true;
                    } else if (this.vStretchStartDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.vStretchStartDragged = false;
                        NinePatchEditor.this.verifyVerticalStretchAreas();
                        bl = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                    NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(9));
                    return bl;
                }
                if ((!this.vStretchEndDragged || !this.changedInterval.isSame(ninePatchInterval)) && (NinePatchEditor.this.someDragged || n8 + (ninePatchInterval.getEnd() + 1) * NinePatchEditor.this.zoom - NinePatchEditor.this.getSnap() > n2 || n2 > n8 + (ninePatchInterval.getEnd() + 1) * NinePatchEditor.this.zoom + NinePatchEditor.this.getSnap())) continue;
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.vStretchEndDragged = true;
                    this.startY = n2;
                    this.changedInterval = ninePatchInterval.clone();
                } else if (this.vStretchEndDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n39 = (n2 - this.startY) / NinePatchEditor.this.zoom;
                    int n40 = this.changedInterval.getEnd() + n39;
                    if (n40 < this.changedInterval.getStart()) {
                        n40 = this.changedInterval.getStart();
                    }
                    if (n40 > bufferedImage.getHeight() - 1) {
                        n40 = bufferedImage.getHeight() - 1;
                    }
                    ninePatchInterval.setEnd(n40);
                    bl = true;
                } else if (this.vStretchEndDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.vStretchEndDragged = false;
                    NinePatchEditor.this.verifyVerticalStretchAreas();
                    bl = true;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(9));
                return bl;
            }
            if (NinePatchEditor.this.fillContentArea && (this.contentAreaDragged || !NinePatchEditor.this.someDragged && new Rectangle(n9, n11, n10 - n9, n12 - n11).contains(n, n2))) {
                if (mouseEventType.equals((Object)MouseEventType.mousePressed)) {
                    NinePatchEditor.this.someDragged = true;
                    this.contentAreaDragged = true;
                    this.startX = n;
                    this.startY = n2;
                    this.startMargin = insets;
                } else if (this.contentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                    int n41;
                    int n42;
                    int n43;
                    int n44;
                    int n45 = (n2 - this.startY) / NinePatchEditor.this.zoom;
                    int n46 = this.startMargin.top + n45;
                    if (n46 < 0) {
                        n46 = 0;
                    }
                    if (n46 > bufferedImage.getHeight() - 1) {
                        n46 = bufferedImage.getHeight() - 1;
                    }
                    if ((n44 = this.startMargin.bottom - n45) < 0) {
                        n44 = 0;
                    }
                    if (n44 > bufferedImage.getHeight() - 1) {
                        n44 = bufferedImage.getHeight() - 1;
                    }
                    if ((n43 = this.startMargin.left + (n42 = (n - this.startX) / NinePatchEditor.this.zoom)) < 0) {
                        n43 = 0;
                    }
                    if (n43 > bufferedImage.getWidth() - 1) {
                        n43 = bufferedImage.getWidth() - 1;
                    }
                    if ((n41 = this.startMargin.right - n42) < 0) {
                        n41 = 0;
                    }
                    if (n41 > bufferedImage.getWidth() - 1) {
                        n41 = bufferedImage.getWidth() - 1;
                    }
                    NinePatchEditor.this.ninePatchIcon.setMargin(new Insets(n46, n43, n44, n41));
                    bl = true;
                    NinePatchEditor.this.fireStateChanged();
                } else if (this.contentAreaDragged && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                    NinePatchEditor.this.someDragged = false;
                    this.contentAreaDragged = false;
                    NinePatchEditor.this.saveHistoryState();
                    NinePatchEditor.this.fireStateChanged();
                }
                NinePatchEditor.this.setCursor(Cursor.getPredefinedCursor(13));
                return bl;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.addingHorizontalStretch || !NinePatchEditor.this.someDragged) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed) && n > n7 && n < n7 + n5 && n2 < n8) {
                        NinePatchEditor.this.someDragged = true;
                        this.addingHorizontalStretch = true;
                        this.startX = n;
                        this.changedInterval = new NinePatchInterval((n - n7) / NinePatchEditor.this.zoom, false);
                        NinePatchEditor.this.ninePatchIcon.addHorizontalStretch(this.changedInterval);
                        bl = true;
                    } else if (this.addingHorizontalStretch && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int n47 = (this.startX - n7) / NinePatchEditor.this.zoom;
                        int n48 = (n - n7) / NinePatchEditor.this.zoom;
                        this.changedInterval.setStart(Math.max(0, Math.min(n47, n48)));
                        this.changedInterval.setEnd(Math.min(bufferedImage.getWidth() - 1, Math.max(n47, n48)));
                        bl = true;
                    } else if (this.addingHorizontalStretch && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.addingHorizontalStretch = false;
                        NinePatchEditor.this.verifyHorizontalStretchAreas();
                        bl = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                }
                if (this.addingVerticalStretch || !NinePatchEditor.this.someDragged) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed) && n2 > n8 && n2 < n8 + n6 && n < n7) {
                        NinePatchEditor.this.someDragged = true;
                        this.addingVerticalStretch = true;
                        this.startY = n2;
                        this.changedInterval = new NinePatchInterval((n2 - n8) / NinePatchEditor.this.zoom, false);
                        NinePatchEditor.this.ninePatchIcon.addVerticalStretch(this.changedInterval);
                        bl = true;
                    } else if (this.addingVerticalStretch && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int n49 = (this.startY - n8) / NinePatchEditor.this.zoom;
                        int n50 = (n2 - n8) / NinePatchEditor.this.zoom;
                        this.changedInterval.setStart(Math.max(0, Math.min(n49, n50)));
                        this.changedInterval.setEnd(Math.min(bufferedImage.getHeight() - 1, Math.max(n49, n50)));
                        bl = true;
                    } else if (this.addingVerticalStretch && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.addingVerticalStretch = false;
                        NinePatchEditor.this.verifyVerticalStretchAreas();
                        bl = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                }
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (this.removingHorizontalStretch || !NinePatchEditor.this.someDragged) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed) && n > n7 && n < n7 + n5 && n2 < n8) {
                        NinePatchEditor.this.someDragged = true;
                        this.removingHorizontalStretch = true;
                        this.startX = n;
                        this.removedInterval = new NinePatchInterval((n - n7) / NinePatchEditor.this.zoom, false);
                        this.finishHorizontalRemoval();
                        bl = true;
                    } else if (this.removingHorizontalStretch && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int n51 = (this.startX - n7) / NinePatchEditor.this.zoom;
                        int n52 = (n - n7) / NinePatchEditor.this.zoom;
                        this.removedInterval.setStart(Math.max(0, Math.min(n51, n52)));
                        this.removedInterval.setEnd(Math.min(bufferedImage.getWidth() - 1, Math.max(n51, n52)));
                        this.finishHorizontalRemoval();
                        bl = true;
                    } else if (this.removingHorizontalStretch && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.removingHorizontalStretch = false;
                        bl = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                }
                if (this.removingVerticalStretch || !NinePatchEditor.this.someDragged) {
                    if (mouseEventType.equals((Object)MouseEventType.mousePressed) && n2 > n8 && n2 < n8 + n6 && n < n7) {
                        NinePatchEditor.this.someDragged = true;
                        this.removingVerticalStretch = true;
                        this.startY = n2;
                        this.removedInterval = new NinePatchInterval((n2 - n8) / NinePatchEditor.this.zoom, false);
                        this.finishVerticalRemoval();
                        bl = true;
                    } else if (this.removingVerticalStretch && mouseEventType.equals((Object)MouseEventType.mouseDragged)) {
                        int n53 = (this.startY - n8) / NinePatchEditor.this.zoom;
                        int n54 = (n2 - n8) / NinePatchEditor.this.zoom;
                        this.removedInterval.setStart(Math.max(0, Math.min(n53, n54)));
                        this.removedInterval.setEnd(Math.min(bufferedImage.getHeight() - 1, Math.max(n53, n54)));
                        this.finishVerticalRemoval();
                        bl = true;
                    } else if (this.removingVerticalStretch && mouseEventType.equals((Object)MouseEventType.mouseReleased)) {
                        NinePatchEditor.this.someDragged = false;
                        this.removingVerticalStretch = false;
                        bl = true;
                        NinePatchEditor.this.saveHistoryState();
                        NinePatchEditor.this.fireStateChanged();
                    }
                }
            }
            NinePatchEditor.this.setCursor(Cursor.getDefaultCursor());
            return bl;
        }

        private void finishHorizontalRemoval() {
            boolean[] blArray = NinePatchEditor.this.getHorizontalFilledPixels();
            for (int i = this.removedInterval.getStart(); i <= this.removedInterval.getEnd(); ++i) {
                blArray[i] = false;
            }
            NinePatchEditor.this.ninePatchIcon.setHorizontalStretch(NinePatchUtils.parseStretchIntervals(blArray));
            NinePatchEditor.this.validateIcon();
        }

        private void finishVerticalRemoval() {
            boolean[] blArray = NinePatchEditor.this.getVerticalFilledPixels();
            for (int i = this.removedInterval.getStart(); i <= this.removedInterval.getEnd(); ++i) {
                blArray[i] = false;
            }
            NinePatchEditor.this.ninePatchIcon.setVerticalStretch(NinePatchUtils.parseStretchIntervals(blArray));
            NinePatchEditor.this.validateIcon();
        }
    }
}

