/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.ComponentPanelLayout;
import com.alee.extended.painter.DefaultPainter;
import com.alee.extended.panel.ComponentReorderListener;
import com.alee.laf.StyleConstants;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class WebComponentPanel
extends WebPanel {
    public static final int GRIPPER_SIZE = 7;
    public static final int SINGLE_GRIPPER_STEP = 4;
    private List<ComponentReorderListener> listeners = new ArrayList<ComponentReorderListener>();
    private WebPanel container;
    private Map<Component, WebSelectablePanel> components = new LinkedHashMap<Component, WebSelectablePanel>();
    private Insets elementMargin = new Insets(2, 2, 2, 2);
    private boolean reorderingAllowed = false;
    private boolean showReorderGrippers = true;
    private boolean upDownHotkeysAllowed = true;
    private boolean leftRightHotkeysAllowed = false;

    public WebComponentPanel() {
        this.initialize();
    }

    public WebComponentPanel(boolean bl) {
        super(bl);
        this.initialize();
    }

    private void initialize() {
        this.setWebColored(false);
        this.container = new WebPanel();
        this.container.setLayout(new ComponentPanelLayout());
        this.add((Component)this.container, (Object)"Center");
        HotkeyRunnable hotkeyRunnable = new HotkeyRunnable(){

            @Override
            public void run(KeyEvent keyEvent) {
                if (WebComponentPanel.this.upDownHotkeysAllowed && Hotkey.UP.isTriggered(keyEvent) || WebComponentPanel.this.leftRightHotkeysAllowed && Hotkey.LEFT.isTriggered(keyEvent)) {
                    int n = WebComponentPanel.this.getFocusedElementIndex();
                    if (n == -1) {
                        WebComponentPanel.this.focusElement(WebComponentPanel.this.getElementCount() - 1);
                    } else {
                        WebComponentPanel.this.focusElement(n > 0 ? n - 1 : WebComponentPanel.this.getElementCount() - 1);
                    }
                }
            }
        };
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.UP, hotkeyRunnable);
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.LEFT, hotkeyRunnable);
        HotkeyRunnable hotkeyRunnable2 = new HotkeyRunnable(){

            @Override
            public void run(KeyEvent keyEvent) {
                if (WebComponentPanel.this.upDownHotkeysAllowed && Hotkey.DOWN.isTriggered(keyEvent) || WebComponentPanel.this.leftRightHotkeysAllowed && Hotkey.RIGHT.isTriggered(keyEvent)) {
                    int n = WebComponentPanel.this.getFocusedElementIndex();
                    if (n == -1) {
                        WebComponentPanel.this.focusElement(0);
                    } else {
                        WebComponentPanel.this.focusElement(n < WebComponentPanel.this.getElementCount() - 1 ? n + 1 : 0);
                    }
                }
            }
        };
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.DOWN, hotkeyRunnable2);
        HotkeyManager.registerHotkey((Component)this, this, Hotkey.RIGHT, hotkeyRunnable2);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        this.updateAllBorders();
    }

    public ComponentPanelLayout getContainerLayout() {
        return (ComponentPanelLayout)this.container.getLayout();
    }

    public boolean isUpDownHotkeysAllowed() {
        return this.upDownHotkeysAllowed;
    }

    public void setUpDownHotkeysAllowed(boolean bl) {
        this.upDownHotkeysAllowed = bl;
    }

    public boolean isLeftRightHotkeysAllowed() {
        return this.leftRightHotkeysAllowed;
    }

    public void setLeftRightHotkeysAllowed(boolean bl) {
        this.leftRightHotkeysAllowed = bl;
    }

    public WebSelectablePanel addElement(Component component) {
        if (this.components.containsKey(component)) {
            return this.components.get(component);
        }
        WebSelectablePanel webSelectablePanel = new WebSelectablePanel();
        webSelectablePanel.add(component, (Object)"Center");
        this.container.add((Component)webSelectablePanel, (Object)"");
        this.components.put(component, webSelectablePanel);
        this.updateAllBorders();
        return webSelectablePanel;
    }

    public void removeElement(int n) {
        this.removeElement(this.getElement(n));
    }

    public void removeElement(WebSelectablePanel webSelectablePanel) {
        for (Component component : this.components.keySet()) {
            if (this.components.get(component) != webSelectablePanel) continue;
            this.removeElement(component);
            break;
        }
    }

    public void removeElement(Component component) {
        WebSelectablePanel webSelectablePanel = this.components.get(component);
        this.container.remove(webSelectablePanel);
        this.components.remove(component);
        this.updateAllBorders();
    }

    public int getElementCount() {
        return this.components.size();
    }

    public WebSelectablePanel getElement(int n) {
        return (WebSelectablePanel)this.getContainerLayout().getComponent(n);
    }

    public WebSelectablePanel getFocusedElement() {
        for (Component component : this.getContainerLayout().getComponents()) {
            WebSelectablePanel webSelectablePanel = (WebSelectablePanel)component;
            if (!webSelectablePanel.isFocused()) continue;
            return webSelectablePanel;
        }
        return null;
    }

    public int getFocusedElementIndex() {
        return this.getContainerLayout().indexOf(this.getFocusedElement());
    }

    public void focusElement(int n) {
        this.getElement(n).transferFocus();
    }

    public Insets getElementMargin() {
        return this.elementMargin;
    }

    public void setElementMargin(int n) {
        this.setElementMargin(n, n, n, n);
    }

    public void setElementMargin(int n, int n2, int n3, int n4) {
        this.setElementMargin(new Insets(n, n2, n3, n4));
    }

    public void setElementMargin(Insets insets) {
        this.elementMargin = insets;
        this.updateAllBorders();
    }

    public boolean isReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setReorderingAllowed(boolean bl) {
        this.reorderingAllowed = bl;
        this.updateAllBorders();
    }

    public boolean isShowReorderGrippers() {
        return this.showReorderGrippers;
    }

    public void setShowReorderGrippers(boolean bl) {
        this.showReorderGrippers = bl;
        this.updateAllBorders();
    }

    private void updateAllBorders() {
        for (WebSelectablePanel webSelectablePanel : this.components.values()) {
            webSelectablePanel.updateBorder();
        }
    }

    public void addComponentReorderListener(ComponentReorderListener componentReorderListener) {
        this.listeners.add(componentReorderListener);
    }

    public void removeComponentReorderListener(ComponentReorderListener componentReorderListener) {
        this.listeners.remove(componentReorderListener);
    }

    private void fireComponentOrderChanged(Component component, int n, int n2) {
        for (ComponentReorderListener componentReorderListener : CollectionUtils.copy(this.listeners)) {
            componentReorderListener.componentOrderChanged(component, n, n2);
        }
    }

    public class WebSelectablePanelPainter
    extends DefaultPainter<WebSelectablePanel> {
        private float[] fractions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
        private Color[] lightColors = new Color[]{StyleConstants.transparent, Color.WHITE, Color.WHITE, StyleConstants.transparent};
        private Color[] darkColors = new Color[]{StyleConstants.transparent, Color.GRAY, Color.GRAY, StyleConstants.transparent};

        @Override
        public boolean isOpaque(WebSelectablePanel webSelectablePanel) {
            return true;
        }

        @Override
        public void paint(Graphics2D graphics2D, Rectangle rectangle, WebSelectablePanel webSelectablePanel) {
            int n;
            boolean bl;
            boolean bl2 = webSelectablePanel.getIndex() > 0;
            boolean bl3 = bl = webSelectablePanel.getIndex() < WebComponentPanel.this.components.size() - 1;
            if (webSelectablePanel.isFocused()) {
                graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, StyleConstants.topBgColor, rectangle.x, rectangle.y + rectangle.height, StyleConstants.bottomBgColor));
                graphics2D.fill(rectangle);
                Integer n2 = WebComponentPanel.this.getContainerLayout().getComponentShift(webSelectablePanel);
                n = webSelectablePanel.isDragged() && n2 != null && n2 != 0 ? 1 : 0;
                graphics2D.setPaint(StyleConstants.darkBorderColor);
                if (bl2 || n != 0) {
                    graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                }
                if (bl || n != 0) {
                    graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                }
            }
            if (WebComponentPanel.this.reorderingAllowed && WebComponentPanel.this.showReorderGrippers) {
                boolean bl4 = webSelectablePanel.getComponentOrientation().isLeftToRight();
                n = rectangle.y + 2 + (bl2 ? 1 : 0);
                int n3 = rectangle.x + rectangle.height - 2 - (bl ? 1 : 0);
                int n4 = bl4 ? rectangle.x + 3 : rectangle.x + rectangle.width - 7 + 2;
                int n5 = n + (n3 - n) % 4 / 2;
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(n4, n, n4, n3, this.fractions, this.lightColors);
                LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(n4, n, n4, n3, this.fractions, this.darkColors);
                while (n5 + 3 < n3) {
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fillRect(n4 + 1, n5 + 1, 2, 2);
                    graphics2D.setPaint(linearGradientPaint2);
                    graphics2D.fillRect(n4, n5, 2, 2);
                    n5 += 4;
                }
            }
        }
    }

    public class WebSelectablePanel
    extends WebPanel {
        private boolean dragged = false;
        private boolean focused = false;

        public WebSelectablePanel() {
            this.updateBorder();
            this.setPainter(new WebSelectablePanelPainter());
            MouseAdapter mouseAdapter = new MouseAdapter(){
                private int startY;

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (!SwingUtils.hasFocusOwner(WebSelectablePanel.this)) {
                        WebSelectablePanel.this.transferFocus();
                    }
                    if (WebComponentPanel.this.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        WebSelectablePanel.this.dragged = true;
                        this.startY = this.getY();
                        WebComponentPanel.this.container.setComponentZOrder(WebSelectablePanel.this, 0);
                    }
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (WebSelectablePanel.this.dragged) {
                        WebComponentPanel.this.getContainerLayout().setComponentShift(WebSelectablePanel.this, this.getY() - this.startY);
                        WebSelectablePanel.this.revalidate();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    WebSelectablePanel webSelectablePanel = WebSelectablePanel.this;
                    ComponentPanelLayout componentPanelLayout = WebComponentPanel.this.getContainerLayout();
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && WebSelectablePanel.this.dragged) {
                        WebSelectablePanel.this.dragged = false;
                        if (this.getY() - this.startY == 0 || componentPanelLayout.getComponents().size() <= 1) {
                            componentPanelLayout.setComponentShift(webSelectablePanel, null);
                        } else {
                            int n = componentPanelLayout.indexOf(webSelectablePanel);
                            int n2 = this.getMiddleY(webSelectablePanel);
                            int n3 = 0;
                            for (Component component : componentPanelLayout.getComponents()) {
                                if (component == webSelectablePanel || n2 <= this.getMiddleY(component)) continue;
                                n3 = componentPanelLayout.indexOf(component) + 1;
                            }
                            if (n3 > n) {
                                --n3;
                            }
                            componentPanelLayout.setComponentShift(webSelectablePanel, null);
                            if (n != n3) {
                                componentPanelLayout.removeLayoutComponent(webSelectablePanel);
                                componentPanelLayout.insertLayoutComponent(n3, webSelectablePanel);
                                WebComponentPanel.this.updateAllBorders();
                                WebComponentPanel.this.fireComponentOrderChanged(webSelectablePanel.getComponent(), n, n3);
                            }
                        }
                        webSelectablePanel.revalidate();
                    }
                }

                private int getMiddleY(Component component) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.y + rectangle.height / 2;
                }

                private int getY() {
                    return MouseInfo.getPointerInfo().getLocation().y;
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            FocusManager.registerFocusTracker(new DefaultFocusTracker(this, true, true){

                @Override
                public void focusChanged(boolean bl) {
                    WebSelectablePanel webSelectablePanel = WebSelectablePanel.this;
                    webSelectablePanel.focused = bl;
                    if (!bl && WebSelectablePanel.this.dragged) {
                        WebSelectablePanel.this.dragged = false;
                        WebComponentPanel.this.getContainerLayout().setComponentShift(webSelectablePanel, null);
                        webSelectablePanel.revalidate();
                    }
                    WebSelectablePanel.this.repaint();
                }
            });
        }

        public void updateBorder() {
            int n = this.getIndex();
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n2 = n == 0 ? ((WebComponentPanel)WebComponentPanel.this).elementMargin.top : ((WebComponentPanel)WebComponentPanel.this).elementMargin.top + 1;
            int n3 = ((WebComponentPanel)WebComponentPanel.this).elementMargin.left + (WebComponentPanel.this.reorderingAllowed && WebComponentPanel.this.showReorderGrippers && bl ? 7 : 0);
            int n4 = n == WebComponentPanel.this.components.size() - 1 ? ((WebComponentPanel)WebComponentPanel.this).elementMargin.bottom : ((WebComponentPanel)WebComponentPanel.this).elementMargin.bottom + 1;
            int n5 = ((WebComponentPanel)WebComponentPanel.this).elementMargin.right + (WebComponentPanel.this.reorderingAllowed && WebComponentPanel.this.showReorderGrippers && !bl ? 7 : 0);
            this.setMargin(n2, n3, n4, n5);
        }

        public boolean isFocused() {
            return this.focused;
        }

        public boolean isDragged() {
            return this.dragged;
        }

        public Component getComponent() {
            return this.getComponent(0);
        }

        public int getIndex() {
            return WebComponentPanel.this.getContainerLayout().indexOf(this);
        }
    }
}

