/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf;

import com.alee.extended.image.WebImage;
import com.alee.extended.label.WebLinkLabel;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.window.ComponentMoveAdapter;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebFrame;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.tabbedpane.TabStretchType;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.laf.table.WebTable;
import com.alee.laf.text.WebTextArea;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.language.LM;
import com.alee.managers.language.LanguageAdapter;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.popup.WebPopup;
import com.alee.managers.version.VersionInfo;
import com.alee.managers.version.VersionManager;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.reflection.JarEntry;
import com.alee.utils.reflection.JarStructure;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;

public class LibraryInfoDialog
extends WebFrame {
    private static final String LIBRARY_DATA_SEPARATOR = " - ";
    private static LibraryInfoDialog instance;

    public static LibraryInfoDialog getInstance() {
        if (instance == null) {
            instance = new LibraryInfoDialog();
        }
        return instance;
    }

    private LibraryInfoDialog() {
        this.setIconImages(WebLookAndFeel.getImages());
        this.setLanguage("weblaf.info.title", new Object[0]);
        ComponentMoveAdapter.install(this);
        final WebTabbedPane webTabbedPane = new WebTabbedPane();
        webTabbedPane.setTabbedPaneStyle(TabbedPaneStyle.attached);
        webTabbedPane.setTabStretchType(TabStretchType.always);
        webTabbedPane.addTab(LM.get("weblaf.info.general.title"), this.createTabSeparator(this.createGeneralTab()));
        webTabbedPane.addTab(LM.get("weblaf.info.libraries.title"), this.createTabSeparator(this.createLibrariesTab()));
        webTabbedPane.addTab(LM.get("weblaf.info.properties.title"), this.createTabSeparator(this.createPropertiesTab()));
        LanguageManager.addLanguageListener(new LanguageAdapter(){

            @Override
            public void languageUpdated() {
                webTabbedPane.setTitleAt(0, LM.get("weblaf.info.general.title"));
                webTabbedPane.setTitleAt(1, LM.get("weblaf.info.libraries.title"));
                webTabbedPane.setTitleAt(2, LM.get("weblaf.info.properties.title"));
            }
        });
        this.add(webTabbedPane);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    private Component createTabSeparator(Component component) {
        WebPanel webPanel = new WebPanel();
        webPanel.add((Component)new TabAreaSeparator(), (Object)"North");
        webPanel.add(component, (Object)"Center");
        return webPanel;
    }

    private Component createGeneralTab() {
        WebPanel webPanel = new WebPanel(new VerticalFlowLayout(30, 30));
        webPanel.setMargin(60, 70, 60, 70);
        webPanel.setUndecorated(false);
        webPanel.setWebColored(true);
        webPanel.setDrawSides(false, false, false, false);
        webPanel.add((Component)this.createLibraryVersionPanel());
        webPanel.add((Component)new WebSeparator(false, 0));
        webPanel.add((Component)this.createJavaVersionPanel());
        webPanel.add((Component)new WebSeparator(false, 0));
        webPanel.add((Component)this.createOsVersionPanel());
        return webPanel;
    }

    private WebPanel createLibraryVersionPanel() {
        VersionInfo versionInfo = VersionManager.getLibraryVersion();
        WebImage webImage = new WebImage(WebLookAndFeel.getIcon(32));
        WebLinkLabel webLinkLabel = new WebLinkLabel(versionInfo.toString());
        webLinkLabel.setLink("http://weblookandfeel.com", false);
        SwingUtils.setBoldFont(webLinkLabel);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy", Locale.getDefault());
        WebLabel webLabel = new WebLabel();
        webLabel.setLanguage("weblaf.info.general.updated", simpleDateFormat.format(new Date(versionInfo.getDate())));
        return new GroupPanel(15, webImage, new GroupPanel(false, webLinkLabel, webLabel));
    }

    private WebPanel createJavaVersionPanel() {
        WebImage webImage = new WebImage(new ImageIcon(LibraryInfoDialog.class.getResource("icons/java.png")));
        WebLinkLabel webLinkLabel = new WebLinkLabel();
        webLinkLabel.setLanguage("weblaf.info.general.java.version", SystemUtils.getJavaVersionString());
        webLinkLabel.setLink("http://www.oracle.com/technetwork/java/javase/overview/", false);
        SwingUtils.setBoldFont(webLinkLabel);
        WebLabel webLabel = new WebLabel(SystemUtils.getJavaName());
        return new GroupPanel(15, webImage, new GroupPanel(false, webLinkLabel, webLabel));
    }

    private WebPanel createOsVersionPanel() {
        WebImage webImage = new WebImage(SystemUtils.getOsIcon(32, false));
        WebLinkLabel webLinkLabel = new WebLinkLabel(SystemUtils.getOsName());
        webLinkLabel.setLink(SystemUtils.getOsSite(), false);
        SwingUtils.setBoldFont(webLinkLabel);
        WebLabel webLabel = new WebLabel();
        webLabel.setLanguage("weblaf.info.general.os.arch", SystemUtils.getOsArch());
        return new GroupPanel(15, webImage, new GroupPanel(false, webLinkLabel, webLabel));
    }

    private Component createLibrariesTab() {
        try {
            final JarStructure jarStructure = ReflectUtils.getJarStructure(this.getClass());
            JarEntry jarEntry = jarStructure.getRoot().getChildByName("licenses");
            JarEntry jarEntry2 = jarEntry.getChildByName("libraries.data");
            String string = FileUtils.readToString(jarStructure.getEntryInputStream(jarEntry2));
            Map<String, String> map = this.parseUrls(string);
            WebPanel webPanel = new WebPanel(new VerticalFlowLayout(0, 5));
            webPanel.setMargin(5);
            for (final JarEntry jarEntry3 : jarEntry.getChilds()) {
                if (!jarEntry3.getName().endsWith(".txt")) continue;
                String string2 = map.get(jarEntry3.getName());
                int n = string2.indexOf(LIBRARY_DATA_SEPARATOR);
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + LIBRARY_DATA_SEPARATOR.length());
                WebLabel webLabel = new WebLabel(string3);
                SwingUtils.setBoldFont(webLabel);
                final WebLinkLabel webLinkLabel = new WebLinkLabel(jarEntry3.getName());
                webLinkLabel.setLink(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String string = FileUtils.readToString(jarStructure.getEntryInputStream(jarEntry3));
                            final WebPopup webPopup = new WebPopup();
                            WebTextArea webTextArea = new WebTextArea(string);
                            webTextArea.setEditable(false);
                            webPopup.add((Component)new WebScrollPane(webTextArea, false));
                            webPopup.showPopupAsModal(webLinkLabel, true, true);
                            HotkeyManager.registerHotkey((Component)webTextArea, Hotkey.ESCAPE, new HotkeyRunnable(){

                                @Override
                                public void run(KeyEvent keyEvent) {
                                    webPopup.hidePopup();
                                }
                            });
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                });
                WebLabel webLabel2 = new WebLabel();
                webLabel2.setLanguage("weblaf.info.libraries.license", new Object[0]);
                GroupPanel groupPanel = new GroupPanel(5, webLabel2, webLinkLabel);
                WebLinkLabel webLinkLabel2 = new WebLinkLabel(string4);
                webLinkLabel2.setLink(string4, false);
                WebLabel webLabel3 = new WebLabel();
                webLabel3.setLanguage("weblaf.info.libraries.site", new Object[0]);
                GroupPanel groupPanel2 = new GroupPanel(5, webLabel3, webLinkLabel2);
                GroupPanel groupPanel3 = new GroupPanel(false, webLabel, groupPanel, groupPanel2);
                groupPanel3.setUndecorated(false);
                groupPanel3.setMargin(5);
                groupPanel3.setPreferredWidth(0);
                webPanel.add((Component)groupPanel3);
            }
            WebScrollPane webScrollPane = new WebScrollPane(webPanel, false);
            webScrollPane.setPreferredHeight(0);
            return webScrollPane;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this.createErrorLibrariesTab();
        }
    }

    private Map<String, String> parseUrls(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(LIBRARY_DATA_SEPARATOR);
            hashMap.put(string2.substring(0, n), string2.substring(n + LIBRARY_DATA_SEPARATOR.length()));
        }
        return hashMap;
    }

    private Component createErrorLibrariesTab() {
        WebLabel webLabel = new WebLabel(0);
        webLabel.setLanguage("weblaf.info.libraries.error", new Object[0]);
        return webLabel;
    }

    private Component createPropertiesTab() {
        Object[][] objectArray = this.createSystemPropertiesData();
        final DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, this.getPropertiesTableColumnNames());
        final WebTable webTable = new WebTable(defaultTableModel);
        webTable.setPreferredScrollableViewportSize(new Dimension(1, 1));
        webTable.setEditable(false);
        LanguageManager.addLanguageListener(new LanguageAdapter(){

            @Override
            public void languageUpdated() {
                int[] nArray = webTable.getSelectedRows();
                defaultTableModel.setColumnIdentifiers(LibraryInfoDialog.this.getPropertiesTableColumnNames());
                for (int n : nArray) {
                    webTable.addRowSelectionInterval(n, n);
                }
            }
        });
        return new WebScrollPane(webTable, false);
    }

    private String[] getPropertiesTableColumnNames() {
        return new String[]{LM.get("weblaf.info.properties.key"), LM.get("weblaf.info.properties.value")};
    }

    private Object[][] createSystemPropertiesData() {
        Properties properties = System.getProperties();
        Object[][] objectArray = new Object[properties.size()][2];
        int n = 0;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            objectArray[n][0] = entry.getKey();
            objectArray[n][1] = entry.getValue();
            ++n;
        }
        Arrays.sort(objectArray, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] objectArray, Object[] objectArray2) {
                return ((String)objectArray[0]).compareTo((String)objectArray2[0]);
            }
        });
        return objectArray;
    }

    public static void main(String[] stringArray) {
        WebLookAndFeel.install();
        HotkeyManager.registerHotkey(Hotkey.ALT_R, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent keyEvent) {
                WebLookAndFeel.changeOrientation();
            }
        });
        HotkeyManager.registerHotkey(Hotkey.ALT_L, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent keyEvent) {
                String string = LanguageManager.getLanguage();
                List<String> list = LanguageManager.getSupportedLanguages();
                int n = list.indexOf(string);
                if (n != -1) {
                    LanguageManager.setLanguage(n < list.size() - 1 ? list.get(n + 1) : list.get(0));
                }
            }
        });
        LibraryInfoDialog.getInstance().setVisible(true);
    }

    private class TabAreaSeparator
    extends JComponent {
        private TabAreaSeparator() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(StyleConstants.backgroundColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
            graphics.setColor(StyleConstants.darkBorderColor);
            graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 4);
        }
    }
}

