/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.laf.colorchooser.HSBColor;
import com.alee.utils.ColorUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;

public class LineColorChooserPaint
implements Paint {
    private boolean webSafe = false;
    private ColorModel model = ColorModel.getRGBdefault();
    private int y;
    private int height;

    public LineColorChooserPaint(int n, int n2) {
        this.y = n;
        this.height = n2;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, final AffineTransform affineTransform, RenderingHints renderingHints) {
        return new PaintContext(){
            private Map<Rectangle, WritableRaster> rastersCache = new HashMap<Rectangle, WritableRaster>();

            @Override
            public void dispose() {
                this.rastersCache.clear();
            }

            @Override
            public ColorModel getColorModel() {
                return LineColorChooserPaint.this.model;
            }

            @Override
            public Raster getRaster(int n, int n2, int n3, int n4) {
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                if (this.rastersCache.containsKey(rectangle)) {
                    return this.rastersCache.get(rectangle);
                }
                WritableRaster writableRaster = LineColorChooserPaint.this.model.createCompatibleWritableRaster(n3, n4);
                n2 = (int)((long)n2 - Math.round(affineTransform.getTranslateY()));
                int[] nArray = new int[n3 * n4 * 4];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        Color color = new HSBColor(1.0f - (float)(n2 + i) / (float)(LineColorChooserPaint.this.y * 2 + LineColorChooserPaint.this.height), 1.0f, 1.0f).getColor();
                        int n5 = (i * n3 + j) * 4;
                        nArray[n5] = LineColorChooserPaint.this.getWebSafe(color.getRed());
                        nArray[n5 + 1] = LineColorChooserPaint.this.getWebSafe(color.getGreen());
                        nArray[n5 + 2] = LineColorChooserPaint.this.getWebSafe(color.getBlue());
                        nArray[n5 + 3] = 255;
                    }
                }
                writableRaster.setPixels(0, 0, n3, n4, nArray);
                this.rastersCache.put(rectangle, writableRaster);
                return writableRaster;
            }
        };
    }

    public Color getColor(int n) {
        return new HSBColor(1.0f - Math.max(0.0f, Math.min((float)(n - this.y) / (float)this.height, 1.0f)), 1.0f, 1.0f).getColor();
    }

    private int getWebSafe(int n) {
        if (this.webSafe) {
            n = ColorUtils.getWebSafeValue(n);
        }
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    @Override
    public int getTransparency() {
        return 1;
    }

    public boolean isWebSafe() {
        return this.webSafe;
    }

    public void setWebSafe(boolean bl) {
        this.webSafe = bl;
    }
}

