/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list.editor;

import com.alee.laf.list.WebList;
import com.alee.laf.list.editor.ListCellEditor;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.CompareUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public abstract class AbstractListCellEditor<E extends Component, T>
implements ListCellEditor<E, T> {
    protected int editedCell = -1;
    protected T oldValue;
    protected E editor;
    protected ComponentAdapter editorPositionUpdater;
    protected MouseAdapter mouseAdapter = null;
    protected KeyAdapter keyAdapter = null;

    @Override
    public void install(final JList jList) {
        this.editorPositionUpdater = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.checkEditorBounds();
            }

            private void checkEditorBounds() {
                Rectangle rectangle;
                if (AbstractListCellEditor.this.isEditing() && (rectangle = AbstractListCellEditor.this.getEditorBounds(jList, AbstractListCellEditor.this.editedCell, AbstractListCellEditor.this.oldValue)) != null && !rectangle.equals(((Component)AbstractListCellEditor.this.editor).getBounds())) {
                    ((Component)AbstractListCellEditor.this.editor).setBounds(rectangle);
                    jList.revalidate();
                    jList.repaint();
                }
            }
        };
        jList.addComponentListener(this.editorPositionUpdater);
        this.installStartEditActions(jList);
    }

    protected void installStartEditActions(final JList jList) {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Point point = mouseEvent.getPoint();
                    int n = jList.getUI().locationToIndex(jList, point);
                    Rectangle rectangle = jList.getCellBounds(n, n);
                    if (rectangle.contains(point)) {
                        AbstractListCellEditor.this.startEdit(jList, n);
                    }
                }
            }
        };
        jList.addMouseListener(this.mouseAdapter);
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Hotkey.F2.isTriggered(keyEvent)) {
                    AbstractListCellEditor.this.startEdit(jList, jList.getSelectedIndex());
                }
            }
        };
        jList.addKeyListener(this.keyAdapter);
    }

    @Override
    public void uninstall(JList jList) {
        jList.removeComponentListener(this.editorPositionUpdater);
        this.uninstallStartEditActions(jList);
    }

    protected void uninstallStartEditActions(JList jList) {
        if (this.mouseAdapter != null) {
            jList.removeMouseListener(this.mouseAdapter);
        }
        if (this.keyAdapter != null) {
            jList.removeKeyListener(this.keyAdapter);
        }
    }

    @Override
    public boolean isCellEditable(JList jList, int n, T t) {
        if (jList instanceof WebList) {
            return ((WebList)jList).isEditable() && jList.isEnabled();
        }
        return jList.isEnabled();
    }

    @Override
    public E getCellEditor(JList jList, int n, T t) {
        this.editor = this.createCellEditor(jList, n, t);
        this.createCellEditorListeners(jList, n, t);
        return this.editor;
    }

    protected abstract E createCellEditor(JList var1, int var2, T var3);

    protected void createCellEditorListeners(final JList jList, int n, T t) {
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AbstractListCellEditor.this.stopEdit(jList);
            }
        };
        ((Component)this.editor).addFocusListener(focusAdapter);
        ((Component)this.editor).addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Hotkey.ENTER.isTriggered(keyEvent)) {
                    ((Component)AbstractListCellEditor.this.editor).removeFocusListener(focusAdapter);
                    AbstractListCellEditor.this.stopEdit(jList);
                    jList.requestFocusInWindow();
                } else if (Hotkey.ESCAPE.isTriggered(keyEvent)) {
                    ((Component)AbstractListCellEditor.this.editor).removeFocusListener(focusAdapter);
                    AbstractListCellEditor.this.cancelEdit(jList);
                    jList.requestFocusInWindow();
                }
            }
        });
    }

    @Override
    public void startEdit(JList jList, int n) {
        if (n == -1) {
            return;
        }
        this.oldValue = jList.getModel().getElementAt(n);
        if (!this.isCellEditable(jList, n, this.oldValue)) {
            this.oldValue = null;
            return;
        }
        this.editor = this.getCellEditor(jList, n, this.oldValue);
        ((Component)this.editor).setBounds(this.getEditorBounds(jList, n, this.oldValue));
        this.addEditor(jList);
        if (((Component)this.editor).isFocusable()) {
            ((Component)this.editor).requestFocusInWindow();
        }
        this.editStarted(jList, n);
    }

    @Override
    public void cancelEdit(JList jList) {
        this.removeEditor(jList);
        this.editCancelled(jList, this.editedCell);
    }

    @Override
    public void stopEdit(JList jList) {
        int[] nArray = jList.getSelectedIndices();
        T t = this.getCellEditorValue(jList, this.editedCell, this.oldValue);
        boolean bl = this.updateListModel(jList, this.editedCell, this.oldValue, t, true);
        this.removeEditor(jList);
        if (bl) {
            jList.setSelectedIndices(nArray);
            this.editStopped(jList, this.editedCell, this.oldValue, t);
        } else {
            this.editCancelled(jList, this.editedCell);
        }
    }

    protected void addEditor(JList jList) {
        jList.add((Component)this.editor);
        jList.revalidate();
        jList.repaint();
    }

    protected void removeEditor(JList jList) {
        jList.remove((Component)this.editor);
        jList.revalidate();
        jList.repaint();
    }

    protected Rectangle getEditorBounds(JList jList, int n, T t, Rectangle rectangle) {
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    protected Rectangle getEditorBounds(JList jList, int n, T t) {
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (rectangle != null) {
            Rectangle rectangle2 = this.getEditorBounds(jList, n, t, rectangle);
            return new Rectangle(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y, rectangle2.width, rectangle2.height);
        }
        return null;
    }

    @Override
    public boolean updateListModel(JList jList, int n, T t, T t2, boolean bl) {
        if (CompareUtils.equals(t, t2)) {
            return false;
        }
        ListModel listModel = jList.getModel();
        if (listModel instanceof DefaultListModel) {
            DefaultListModel defaultListModel = (DefaultListModel)listModel;
            defaultListModel.setElementAt(t2, n);
            return true;
        }
        if (listModel instanceof AbstractListModel) {
            final Object[] objectArray = new Object[listModel.getSize()];
            for (int i = 0; i < listModel.getSize(); ++i) {
                objectArray[i] = this.editedCell != i ? listModel.getElementAt(i) : t2;
            }
            jList.setModel(new AbstractListModel(){

                @Override
                public int getSize() {
                    return objectArray.length;
                }

                @Override
                public Object getElementAt(int n) {
                    return objectArray[n];
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void editStarted(JList jList, int n) {
        this.editedCell = n;
        if (jList instanceof WebList) {
            ((WebList)jList).fireEditStarted(n);
        }
    }

    @Override
    public void editStopped(JList jList, int n, T t, T t2) {
        this.editedCell = -1;
        if (jList instanceof WebList) {
            ((WebList)jList).fireEditFinished(n, t, t2);
        }
    }

    @Override
    public void editCancelled(JList jList, int n) {
        this.editedCell = -1;
        if (jList instanceof WebList) {
            ((WebList)jList).fireEditCancelled(n);
        }
    }

    public boolean isEditing() {
        return this.editedCell != -1;
    }
}

