/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.laf.StyleConstants;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class WebPopupMenuUI
extends BasicPopupMenuUI
implements ShapeProvider {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WebPopupMenuUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.popupMenu);
        this.popupMenu.setOpaque(false);
        this.popupMenu.setBackground(Color.WHITE);
        this.popupMenu.setBorder(this.popupMenu instanceof BasicComboPopup ? BorderFactory.createEmptyBorder(1, 1, 1, 1) : BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.popupMenu, 0, StyleConstants.smallRound);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        Graphics2D graphics2D = (Graphics2D)graphics;
        LafUtils.drawWebStyle(graphics2D, jComponent, StyleConstants.shadeColor, 0, StyleConstants.smallRound, true, false, StyleConstants.averageBorderColor);
    }
}

