/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.laf.button.WebButton;
import com.alee.laf.splitpane.WebSplitPaneStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class WebSplitPaneUI
extends BasicSplitPaneUI {
    private Color dragDividerColor = WebSplitPaneStyle.dragDividerColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebSplitPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.splitPane);
        this.splitPane.setOpaque(false);
        this.splitPane.setBorder(null);
        this.splitPane.setDividerSize(6);
    }

    public Color getDragDividerColor() {
        return this.dragDividerColor;
    }

    public void setDragDividerColor(Color color) {
        this.dragDividerColor = color;
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new BasicSplitPaneDivider(this){
            private Border border;
            private Color color;
            private Color transparent;
            private Color[] gradient;
            {
                this.border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
                this.color = new Color(158, 158, 158);
                this.transparent = new Color(0, 0, 0, 0);
                this.gradient = new Color[]{this.transparent, this.color, this.color, this.transparent};
            }

            @Override
            public Border getBorder() {
                return this.border;
            }

            @Override
            protected JButton createLeftOneTouchButton() {
                WebButton webButton = WebButton.createIconWebButton(new ImageIcon(WebSplitPaneUI.class.getResource(this.orientation == 1 ? "icons/left.png" : "icons/up.png")), 0, 0, 0, false, true, false);
                webButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                webButton.setCursor(Cursor.getDefaultCursor());
                webButton.setPreferredSize(this.orientation == 1 ? new Dimension(6, 7) : new Dimension(7, 6));
                return webButton;
            }

            @Override
            protected JButton createRightOneTouchButton() {
                WebButton webButton = WebButton.createIconWebButton(new ImageIcon(WebSplitPaneUI.class.getResource(this.orientation == 1 ? "icons/right.png" : "icons/down.png")), 0, 0, 0, false, true, false);
                webButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                webButton.setCursor(Cursor.getDefaultCursor());
                webButton.setPreferredSize(this.orientation == 1 ? new Dimension(6, 7) : new Dimension(7, 6));
                return webButton;
            }

            @Override
            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Object object = LafUtils.setupAntialias(graphics2D);
                if (this.orientation == 1) {
                    int n = this.getHeight() / 2 - 35;
                    int n2 = this.getHeight() / 2 + 35;
                    graphics2D.setPaint(new LinearGradientPaint(0.0f, n, 0.0f, n2, new float[]{0.0f, 0.25f, 0.75f, 1.0f}, this.gradient));
                    for (int i = n; i < n2; i += 5) {
                        graphics2D.fillRect(this.getWidth() / 2 - 1, i - 1, 2, 2);
                    }
                } else {
                    int n = this.getWidth() / 2 - 35;
                    int n3 = this.getWidth() / 2 + 35;
                    graphics2D.setPaint(new LinearGradientPaint(n, 0.0f, n3, 0.0f, new float[]{0.0f, 0.25f, 0.75f, 1.0f}, this.gradient));
                    for (int i = n; i < n3; i += 5) {
                        graphics2D.fillRect(i - 1, this.getHeight() / 2 - 1, 2, 2);
                    }
                }
                super.paint(graphics);
                LafUtils.restoreAntialias(graphics2D, object);
            }
        };
    }

    @Override
    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            @Override
            public void paint(Graphics graphics) {
                if (!WebSplitPaneUI.this.isContinuousLayout() && WebSplitPaneUI.this.getLastDragLocation() != -1) {
                    Dimension dimension = WebSplitPaneUI.this.splitPane.getSize();
                    graphics.setColor(WebSplitPaneUI.this.dragDividerColor);
                    if (WebSplitPaneUI.this.getOrientation() == 1) {
                        graphics.fillRect(0, 0, WebSplitPaneUI.this.dividerSize - 1, dimension.height - 1);
                    } else {
                        graphics.fillRect(0, 0, dimension.width - 1, WebSplitPaneUI.this.dividerSize - 1);
                    }
                }
            }
        };
    }

    @Override
    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (jSplitPane == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            Dimension dimension = this.splitPane.getSize();
            graphics.setColor(this.dragDividerColor);
            if (this.getOrientation() == 1) {
                graphics.fillRect(this.getLastDragLocation(), 0, this.dividerSize - 1, dimension.height - 1);
            } else {
                graphics.fillRect(0, this.getLastDragLocation(), dimension.width - 1, this.dividerSize - 1);
            }
        }
    }
}

