/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.StyleConstants;
import com.alee.laf.table.WebTableStyle;
import com.alee.laf.table.renderers.WebTableHeaderCellRenderer;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WebTableHeaderUI
extends BasicTableHeaderUI {
    public static final Color topLineColor = new Color(232, 234, 235);
    public static final Color topBgColor = new Color(226, 226, 226);
    public static final Color bottomBgColor = new Color(201, 201, 201);
    public static final Color bottomLineColor = new Color(104, 104, 104);

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebTableHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.header);
        this.header.setOpaque(true);
        this.header.setDefaultRenderer(new WebTableHeaderCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }
        });
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = WebTableHeaderUI.createBackgroundPaint(0, 1, 0, this.header.getHeight() - 1);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 1, this.header.getWidth(), this.header.getHeight() - 1);
        graphics2D.setColor(topLineColor);
        graphics2D.drawLine(0, 0, this.header.getWidth(), 0);
        graphics2D.setPaint(bottomLineColor);
        graphics2D.drawLine(0, this.header.getHeight() - 1, this.header.getWidth(), this.header.getHeight() - 1);
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(bl ? n2 : n3);
        if (bl) {
            for (n = n2; n <= n3; ++n) {
                int n4;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                rectangle2.width = n4 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n, tableColumn2, tableColumn, tableColumnModel);
                }
                rectangle2.x += n4;
            }
        } else {
            for (n = n3; n >= n2; --n) {
                int n5;
                TableColumn tableColumn3 = tableColumnModel.getColumn(n);
                rectangle2.width = n5 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n, tableColumn3, tableColumn, tableColumnModel);
                }
                rectangle2.x += n5;
            }
        }
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            rectangle3.x += this.header.getDraggedDistance();
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(rectangle3.x - 1, rectangle3.y, rectangle3.width, rectangle3.height - 1);
            this.paintCell(graphics, rectangle3, n, tableColumn, tableColumn, tableColumnModel);
        }
    }

    public static GradientPaint createBackgroundPaint(int n, int n2, int n3, int n4) {
        return new GradientPaint(n, n2, topBgColor, n3, n4, bottomBgColor);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, TableColumn tableColumn, TableColumn tableColumn2, TableColumnModel tableColumnModel) {
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        graphics.setColor(StyleConstants.borderColor);
        graphics.drawLine(rectangle.x - 1, rectangle.y + 2, rectangle.x - 1, rectangle.y + rectangle.height - 4);
        JComponent jComponent = (JComponent)this.getHeaderRenderer(n);
        jComponent.setOpaque(false);
        jComponent.setEnabled(this.header.getTable().isEnabled());
        this.rendererPane.paintComponent(graphics, jComponent, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        if (tableColumn == tableColumn2 || (bl ? n != tableColumnModel.getColumnCount() - 1 : n != 0)) {
            graphics.setColor(WebTableStyle.gridColor);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 4);
        }
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        boolean bl = !this.header.isPaintingForPrint() && this.header.hasFocus();
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, bl, -1, n);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        dimension.height = Math.max(dimension.height, WebTableStyle.headerHeight);
        return dimension;
    }
}

