/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.text.TextComponentLayout;
import com.alee.laf.text.WebTextFieldStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class WebTextFieldUI
extends BasicTextFieldUI
implements ShapeProvider,
SwingConstants {
    private JTextField textField = null;
    private boolean drawBorder = WebTextFieldStyle.drawBorder;
    private boolean drawFocus = WebTextFieldStyle.drawFocus;
    private int round = WebTextFieldStyle.round;
    private boolean drawShade = WebTextFieldStyle.drawShade;
    private int shadeWidth = WebTextFieldStyle.shadeWidth;
    private boolean drawBackground = WebTextFieldStyle.drawBackground;
    private boolean webColored = WebTextFieldStyle.webColored;
    private Painter painter = WebTextFieldStyle.painter;
    private Insets fieldMargin = WebTextFieldStyle.fieldMargin;
    private String inputPrompt = WebTextFieldStyle.inputPrompt;
    private Font inputPromptFont = WebTextFieldStyle.inputPromptFont;
    private Color inputPromptForeground = WebTextFieldStyle.inputPromptForeground;
    private int inputPromptPosition = WebTextFieldStyle.inputPromptPosition;
    private boolean hideInputPromptOnFocus = WebTextFieldStyle.hideInputPromptOnFocus;
    private JComponent leadingComponent = null;
    private JComponent trailingComponent = null;
    private boolean inputPromptSet = false;
    private FocusListener focusListener;
    private PropertyChangeListener accessibleChangeListener;
    private PropertyChangeListener orientationChangeListener;
    private PropertyChangeListener marginChangeListener;
    private ComponentAdapter componentResizeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebTextFieldUI((JTextField)jComponent);
    }

    public WebTextFieldUI(JTextField jTextField) {
        this(jTextField, true);
    }

    public WebTextFieldUI(JTextField jTextField, boolean bl) {
        this.drawBorder = bl;
        this.textField = jTextField;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.textField);
        this.textField.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.textField.setFocusable(true);
        this.textField.setOpaque(false);
        this.textField.setMargin(WebTextFieldStyle.margin);
        this.textField.setBackground(Color.WHITE);
        this.textField.setSelectionColor(StyleConstants.textSelectionColor);
        this.textField.setForeground(Color.BLACK);
        this.textField.setSelectedTextColor(Color.BLACK);
        this.textField.setCaretColor(Color.GRAY);
        this.textField.setLayout(new TextComponentLayout(this.textField));
        this.updateBorder();
        this.focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebTextFieldUI.this.textField.repaint();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                WebTextFieldUI.this.textField.repaint();
            }
        };
        this.textField.addFocusListener(this.focusListener);
        this.accessibleChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebTextFieldUI.this.updateInnerComponents();
            }
        };
        this.textField.addPropertyChangeListener("enabled", this.accessibleChangeListener);
        this.orientationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebTextFieldUI.this.updateBorder();
            }
        };
        this.textField.addPropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.marginChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebTextFieldUI.this.updateBorder();
            }
        };
        this.textField.addPropertyChangeListener("margin", this.marginChangeListener);
        this.componentResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WebTextFieldUI.this.updateBorder();
            }
        };
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.textField.putClientProperty("HANDLES_ENABLE_STATE", null);
        this.textField.removeFocusListener(this.focusListener);
        this.textField.removePropertyChangeListener("enabled", this.accessibleChangeListener);
        this.textField.removePropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.textField.removePropertyChangeListener("margin", this.marginChangeListener);
        this.cleanupLeadingComponent();
        this.cleanupTrailingComponent();
        this.textField.setLayout(null);
        super.uninstallUI(jComponent);
    }

    @Override
    public Shape provideShape() {
        if (this.drawBorder) {
            return LafUtils.getWebBorderShape(this.textField, this.shadeWidth, this.round);
        }
        return SwingUtils.size(this.textField);
    }

    private void updateInnerComponents() {
        if (this.leadingComponent != null) {
            this.leadingComponent.setEnabled(this.textField.isEnabled());
        }
        if (this.trailingComponent != null) {
            this.trailingComponent.setEnabled(this.textField.isEnabled());
        }
    }

    public JComponent getLeadingComponent() {
        return this.leadingComponent;
    }

    public void setLeadingComponent(JComponent jComponent) {
        if (this.leadingComponent == jComponent) {
            return;
        }
        this.cleanupLeadingComponent();
        if (jComponent != null) {
            this.leadingComponent = jComponent;
            this.leadingComponent.addComponentListener(this.componentResizeListener);
            this.textField.add((Component)jComponent, "LEADING");
            this.updateInnerComponents();
        }
        this.updateBorder();
    }

    private void cleanupLeadingComponent() {
        if (this.leadingComponent != null) {
            this.leadingComponent.removeComponentListener(this.componentResizeListener);
            this.textField.remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    public JComponent getTrailingComponent() {
        return this.trailingComponent;
    }

    public void setTrailingComponent(JComponent jComponent) {
        if (this.trailingComponent == jComponent) {
            return;
        }
        this.cleanupTrailingComponent();
        if (jComponent != null) {
            this.trailingComponent = jComponent;
            this.trailingComponent.addComponentListener(this.componentResizeListener);
            this.textField.add((Component)jComponent, "TRAILING");
            this.updateInnerComponents();
        }
        this.updateBorder();
    }

    private void cleanupTrailingComponent() {
        if (this.trailingComponent != null) {
            this.trailingComponent.removeComponentListener(this.componentResizeListener);
            this.textField.remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    public void setFieldMargin(Insets insets) {
        this.fieldMargin = insets;
        this.updateBorder();
    }

    public Insets getFieldMargin() {
        return this.fieldMargin;
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public void setInputPrompt(String string) {
        this.inputPrompt = string;
        this.inputPromptSet = string != null && !string.trim().equals("");
        this.updateInputPromptView();
    }

    public Font getInputPromptFont() {
        return this.inputPromptFont;
    }

    public void setInputPromptFont(Font font) {
        this.inputPromptFont = font;
        this.updateInputPromptView();
    }

    public Color getInputPromptForeground() {
        return this.inputPromptForeground;
    }

    public void setInputPromptForeground(Color color) {
        this.inputPromptForeground = color;
        this.updateInputPromptView();
    }

    public int getInputPromptPosition() {
        return this.inputPromptPosition;
    }

    public void setInputPromptPosition(int n) {
        this.inputPromptPosition = n;
        this.updateInputPromptView();
    }

    public boolean isHideInputPromptOnFocus() {
        return this.hideInputPromptOnFocus;
    }

    public void setHideInputPromptOnFocus(boolean bl) {
        this.hideInputPromptOnFocus = bl;
        this.updateInputPromptView();
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean bl) {
        this.drawShade = bl;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder();
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean bl) {
        this.drawBackground = bl;
        this.updateView();
    }

    public boolean isWebColored() {
        return this.webColored;
    }

    public void setWebColored(boolean bl) {
        this.webColored = bl;
        this.updateView();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
        this.updateView();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.updateBorder();
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean bl) {
        this.drawFocus = bl;
        this.updateView();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
        this.getComponent().setOpaque(painter == null || painter.isOpaque(this.textField));
        this.updateBorder();
    }

    private void updateInputPromptView() {
        if (this.isInputPromptVisible(this.getComponent())) {
            this.updateView();
        }
    }

    private boolean isInputPromptVisible(JTextComponent jTextComponent) {
        return this.inputPromptSet && jTextComponent.isEditable() && jTextComponent.isEnabled() && (!this.hideInputPromptOnFocus || !jTextComponent.isFocusOwner()) && jTextComponent.getText().equals("");
    }

    private void updateView() {
        if (this.textField != null) {
            this.textField.repaint();
        }
    }

    private void updateBorder() {
        if (this.textField != null) {
            JComponent jComponent;
            Insets insets = this.painter != null ? this.painter.getMargin(this.getComponent()) : (this.drawBorder ? new Insets(this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1) : new Insets(0, 0, 0, 0));
            boolean bl = this.textField.getComponentOrientation().isLeftToRight();
            Insets insets2 = this.textField.getMargin();
            if (insets2 != null) {
                insets.top += insets2.top;
                insets.left = insets.left + (bl ? insets2.left : insets2.right);
                insets.bottom += insets2.bottom;
                insets.right = insets.right + (bl ? insets2.right : insets2.left);
            }
            if (this.fieldMargin != null) {
                insets.top += this.fieldMargin.top;
                insets.left = insets.left + (bl ? this.fieldMargin.left : this.fieldMargin.right);
                insets.bottom += this.fieldMargin.bottom;
                insets.right = insets.right + (bl ? this.fieldMargin.right : this.fieldMargin.left);
            }
            JComponent jComponent2 = bl ? this.leadingComponent : this.trailingComponent;
            JComponent jComponent3 = jComponent = bl ? this.trailingComponent : this.leadingComponent;
            if (jComponent2 != null) {
                insets.left += ((Component)jComponent2).getPreferredSize().width;
            }
            if (jComponent != null) {
                insets.right += ((Component)jComponent).getPreferredSize().width;
            }
            this.textField.setBorder(LafUtils.createWebBorder(insets));
        }
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        Object object;
        JTextComponent jTextComponent = this.getComponent();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (jTextComponent.isOpaque() && (this.painter == null || !this.painter.isOpaque(this.textField))) {
            graphics.setColor(jTextComponent.getBackground());
            graphics.fillRect(0, 0, jTextComponent.getWidth(), jTextComponent.getHeight());
        }
        if (this.painter != null || this.drawBorder) {
            object = LafUtils.setupAntialias(graphics2D);
            if (this.painter != null) {
                this.painter.paint(graphics2D, SwingUtils.size(jTextComponent), jTextComponent);
            } else if (this.drawBorder) {
                Color color = this.drawShade ? (this.drawFocus && jTextComponent.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor) : null;
                LafUtils.drawWebStyle(graphics2D, jTextComponent, color, this.shadeWidth, this.round, this.drawBackground, this.webColored);
            }
            LafUtils.restoreAntialias(graphics2D, object);
        }
        object = SwingUtils.setupTextAntialias(graphics2D, (Component)this.textField);
        super.paintSafely(graphics);
        if (this.isInputPromptVisible(jTextComponent)) {
            boolean bl = jTextComponent.getComponentOrientation().isLeftToRight();
            Rectangle rectangle = this.getVisibleEditorRect();
            Shape shape = LafUtils.intersectClip(graphics2D, rectangle);
            graphics2D.setFont(this.inputPromptFont != null ? this.inputPromptFont : jTextComponent.getFont());
            graphics2D.setPaint(this.inputPromptForeground != null ? this.inputPromptForeground : jTextComponent.getForeground());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = this.inputPromptPosition == 0 ? rectangle.x + rectangle.width / 2 - fontMetrics.stringWidth(this.inputPrompt) / 2 : (bl && this.inputPromptPosition == 10 || !bl && this.inputPromptPosition == 11 ? rectangle.x : rectangle.x + rectangle.width - fontMetrics.stringWidth(this.inputPrompt));
            graphics2D.drawString(this.inputPrompt, n, rectangle.y + rectangle.height / 2 + (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
            graphics2D.setClip(shape);
        }
        SwingUtils.restoreTextAntialias(graphics2D, (Map)object);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        ++dimension.width;
        if (this.leadingComponent != null || this.trailingComponent != null) {
            Dimension dimension2 = jComponent.getLayout().preferredLayoutSize(jComponent);
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.painter != null) {
            dimension = SwingUtils.max(dimension, this.painter.getPreferredSize(jComponent));
        }
        return dimension;
    }
}

