/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.EncryptionUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPasswordField;

public class JPasswordFieldSettingsProcessor
extends SettingsProcessor<JPasswordField, String> {
    private ActionListener actionListener;
    private FocusAdapter focusAdapter;

    public JPasswordFieldSettingsProcessor(SettingsProcessorData settingsProcessorData) {
        super(settingsProcessorData);
    }

    @Override
    public String getDefaultValue() {
        String string = (String)super.getDefaultValue();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    protected void doInit(JPasswordField jPasswordField) {
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPasswordFieldSettingsProcessor.this.save();
            }
        };
        jPasswordField.addActionListener(this.actionListener);
        this.focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JPasswordFieldSettingsProcessor.this.save();
            }
        };
        jPasswordField.addFocusListener(this.focusAdapter);
    }

    @Override
    protected void doLoad(JPasswordField jPasswordField) {
        jPasswordField.setText(EncryptionUtils.decrypt((String)this.loadValue()));
    }

    @Override
    protected void doSave(JPasswordField jPasswordField) {
        this.saveValue(EncryptionUtils.encrypt(new String(jPasswordField.getPassword())));
    }

    @Override
    protected void doDestroy(JPasswordField jPasswordField) {
        jPasswordField.removeActionListener(this.actionListener);
        this.actionListener = null;
        jPasswordField.removeFocusListener(this.focusAdapter);
        this.focusAdapter = null;
    }
}

