/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.extended.breadcrumb.BreadcrumbElementType;
import com.alee.extended.breadcrumb.BreadcrumbUtils;
import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.extended.breadcrumb.WebBreadcrumbStyle;
import com.alee.extended.painter.DefaultPainter;
import com.alee.laf.StyleConstants;
import com.alee.utils.ColorUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;

public class BreadcrumbElementPainter<E extends JComponent>
extends DefaultPainter<E> {
    private static final float[] progressFractions = new float[]{0.0f, 0.5f, 1.0f};
    private static final Color progressSideColor = new Color(255, 255, 255, 0);
    private static final Color[] progressFillColors = new Color[]{progressSideColor, new Color(0, 255, 0, 100), progressSideColor};
    private static final Color[] selectedProgressFillColors = new Color[]{progressSideColor, new Color(0, 255, 0, 100), progressSideColor};
    private static final Color[] progressLineColors = new Color[]{progressSideColor, Color.GRAY, progressSideColor};
    private static final float[] shadeFractions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
    private static final Color[] shadeColors = new Color[]{StyleConstants.transparent, StyleConstants.shadeColor, StyleConstants.shadeColor, StyleConstants.transparent};
    private Map<String, GeneralPath> borderShapeCache = new HashMap<String, GeneralPath>();
    private Map<String, Shape> fillShapeCache = new HashMap<String, Shape>();
    private int overlap = WebBreadcrumbStyle.overlap;
    private int shadeWidth = WebBreadcrumbStyle.shadeWidth;
    private Color borderColor = WebBreadcrumbStyle.borderColor;
    private Color disabledBorderColor = WebBreadcrumbStyle.disabledBorderColor;
    private Color bgTop = WebBreadcrumbStyle.bgTop;
    private Color bgBottom = WebBreadcrumbStyle.bgBottom;
    private Color selectedBgColor = WebBreadcrumbStyle.selectedBgColor;
    private BreadcrumbElementType type = BreadcrumbElementType.middle;
    private boolean showProgress = false;
    private float progress = 0.0f;

    public int getOverlap() {
        return this.overlap;
    }

    public void setOverlap(int n) {
        this.overlap = n;
        this.borderShapeCache.clear();
    }

    public BreadcrumbElementType getType() {
        return this.type;
    }

    public void setType(BreadcrumbElementType breadcrumbElementType) {
        this.type = breadcrumbElementType;
        this.borderShapeCache.clear();
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float f) {
        this.progress = Math.min(1.0f, f);
    }

    @Override
    public Insets getMargin(E e) {
        int n;
        if (this.type.equals((Object)BreadcrumbElementType.none)) {
            n = 0;
        } else {
            int n2 = n = this.type.equals((Object)BreadcrumbElementType.start) ? 0 : this.overlap;
        }
        int n3 = this.type.equals((Object)BreadcrumbElementType.none) ? 0 : (this.type.equals((Object)BreadcrumbElementType.end) ? 0 : this.overlap + this.shadeWidth);
        return new Insets(0, n, 0, n3);
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, E e) {
        Object object;
        Rectangle rectangle2;
        Object object2;
        Object object3;
        int n = BreadcrumbUtils.getRound(e);
        boolean bl = ((Component)e).getComponentOrientation().isLeftToRight();
        Object object4 = LafUtils.setupAntialias(graphics2D);
        boolean bl2 = false;
        if (e instanceof AbstractButton) {
            object3 = (AbstractButton)e;
            object2 = ((AbstractButton)object3).getModel();
            bl2 = object2.isPressed() || object2.isSelected();
        }
        object3 = this.getFillShape(e, bl, n);
        if (!this.type.equals((Object)BreadcrumbElementType.end) && !this.type.equals((Object)BreadcrumbElementType.none)) {
            object2 = this.getBorderShape(e, bl);
            rectangle2 = object2.getBounds();
            if (((Component)e).isEnabled() && !bl2) {
                graphics2D.setPaint(new LinearGradientPaint(0.0f, rectangle2.y, 0.0f, rectangle2.y + rectangle2.height, shadeFractions, shadeColors));
                LafUtils.drawShade(graphics2D, (Shape)object2, WebBreadcrumbStyle.shadeType, null, this.shadeWidth);
            }
            graphics2D.setPaint(bl2 ? this.selectedBgColor : new GradientPaint(0.0f, 0.0f, this.bgTop, 0.0f, ((JComponent)e).getHeight(), this.bgBottom));
            graphics2D.fill((Shape)object3);
            if (((Component)e).isEnabled() && bl2) {
                graphics2D.setPaint(new LinearGradientPaint(0.0f, rectangle2.y, 0.0f, rectangle2.y + rectangle2.height, shadeFractions, shadeColors));
                LafUtils.drawShade(graphics2D, (Shape)object2, WebBreadcrumbStyle.shadeType, null, this.shadeWidth, (Shape)object2);
            }
            object = ((Component)e).isEnabled() ? this.borderColor : this.disabledBorderColor;
            Color color = ColorUtils.changeAlpha((Color)object, 20);
            Color[] colorArray = new Color[]{color, object, object, color};
            graphics2D.setPaint(new LinearGradientPaint(0.0f, rectangle2.y, 0.0f, rectangle2.y + rectangle2.height, shadeFractions, colorArray));
            graphics2D.draw((Shape)object2);
        } else {
            graphics2D.setPaint(bl2 ? this.selectedBgColor : new GradientPaint(0.0f, 0.0f, this.bgTop, 0.0f, ((JComponent)e).getHeight(), this.bgBottom));
            graphics2D.fill((Shape)object3);
        }
        if (this.showProgress && this.progress > 0.0f) {
            object2 = this.getProgressFillShape(e, (Shape)object3);
            rectangle2 = object2.getBounds();
            graphics2D.setPaint(this.getProgressPaint(e));
            graphics2D.fill((Shape)object2);
            object = LafUtils.intersectClip(graphics2D, (Shape)object3);
            graphics2D.setPaint(this.getProgressLinePaint(e));
            graphics2D.drawLine(bl ? rectangle2.x + rectangle2.width : rectangle2.x, rectangle2.y, bl ? rectangle2.x + rectangle2.width : rectangle2.x, rectangle2.y + rectangle2.height);
            LafUtils.restoreClip(graphics2D, (Shape)object);
        }
        LafUtils.restoreAntialias(graphics2D, object4);
    }

    private LinearGradientPaint getProgressPaint(E e) {
        boolean bl = false;
        if (e instanceof AbstractButton) {
            ButtonModel buttonModel = ((AbstractButton)e).getModel();
            bl = buttonModel.isPressed() || buttonModel.isSelected();
        }
        return new LinearGradientPaint(0.0f, 0.0f, 0.0f, ((JComponent)e).getHeight(), progressFractions, bl ? selectedProgressFillColors : progressFillColors);
    }

    private LinearGradientPaint getProgressLinePaint(E e) {
        return new LinearGradientPaint(0.0f, 0.0f, 0.0f, ((JComponent)e).getHeight(), progressFractions, progressLineColors);
    }

    public GeneralPath getBorderShape(E e, boolean bl) {
        String string = bl + ":" + ((JComponent)e).getWidth() + "," + ((JComponent)e).getHeight();
        GeneralPath generalPath = this.borderShapeCache.get(string);
        if (generalPath == null) {
            this.borderShapeCache.clear();
            generalPath = this.getBorderShapeImpl(e, bl);
            this.borderShapeCache.put(string, generalPath);
        }
        return generalPath;
    }

    private GeneralPath getBorderShapeImpl(E e, boolean bl) {
        GeneralPath generalPath = new GeneralPath(0);
        if (bl) {
            generalPath.moveTo(((JComponent)e).getWidth() - this.overlap - this.shadeWidth - 1, -1.0f);
            generalPath.lineTo(((JComponent)e).getWidth() - this.shadeWidth - 1, ((JComponent)e).getHeight() / 2);
            generalPath.lineTo(((JComponent)e).getWidth() - this.overlap - this.shadeWidth - 1, ((JComponent)e).getHeight());
        } else {
            generalPath.moveTo(this.shadeWidth + this.overlap, -1.0f);
            generalPath.lineTo(this.shadeWidth, ((JComponent)e).getHeight() / 2);
            generalPath.lineTo(this.shadeWidth + this.overlap, ((JComponent)e).getHeight());
        }
        return generalPath;
    }

    public Shape getFillShape(E e, boolean bl, int n) {
        String string = bl + ":" + n + ":" + ((JComponent)e).getWidth() + "," + ((JComponent)e).getHeight();
        Shape shape = this.fillShapeCache.get(string);
        if (shape == null) {
            this.fillShapeCache.clear();
            shape = this.getFillShapeImpl(e, bl, n);
            this.fillShapeCache.put(string, shape);
        }
        return shape;
    }

    private Shape getFillShapeImpl(E e, boolean bl, int n) {
        int n2 = ((JComponent)e).getWidth();
        int n3 = ((JComponent)e).getHeight();
        boolean bl2 = this.isEncloseLastElement(e);
        if (((Component)e).getParent() != null && ((Component)e).getParent().getComponentCount() == 1 && !bl2) {
            if (n > 0) {
                return new RoundRectangle2D.Double(0.0, 0.0, n2, n3, n, n);
            }
            return SwingUtils.size(e);
        }
        if (!this.type.equals((Object)BreadcrumbElementType.end)) {
            GeneralPath generalPath = new GeneralPath(0);
            if (bl) {
                generalPath.moveTo(n2 - this.overlap - this.shadeWidth - 1, 0.0f);
                generalPath.lineTo(n2 - this.shadeWidth - 1, n3 / 2);
                generalPath.lineTo(n2 - this.overlap - this.shadeWidth - 1, n3);
                if (n > 0 && this.type.equals((Object)BreadcrumbElementType.start)) {
                    generalPath.lineTo(n, n3);
                    generalPath.quadTo(0.0f, n3, 0.0f, n3 - n);
                    generalPath.lineTo(0.0f, n);
                    generalPath.quadTo(0.0f, 0.0f, n, 0.0f);
                } else {
                    generalPath.lineTo(0.0f, n3);
                    generalPath.lineTo(0.0f, 0.0f);
                }
                generalPath.closePath();
            } else {
                generalPath.moveTo(this.shadeWidth + this.overlap, 0.0f);
                generalPath.lineTo(this.shadeWidth, n3 / 2);
                generalPath.lineTo(this.shadeWidth + this.overlap, n3);
                if (n > 0 && this.type.equals((Object)BreadcrumbElementType.start)) {
                    generalPath.lineTo(n2 - n, n3);
                    generalPath.quadTo(n2, n3, n2, n3 - n);
                    generalPath.lineTo(n2, n);
                    generalPath.quadTo(n2, 0.0f, n2 - n, 0.0f);
                } else {
                    generalPath.lineTo(n2, n3);
                    generalPath.lineTo(n2, 0.0f);
                }
                generalPath.closePath();
            }
            return generalPath;
        }
        if (n > 0) {
            GeneralPath generalPath = new GeneralPath(0);
            if (bl) {
                generalPath.moveTo(0.0f, 0.0f);
                generalPath.lineTo(n2 - n, 0.0f);
                generalPath.quadTo(n2, 0.0f, n2, n);
                generalPath.lineTo(n2, n3 - n);
                generalPath.quadTo(n2, n3, n2 - n, n3);
                generalPath.lineTo(0.0f, n3);
            } else {
                generalPath.moveTo(n2, 0.0f);
                generalPath.lineTo(n, 0.0f);
                generalPath.quadTo(0.0f, 0.0f, 0.0f, n);
                generalPath.lineTo(0.0f, n3 - n);
                generalPath.quadTo(0.0f, n3, n, n3);
                generalPath.lineTo(n2, n3);
            }
            generalPath.closePath();
            return generalPath;
        }
        return SwingUtils.size(e);
    }

    private boolean isEncloseLastElement(E e) {
        return ((Component)e).getParent() != null && ((Component)e).getParent() instanceof WebBreadcrumb && ((WebBreadcrumb)((Component)e).getParent()).isEncloseLastElement();
    }

    public Shape getProgressFillShape(E e, Shape shape) {
        boolean bl = ((Component)e).getComponentOrientation().isLeftToRight();
        Area area = new Area(shape);
        Rectangle rectangle = area.getBounds();
        int n = rectangle.width;
        rectangle.width = Math.round((float)n * this.progress);
        rectangle.x = bl ? rectangle.x : rectangle.x + n - rectangle.width;
        area.intersect(new Area(rectangle));
        return area;
    }
}

