/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

public class FloatSpring {
    private float position = 0.0f;
    private float springK;
    private float dampingK;
    private float velocity;

    public FloatSpring(float f, float f2) {
        this.springK = f;
        this.dampingK = f2;
        this.velocity = 0.0f;
    }

    public FloatSpring(float f) {
        this(f, (float)(2.0 * Math.sqrt(f)));
    }

    public void update(float f, float f2) {
        float f3 = this.position - f;
        f3 = f3 * -this.springK - this.velocity * this.dampingK;
        this.velocity += f3 * f2;
        if (Float.isNaN(this.velocity) || Float.isInfinite(this.velocity)) {
            this.velocity = 0.0f;
        }
        this.position += this.velocity * f2;
    }

    public float getDampingK() {
        return this.dampingK;
    }

    public void setDampingK(float f) {
        this.dampingK = f;
    }

    public float getPosition() {
        return this.position;
    }

    public void setPosition(float f) {
        this.position = f;
    }

    public float getSpringK() {
        return this.springK;
    }

    public void setSpringK(float f) {
        this.springK = f;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float f) {
        this.velocity = f;
    }
}

