/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.button.FloatSpring;
import com.alee.laf.StyleConstants;
import com.alee.utils.ImageUtils;
import com.alee.utils.swing.Timer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicButtonUI;

public class WebToolButtonUI
extends BasicButtonUI {
    private int iconSize = 16;
    private int selectedIconSize = 24;
    private Timer animator;

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JToggleButton) {
            final JToggleButton jToggleButton = (JToggleButton)jComponent;
            jToggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (WebToolButtonUI.this.animator != null && WebToolButtonUI.this.animator.isRunning()) {
                        WebToolButtonUI.this.animator.stop();
                    }
                    if (jToggleButton.isSelected() && jToggleButton.getIcon() != null) {
                        final FloatSpring floatSpring = new FloatSpring(16.0f);
                        floatSpring.setPosition(16.0f);
                        WebToolButtonUI.this.animator = new Timer("WebToolButtonUI.animator", (long)StyleConstants.animationDelay, new ActionListener(){
                            private int timeLeft = 0;

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                this.timeLeft += StyleConstants.animationDelay;
                                floatSpring.update(32.0f, (float)this.timeLeft / 1000.0f);
                                WebToolButtonUI.this.iconSize = Math.round(floatSpring.getPosition());
                                jToggleButton.repaint();
                                if (Math.round(floatSpring.getPosition()) == 32) {
                                    WebToolButtonUI.this.animator.stop();
                                }
                            }
                        });
                        WebToolButtonUI.this.animator.start();
                    } else {
                        WebToolButtonUI.this.iconSize = 16;
                    }
                }
            });
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.LIGHT_GRAY);
        graphics2D.drawRect(0, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
        if (buttonModel.isSelected()) {
            graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        super.paint(graphics, jComponent);
    }

    @Override
    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isSelected()) {
            Icon icon;
            Icon icon2 = icon = abstractButton.getSelectedIcon() != null ? abstractButton.getSelectedIcon() : abstractButton.getIcon();
            if (icon instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)icon;
                BufferedImage bufferedImage = ImageUtils.getBufferedImage(imageIcon.getImage());
                bufferedImage = ImageUtils.createPreviewImage(bufferedImage, this.iconSize);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.drawImage(bufferedImage, rectangle.x + rectangle.width / 2 - this.iconSize / 2, rectangle.y + rectangle.height / 2 - this.iconSize / 2, this.iconSize, this.iconSize, null);
            } else {
                super.paintIcon(graphics, jComponent, rectangle);
            }
        } else {
            super.paintIcon(graphics, jComponent, rectangle);
        }
    }
}

